/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fpm.business.service.fundsys.exportandimport.context.BodySysImportContext;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.AbstractBodySystemImportHandler;
import kd.tmc.fpm.common.enums.WaysEnum;

public class SubjectMemberImportHandlerImpl
extends AbstractBodySystemImportHandler {
    public SubjectMemberImportHandlerImpl(BodySysImportContext bodySysImportContext) {
        super(bodySysImportContext);
    }

    @Override
    protected void beforeHandler(List<DynamicObject> dynamicObjectList) {
        dynamicObjectList.sort(Comparator.comparing(dy -> dy.getLong("level")));
    }

    @Override
    protected void doHandler(DynamicObject clone, DynamicObject originalDy) {
        this.register(this.getId(originalDy), clone);
        this.cleanSourceId(clone);
    }

    @Override
    protected void afterHandler(List<DynamicObject> dynamicObjectList) {
        List<DynamicObject> allNewDynamicObjectList = this.getIdPool().getAllNewDynamicObjectList();
        Set<Long> oldIds = this.getIdPool().getOldIds();
        for (Long oldId : oldIds) {
            this.bodySystemImportIdPool.getIdPool("fpm_member").registerNewIdExists(oldId, this.getIdPool().getDynamicObjectByOldId(oldId));
        }
        for (DynamicObject subject : allNewDynamicObjectList) {
            this.fillFormulaInfoIfNeed(subject);
            this.resetProp(subject);
            this.resetOrg(subject);
        }
        super.afterHandler(dynamicObjectList);
    }

    private void fillFormulaInfoIfNeed(DynamicObject subject) {
        String ways = subject.getString("ways");
        if (!Objects.equals(ways, WaysEnum.FORMULA_TERM.getValue())) {
            return;
        }
        subject.set("formulavalue", (Object)this.getNewFormulaValue(subject.getString("formulavalue"), this.getHandleEntity()));
        subject.set("formulavalue_tag", (Object)this.getNewFormulaValue(subject.getString("formulavalue_tag"), this.getHandleEntity()));
    }

    private void resetOrg(DynamicObject subjectDy) {
        DynamicObject systemDy = subjectDy.getDynamicObject("bodysysmanage");
        subjectDy.set("org", systemDy.get("org"));
    }

    private void cleanSourceId(DynamicObject clone) {
        clone.set("sourceid", (Object)0L);
    }

    @Override
    public String getHandleEntity() {
        return "fpm_membersubject";
    }
}

