/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.idpool;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BodySystemImportIdPool {
    private static final IdPool EMPTY_POLL = new IdPool(Collections.emptyMap());
    private final Map<String, IdPool> idPollMap = new HashMap<String, IdPool>(16);

    public IdPool getIdPool(String entityNumber) {
        return this.idPollMap.getOrDefault(entityNumber, EMPTY_POLL);
    }

    public IdPool system() {
        return this.getIdPool("fpm_bodysysmanage");
    }

    public IdPool dimMember() {
        return this.getIdPool("fpm_member");
    }

    public IdPool dimension() {
        return this.getIdPool("fpm_dimension");
    }

    public IdPool register(String entityNumber) {
        return this.idPollMap.computeIfAbsent(entityNumber, k -> new IdPool());
    }

    public Long register(Long oldId, DynamicObject dynamicObject) {
        return this.register(dynamicObject.getDataEntityType().getName()).register(oldId, dynamicObject);
    }

    public Long registerExists(DynamicObject dynamicObject) {
        return this.register(dynamicObject.getDataEntityType().getName()).registerExists(dynamicObject);
    }

    public List<Long> batchRegisterExists(List<DynamicObject> dynamicObjectList) {
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return Collections.emptyList();
        }
        return this.register(dynamicObjectList.get(0).getDataEntityType().getName()).batchRegisterExists(dynamicObjectList);
    }

    public void clear() {
        this.idPollMap.values().forEach(IdPool::clear);
        this.idPollMap.clear();
    }

    static class DynamicObjectHolder {
        private boolean exists;
        private DynamicObject dynamicObject;

        public DynamicObjectHolder(DynamicObject dynamicObject) {
            this.dynamicObject = dynamicObject;
            this.exists = true;
        }

        public DynamicObjectHolder(boolean exists, DynamicObject dynamicObject) {
            this.exists = exists;
            this.dynamicObject = dynamicObject;
        }

        public boolean isExists() {
            return this.exists;
        }

        public void setExists(boolean exists) {
            this.exists = exists;
        }

        public DynamicObject getDynamicObject() {
            return this.dynamicObject;
        }

        public void setDynamicObject(DynamicObject dynamicObject) {
            this.dynamicObject = dynamicObject;
        }
    }

    public static class IdPool {
        private Map<Long, Long> idPool;
        private Map<Long, DynamicObjectHolder> dynamicObjectPool;

        public IdPool() {
            this.idPool = new HashMap<Long, Long>(16);
            this.dynamicObjectPool = new HashMap<Long, DynamicObjectHolder>(16);
        }

        public IdPool(Map<Long, Long> idPool) {
            this.idPool = idPool;
        }

        public Long getId(Long oldId) {
            return this.idPool.getOrDefault(oldId, 0L);
        }

        public Long registerNewIdExists(Long oldId, DynamicObject dynamicObject) {
            if (this.idPool.containsKey(oldId)) {
                return oldId;
            }
            long newId = dynamicObject.getLong("id");
            if (EmptyUtil.isEmpty((Long)newId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6eid\uff0c\u8bf7\u8c03\u7528register\u3002", (String)"BodySystemImportIdPool_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            return this.register(oldId, dynamicObject, newId);
        }

        public Long register(Long oldId, DynamicObject dynamicObject) {
            return this.register(oldId, dynamicObject, 0L);
        }

        public Long register(Long oldId, DynamicObject dynamicObject, Long inputNewId) {
            Long newId = this.idPool.computeIfAbsent(oldId, k -> EmptyUtil.isEmpty((Long)inputNewId) ? Long.valueOf(DB.genGlobalLongId()) : inputNewId);
            this.dynamicObjectPool.computeIfAbsent(newId, k -> new DynamicObjectHolder(EmptyUtil.isNoEmpty((Long)inputNewId), dynamicObject));
            if (EmptyUtil.isEmpty((Long)inputNewId)) {
                dynamicObject.set("id", (Object)newId);
            }
            return newId;
        }

        public DynamicObject getDynamicObject(Long newId) {
            return Optional.ofNullable(this.dynamicObjectPool.get(newId)).orElseGet(() -> new DynamicObjectHolder(null)).getDynamicObject();
        }

        public DynamicObject getDynamicObjectByOldId(Long oldId) {
            return Optional.ofNullable(this.dynamicObjectPool.get(this.idPool.getOrDefault(oldId, 0L))).orElseGet(() -> new DynamicObjectHolder(null)).getDynamicObject();
        }

        public Long registerExists(DynamicObject dynamicObject) {
            return this.register(dynamicObject.getLong("id"), dynamicObject, dynamicObject.getLong("id"));
        }

        public List<Long> batchRegisterExists(List<DynamicObject> dynamicObjectList) {
            if (EmptyUtil.isEmpty(dynamicObjectList)) {
                return Collections.emptyList();
            }
            return dynamicObjectList.stream().map(this::registerExists).collect(Collectors.toList());
        }

        public List<DynamicObject> getAllNewDynamicObjectList() {
            return this.dynamicObjectPool.values().stream().filter(dynamicObjectHolder -> !dynamicObjectHolder.isExists()).map(DynamicObjectHolder::getDynamicObject).collect(Collectors.toList());
        }

        public List<DynamicObject> getAllDynamicObjectList() {
            return this.dynamicObjectPool.values().stream().map(DynamicObjectHolder::getDynamicObject).collect(Collectors.toList());
        }

        public Set<Long> getOldIds() {
            return this.idPool.keySet();
        }

        public void clear() {
            this.dynamicObjectPool.clear();
            this.idPool.clear();
        }
    }
}

