/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.metadata.util.GzipUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.bodysysimport.BodySysImportInfo;
import kd.tmc.fpm.business.service.fundsys.exportandimport.IBodySysImportService;
import kd.tmc.fpm.business.service.fundsys.exportandimport.context.BodySysImportContext;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.IBodySystemImportHandler;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.AuxiliaryFieldImportHandlerImpl;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.BodySysImportHandlerImpl;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.ControlStrategyImportHandlerImpl;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.DetailPlanFieldImportHandlerImpl;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.DimensionImportHandlerImpl;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.DimensionMemberImportHandlerImpl;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.ExecuteTimeImportHandlerImpl;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.InnerCancelRuleImportHandlerImpl;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.MatchRuleImportHandlerImpl;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.MetricMemberImportHandlerImpl;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.ReportCheckRuleImportHandlerImpl;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.ReportReadyImportHandlerImpl;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.SubjectMemberImportHandlerImpl;
import kd.tmc.fpm.business.service.fundsys.exportandimport.handler.impl.TemplateImportHandlerImpl;
import kd.tmc.fpm.business.service.fundsys.exportandimport.idpool.BodySystemImportIdPool;
import org.apache.commons.io.IOUtils;

public class BodySysImportServiceImpl
implements IBodySysImportService {
    private final List<String> urlList;
    private final Map<String, FileInfo> bodySysImportMap;
    private final List<IBodySystemImportHandler> bodySystemImportHandlerList;
    private final BodySysImportContext bodySysImportContext;
    private final Map<String, String> errorInfoMap;
    private IBodySysImportService.Status status;
    private static final Log logger = LogFactory.getLog(String.class);

    public BodySysImportServiceImpl(BodySysImportInfo bodySysImportInfo, List<String> urlList) {
        this.urlList = urlList;
        this.errorInfoMap = new HashMap<String, String>(urlList.size());
        this.bodySysImportMap = new HashMap<String, FileInfo>(urlList.size());
        this.status = IBodySysImportService.Status.SUCCESS;
        this.bodySystemImportHandlerList = new ArrayList<IBodySystemImportHandler>(16);
        BodySystemImportIdPool bodySystemImportIdPool = new BodySystemImportIdPool();
        this.bodySysImportContext = new BodySysImportContext(bodySystemImportIdPool);
        this.bodySystemImportHandlerList.add(new BodySysImportHandlerImpl(this.bodySysImportContext, bodySysImportInfo));
        this.bodySystemImportHandlerList.add(new DimensionImportHandlerImpl(this.bodySysImportContext));
        this.bodySystemImportHandlerList.add(new DimensionMemberImportHandlerImpl(this.bodySysImportContext));
        this.bodySystemImportHandlerList.add(new SubjectMemberImportHandlerImpl(this.bodySysImportContext));
        this.bodySystemImportHandlerList.add(new MetricMemberImportHandlerImpl(this.bodySysImportContext));
        this.bodySystemImportHandlerList.add(new DetailPlanFieldImportHandlerImpl(this.bodySysImportContext));
        this.bodySystemImportHandlerList.add(new AuxiliaryFieldImportHandlerImpl(this.bodySysImportContext));
        this.bodySystemImportHandlerList.add(new TemplateImportHandlerImpl(this.bodySysImportContext));
        this.bodySystemImportHandlerList.add(new InnerCancelRuleImportHandlerImpl(this.bodySysImportContext));
        this.bodySystemImportHandlerList.add(new ReportCheckRuleImportHandlerImpl(this.bodySysImportContext));
        this.bodySystemImportHandlerList.add(new ReportReadyImportHandlerImpl(this.bodySysImportContext));
        this.bodySystemImportHandlerList.add(new MatchRuleImportHandlerImpl(this.bodySysImportContext));
        this.bodySystemImportHandlerList.add(new ExecuteTimeImportHandlerImpl(this.bodySysImportContext));
        this.bodySystemImportHandlerList.add(new ControlStrategyImportHandlerImpl(this.bodySysImportContext));
    }

    @Override
    public void upload() {
        if (EmptyUtil.isEmpty(this.urlList)) {
            return;
        }
        for (String url : this.urlList) {
            try {
                this.doUpload(url);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.addErrorInfo(url, e.getMessage());
            }
        }
    }

    private void addErrorInfo(String url, String message) {
        this.errorInfoMap.putIfAbsent(url, message);
        int size = this.errorInfoMap.size();
        if (size == this.urlList.size()) {
            this.status = IBodySysImportService.Status.FAILED;
            return;
        }
        this.status = IBodySysImportService.Status.SOME_SUCCESS;
    }

    private void doUpload(String url) {
        Map<String, List<DynamicObject>> data = this.getData(url);
        this.registerImportInfo(url, data);
        for (IBodySystemImportHandler bodySystemImportHandler : this.bodySystemImportHandlerList) {
            String handleEntity = bodySystemImportHandler.getHandleEntity();
            List<DynamicObject> dynamicObjectList = data.get(handleEntity);
            if (EmptyUtil.isEmpty(dynamicObjectList)) continue;
            bodySystemImportHandler.handler(dynamicObjectList);
        }
    }

    private void registerImportInfo(String url, Map<String, List<DynamicObject>> data) {
        List<DynamicObject> dynamicObjectList = data.get("fpm_bodysysmanage");
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            logger.warn("\u5bfc\u5165\u6587\u4ef6\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u4f53\u7cfb\u3002");
            return;
        }
        DynamicObject dynamicObject = dynamicObjectList.get(0);
        FileInfo fileInfo = this.bodySysImportMap.computeIfAbsent(url, FileInfo::new);
        fileInfo.setBodySysName(dynamicObject.getString("name"));
        this.bodySysImportContext.switchImportFile(fileInfo.getBodySysName());
    }

    private Map<String, List<DynamicObject>> getData(String url) {
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        try {
            String[] reqParams = new URL(url).getQuery().split("&");
            HashMap<String, String> map = new HashMap<String, String>(16);
            for (String param : reqParams) {
                String[] p = param.split("=");
                map.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
            if (Objects.isNull(content)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u4e34\u65f6\u6587\u4ef6\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"BodySysImportServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            FileInfo fileInfo = this.bodySysImportMap.computeIfAbsent(url, FileInfo::new);
            fileInfo.setFileName(content.getFilename());
            InputStream inputStream = content.getInputStream();
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            String uncompress = GzipUtils.uncompress((String)string, (String)StandardCharsets.UTF_8.name());
            return (Map)SerializationUtils.deSerializeFromBase64((String)uncompress);
        }
        catch (MalformedURLException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u4e0a\u4f20\u6587\u4ef6:\u3010%1$s\u3011\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BodySysImportServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), url));
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    @Override
    public IBodySysImportService.Status getStatus() {
        return this.status.isSuccess() && this.bodySysImportContext.hasError() ? IBodySysImportService.Status.SOME_SUCCESS : this.status;
    }

    @Override
    public List<String> getMessage() {
        ArrayList<String> messageList = new ArrayList<String>(this.urlList.size());
        for (String url : this.urlList) {
            messageList.add(this.getMessage(url));
        }
        return messageList;
    }

    private String getMessage(String url) {
        String msg = this.errorInfoMap.get(url);
        StringBuilder sb = new StringBuilder();
        sb.append(this.bodySysImportMap.get(url).getBodySysName()).append(":");
        if (EmptyUtil.isNoEmpty((String)msg)) {
            sb.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"BodySysImportServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0])).append(",").append(msg);
            return sb.toString();
        }
        sb.append(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"BodySysImportServiceImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
        String errorMsg = this.bodySysImportContext.getErrorMsg(this.bodySysImportMap.get(url).getBodySysName());
        if (EmptyUtil.isNoEmpty((String)errorMsg)) {
            sb.append(",").append(errorMsg);
        }
        return sb.toString();
    }

    static class FileInfo {
        private String url;
        private String fileName;
        private String bodySysName;

        public FileInfo(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getBodySysName() {
            return EmptyUtil.isEmpty((String)this.bodySysName) ? this.fileName : this.bodySysName;
        }

        public void setBodySysName(String bodySysName) {
            this.bodySysName = bodySysName;
        }
    }
}

