/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.metadata.util.GzipUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.service.fundsys.exportandimport.config.BodySystemExportAndImportConfig;
import kd.tmc.fpm.business.service.fundsys.exportandimport.impl.AbstractExportService;
import kd.tmc.fpm.common.helper.ReferenceServiceHelper;
import kd.tmc.fpm.common.result.ReferenceResult;
import org.apache.commons.collections4.MapUtils;

public class BodySystemExportServiceImpl
extends AbstractExportService {
    private List<Long> bodySysIds;
    private static final String EXPORT_FILE_NAME = "%s_%s.json";
    private String fileName;
    private static final Log logger = LogFactory.getLog(BodySystemExportServiceImpl.class);

    public BodySystemExportServiceImpl(List<Long> bodySysIds) {
        this.bodySysIds = bodySysIds;
    }

    private Map<String, List<DynamicObject>> mergeIfNeed(List<ReferenceResult> referenceResultList) {
        Map referenceObjMap;
        Map map = referenceResultList.get(0).getReferenceObjMap();
        Map map2 = referenceObjMap = map == null ? new HashMap(16) : map;
        if (referenceResultList.size() == 1) {
            return referenceObjMap;
        }
        for (int i = 1; i < referenceResultList.size(); ++i) {
            ReferenceResult referenceResult = referenceResultList.get(i);
            Map resultReferenceObjMap = referenceResult.getReferenceObjMap();
            if (MapUtils.isEmpty((Map)resultReferenceObjMap)) continue;
            resultReferenceObjMap.forEach((k, v) -> {
                if (EmptyUtil.isEmpty((Collection)v)) {
                    return;
                }
                referenceObjMap.computeIfAbsent(k, key -> new ArrayList(16)).addAll(v);
            });
        }
        return referenceObjMap;
    }

    @Override
    protected byte[] getExportData() {
        List<ReferenceResult> referenceResultList = this.getReferenceResultList();
        if (EmptyUtil.isEmpty(referenceResultList)) {
            logger.info("\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002{}", this.bodySysIds);
            return null;
        }
        Map<String, List<DynamicObject>> referenceObjMap = this.mergeIfNeed(referenceResultList);
        this.removeNotExportInfo(referenceObjMap);
        this.fillOtherInfo(referenceObjMap);
        List<DynamicObject> dynamicObjectList = referenceObjMap.get("fpm_bodysysmanage");
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            logger.info("\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002{}", this.bodySysIds);
        }
        DynamicObject dynamicObject = dynamicObjectList.get(0);
        String name = dynamicObject.getString("name");
        this.fileName = String.format(EXPORT_FILE_NAME, name, DateUtils.formatString((Date)new Date(), (String)"yyyyMMddHHmmss"));
        referenceObjMap.entrySet().removeIf(entry -> !BodySystemExportAndImportConfig.getExportEntities().contains(entry.getKey()));
        String jsonString = SerializationUtils.serializeToBase64(referenceObjMap);
        try {
            String compress = GzipUtils.compress((String)jsonString, (String)StandardCharsets.UTF_8.name());
            return compress.getBytes(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.info(e.getMessage(), (Object)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private void removeNotExportInfo(Map<String, List<DynamicObject>> referenceObjMap) {
        List dynamicObjectList = referenceObjMap.computeIfAbsent("fpm_member", k -> new ArrayList(16));
        if (EmptyUtil.isEmpty((Collection)dynamicObjectList)) {
            return;
        }
        dynamicObjectList.removeIf(dy -> {
            String dimType = dy.getString("dimtype");
            if (EmptyUtil.isEmpty((String)dimType)) {
                return true;
            }
            if (Objects.equals(dimType, DimensionType.ORG.getNumber())) {
                return true;
            }
            return Objects.equals(dimType, DimensionType.PERIOD.getNumber());
        });
    }

    private void fillOtherInfo(Map<String, List<DynamicObject>> referenceObjMap) {
        Set<String> entityNumbers = referenceObjMap.keySet();
        HashSet<String> stringHashSet = new HashSet<String>(BodySystemExportAndImportConfig.getExportEntities());
        stringHashSet.removeAll(entityNumbers);
        if (EmptyUtil.isEmpty(stringHashSet)) {
            return;
        }
        for (String entityNumber : stringHashSet) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            Optional<BasedataProp> first = dataEntityType.getProperties().stream().filter(iDataEntityProperty -> iDataEntityProperty instanceof BasedataProp).map(BasedataProp.class::cast).filter(baseDataProp -> Objects.equals(baseDataProp.getBaseEntityId(), "fpm_bodysysmanage")).findFirst();
            if (!first.isPresent()) {
                logger.info("\u5143\u6570\u636e\uff1a{}\uff0c\u6ca1\u6709\u4f53\u7cfb\u8fd9\u4e2a\u5c5e\u6027\u3002", (Object)entityNumber);
                continue;
            }
            String name = first.get().getName();
            List list = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])new QFilter[]{new QFilter(name, "in", this.bodySysIds)}, null, (int)-1);
            if (EmptyUtil.isEmpty((Collection)list)) continue;
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
            List dynamicObjectList = referenceObjMap.computeIfAbsent(entityNumber, k -> new ArrayList(16));
            dynamicObjectList.addAll(Arrays.asList(load));
        }
    }

    private List<ReferenceResult> getReferenceResultList() {
        List referenceResults = ReferenceServiceHelper.bodySysReference(this.bodySysIds, (Boolean)true);
        if (EmptyUtil.isEmpty((Collection)referenceResults)) {
            return Collections.emptyList();
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])this.bodySysIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_bodysysmanage"));
        if (load == null || load.length == 0) {
            return Collections.emptyList();
        }
        Map dynamicObjectMap = Arrays.stream(load).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (a, b) -> a));
        for (ReferenceResult referenceResult : referenceResults) {
            HashMap<String, List> referenceObjMap = referenceResult.getReferenceObjMap();
            if (Objects.isNull(referenceObjMap)) {
                referenceObjMap = new HashMap<String, List>(16);
                referenceResult.setReferenceObjMap(referenceObjMap);
            }
            List dynamicObjectList = referenceObjMap.computeIfAbsent("fpm_bodysysmanage", k -> new ArrayList(2));
            dynamicObjectList.add(dynamicObjectMap.get(referenceResult.getSourceId()));
        }
        return referenceResults;
    }

    @Override
    protected String getExportFileName() {
        return this.fileName;
    }
}

