/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.fundsys.exportandimport.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.fundsys.exportandimport.mapper.MapperKey;
import kd.tmc.fpm.business.service.fundsys.exportandimport.mapper.SortKey;

public class DynamicObjectMapper {
    private final MapperKey mapperKey;
    private final SortKey<? extends Comparable<?>> sortKey;
    private final Map<String, List<MapperObjectHolder>> mapperObjectHolderMap;
    private boolean initFlag;
    private Supplier<List<DynamicObject>> supplier;

    public DynamicObjectMapper(MapperKey mapperKey) {
        this(mapperKey, SortKey.DEFAULT_SORT_KEY);
    }

    public DynamicObjectMapper(MapperKey mapperKey, SortKey<? extends Comparable<?>> sortKey) {
        this.mapperKey = mapperKey;
        this.sortKey = sortKey;
        this.mapperObjectHolderMap = new HashMap<String, List<MapperObjectHolder>>(16);
    }

    public void setSupplier(Supplier<List<DynamicObject>> supplier) {
        this.supplier = supplier;
    }

    public void init(String entityName, QFilter ... qFilters) {
        if (this.initFlag) {
            return;
        }
        this.initFlag = true;
        if (Objects.nonNull(this.supplier)) {
            this.doInit(this.supplier.get());
            return;
        }
        List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])qFilters, null, (int)-1);
        if (EmptyUtil.isEmpty((Collection)primaryKeys)) {
            return;
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])primaryKeys.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        this.doInit(Arrays.asList(load));
    }

    private void doInit(List<DynamicObject> dynamicObjectList) {
        if (EmptyUtil.isEmpty(dynamicObjectList)) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjectList) {
            List mapperObjectHolderList = this.mapperObjectHolderMap.computeIfAbsent(this.mapperKey.getKey(dynamicObject), k -> new ArrayList(16));
            mapperObjectHolderList.add(new MapperObjectHolder(dynamicObject, this.mapperKey));
        }
        this.mapperObjectHolderMap.forEach((k, v) -> v.sort(Comparator.comparing(dy -> this.sortKey.getKey(((MapperObjectHolder)dy).dynamicObject))));
    }

    public MapperObjectHolder getMapperObjectHolder(String key) {
        List<MapperObjectHolder> mapperObjectHolders = this.mapperObjectHolderMap.get(key);
        if (EmptyUtil.isEmpty(mapperObjectHolders)) {
            return null;
        }
        return mapperObjectHolders.get(0);
    }

    public List<DynamicObject> getDynamicObjectList() {
        return this.mapperObjectHolderMap.values().stream().flatMap(Collection::stream).map(MapperObjectHolder::getDynamicObject).collect(Collectors.toList());
    }

    public static class MapperObjectHolder {
        private Long id;
        private boolean enable;
        private DynamicObject dynamicObject;
        private String mapperKey;

        public MapperObjectHolder(DynamicObject dynamicObject, MapperKey mapperKey) {
            this.dynamicObject = dynamicObject;
            this.id = dynamicObject.getLong("id");
            this.enable = dynamicObject.getBoolean("enable");
            this.mapperKey = mapperKey.getKey(dynamicObject);
        }

        public MapperObjectHolder(Long id, boolean enable, DynamicObject dynamicObject, String mapperKey) {
            this.id = id;
            this.enable = enable;
            this.dynamicObject = dynamicObject;
            this.mapperKey = mapperKey;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public DynamicObject getDynamicObject() {
            return this.dynamicObject;
        }

        public void setDynamicObject(DynamicObject dynamicObject) {
            this.dynamicObject = dynamicObject;
        }

        public String getMapperKey() {
            return this.mapperKey;
        }

        public void setMapperKey(String mapperKey) {
            this.mapperKey = mapperKey;
        }
    }
}

