/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.ie.gather.convert;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.ie.gather.helper.GatherLoggerHelper;
import kd.tmc.fpm.business.service.ie.gather.model.GatherLogger;
import kd.tmc.fpm.business.service.ie.gather.model.GatherRecord;
import kd.tmc.fpm.business.service.ie.gather.model.IntelligentGatherScheme;
import org.apache.commons.collections.CollectionUtils;

public class GatherLoggerConvert {
    public static DynamicObject convert(GatherLogger logger, DynamicObject user) {
        DynamicObject gatherLoggerDy = TmcDataServiceHelper.newDynamicObject((String)"fpm_collectlog");
        gatherLoggerDy.set("billno", (Object)logger.getBillNo());
        gatherLoggerDy.set("billstatus", (Object)logger.getBillStatus());
        gatherLoggerDy.set("creator", (Object)user);
        gatherLoggerDy.set("modifier", (Object)user);
        gatherLoggerDy.set("auditor", (Object)user);
        gatherLoggerDy.set("auditdate", (Object)logger.getAuditDate());
        gatherLoggerDy.set("modifytime", (Object)logger.getModifyTime());
        gatherLoggerDy.set("createtime", (Object)logger.getCreateTime());
        gatherLoggerDy.set("executedetail", (Object)logger.getExecuteDetail());
        gatherLoggerDy.set("sourcebill", (Object)logger.getSourceBill());
        gatherLoggerDy.set("collectcase", (Object)logger.getCollectCase());
        gatherLoggerDy.set("gathercount", (Object)logger.getGatherCount());
        gatherLoggerDy.set("errorinfo_tag", (Object)logger.getErrorInfo());
        gatherLoggerDy.set("errorinfo", (Object)GatherLoggerHelper.cut(logger.getErrorInfo()));
        Set<Long> orgIds = logger.getApplyOrgIds();
        if (EmptyUtil.isNoEmpty(orgIds)) {
            DynamicObject[] orgs = TmcDataServiceHelper.load((Object[])orgIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
            DynamicObjectCollection memberList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)gatherLoggerDy, (DynamicObjectType)gatherLoggerDy.getDynamicObjectType(), (String)"applyorg", (DynamicObject[])orgs);
            gatherLoggerDy.set("applyorg", (Object)memberList);
        }
        DynamicObjectCollection gatherRecordEntry = gatherLoggerDy.getDynamicObjectCollection("entryentity");
        List<GatherRecord> records = logger.getRecords();
        for (GatherRecord record : records) {
            DynamicObject recordDy = gatherRecordEntry.addNew();
            recordDy.set("sourcebillid", (Object)record.getSourceBillId());
            recordDy.set("execdetail_tag", (Object)record.getExecDetail());
            recordDy.set("execdetail", (Object)GatherLoggerHelper.cut(record.getExecDetail()));
            recordDy.set("executeresult", (Object)record.getExecuteResult());
            recordDy.set("sourcebilleid", (Object)record.getSourceEntryId());
            recordDy.set("sourcebillnumber", (Object)record.getSourceNumber());
        }
        return gatherLoggerDy;
    }

    public static GatherRecord createGatherRecord(DynamicObject bill, String message, Boolean result, Boolean isSourceBill, String numberProp) {
        GatherRecord mutexRecord = new GatherRecord();
        mutexRecord.setExecDetail(message);
        mutexRecord.setExecuteResult(result);
        Long sourceBillId = 0L;
        String sourceNumber = "";
        Long entryId = 0L;
        if (isSourceBill.booleanValue()) {
            sourceBillId = Long.valueOf(bill.getString("id"));
            sourceNumber = bill.getString(numberProp);
        } else {
            sourceBillId = Optional.ofNullable(bill.getLong("sourcebillid")).map(o -> Long.valueOf(o.toString())).orElseGet(() -> 0L);
            sourceNumber = Optional.ofNullable(bill.getString("sourcebillnumber")).map(o -> o).orElseGet(() -> "");
            entryId = Optional.ofNullable(bill.getLong("sourcebillentryid")).map(o -> Long.valueOf(o.toString())).orElseGet(() -> 0L);
        }
        mutexRecord.setSourceBillId(sourceBillId);
        mutexRecord.setSourceNumber(sourceNumber);
        mutexRecord.setSourceEntryId(entryId);
        return mutexRecord;
    }

    public static GatherLogger createGatherLogger(int count, String breakError, List<GatherRecord> records, Set<Long> orgIds, IntelligentGatherScheme scheme) {
        GatherLogger gatherLogger = new GatherLogger();
        gatherLogger.setRecords(records);
        gatherLogger.setErrorInfo(breakError);
        gatherLogger.setGatherCount(count);
        if (CollectionUtils.isNotEmpty(records)) {
            gatherLogger.setGatherCount(records.size());
        }
        gatherLogger.setApplyOrgIds(orgIds);
        Date date = new Date();
        gatherLogger.setBillNo(UUID.randomUUID().toString());
        gatherLogger.setSourceBill(scheme.getSourceBill());
        gatherLogger.setCollectCase(scheme.getId());
        long success = Optional.ofNullable(records).map(o -> o.stream().filter(Objects::nonNull).filter(record -> record.getExecuteResult()).count()).orElseGet(() -> 0L);
        String execDetail = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u91c7\u96c6\u5171\u4ea7\u751f %1$s \u65e5\u5fd7\u8bb0\u5f55\uff0c\u5176\u4e2d\u6210\u529f %2$s \u6761\uff0c\u5931\u8d25 %3$s \u6761", (String)"GatherLoggerConvert_0", (String)"tmc-fpm-business", (Object[])new Object[0]), records.size(), success, (long)records.size() - success);
        gatherLogger.setExecuteDetail(execDetail);
        gatherLogger.setAuditDate(date);
        gatherLogger.setBillStatus("C");
        gatherLogger.setCreateTime(date);
        gatherLogger.setModifyTime(date);
        return gatherLogger;
    }
}

