/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.ie.gather.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BasedataEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.service.ie.gather.model.ApplyOrg;
import kd.tmc.fpm.business.service.ie.gather.model.FieldMapRelation;
import kd.tmc.fpm.business.service.ie.gather.model.IntelligentGatherScheme;
import kd.tmc.fpm.common.enums.GetValueTypeEnum;

public class IEGatherSchemeDataConvert {
    public static List<IntelligentGatherScheme> getSmartCollectScheme(Set<Long> ids) {
        DynamicObject[] schemeDys = TmcDataServiceHelper.load((Object[])ids.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_smartcollect"));
        List<IntelligentGatherScheme> schemes = new ArrayList<IntelligentGatherScheme>(schemeDys.length);
        if (schemeDys.length == 0) {
            return schemes;
        }
        schemes = Arrays.stream(schemeDys).filter(Objects::nonNull).map(IEGatherSchemeDataConvert::convert).collect(Collectors.toList());
        return schemes;
    }

    public static IntelligentGatherScheme convert(DynamicObject smartColSchemeDy) {
        if (smartColSchemeDy == null) {
            return null;
        }
        IntelligentGatherScheme scheme = new IntelligentGatherScheme();
        Long id = Optional.ofNullable(smartColSchemeDy.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> 0L);
        scheme.setId(id);
        scheme.setName(smartColSchemeDy.getString("name"));
        scheme.setNumber(smartColSchemeDy.getString("number"));
        scheme.setTargetBill(smartColSchemeDy.getDynamicObject("targetbill").getString("number"));
        scheme.setSourceBill(smartColSchemeDy.getDynamicObject("sourcebill").getString("number"));
        scheme.setLinkEntity(smartColSchemeDy.getString("linkentity"));
        scheme.setApplyCondiDesc(smartColSchemeDy.getString("applycondition"));
        scheme.setApplyCondi(smartColSchemeDy.getString("saveapplycondition_tag"));
        scheme.setRemark(smartColSchemeDy.getString("remark"));
        BasedataEntityType entityType = (BasedataEntityType)smartColSchemeDy.getDataEntityType();
        if (entityType.findProperty("batchsize") != null) {
            scheme.setBatchSize(smartColSchemeDy.getInt("batchsize"));
        }
        DynamicObjectCollection fieldMapEntryCol = smartColSchemeDy.getDynamicObjectCollection("entry_fieldmapping");
        ArrayList<FieldMapRelation> relations = new ArrayList<FieldMapRelation>(fieldMapEntryCol.size());
        for (DynamicObject fieldRelationDy : fieldMapEntryCol) {
            FieldMapRelation relation = new FieldMapRelation();
            relation.setTargetFieldName(fieldRelationDy.getString("targetfielddesc"));
            relation.setTargetFieldTag(fieldRelationDy.getString("targetfieldprop"));
            relation.setSourceFieldTag(fieldRelationDy.getString("sourcefieldsave"));
            String valType = fieldRelationDy.getString("valtype");
            GetValueTypeEnum valueTypeEnum = GetValueTypeEnum.getValueTypeEnum((String)valType);
            relation.setGetValueType(valueTypeEnum);
            relation.setGetValExpressDesc(fieldRelationDy.getString("getvaluedesc"));
            relation.setCoreProp(fieldRelationDy.getBoolean("sync"));
            relation.setGetValExpress(fieldRelationDy.getString("getvaluesave_tag"));
            relation.setJudgeUniqe(fieldRelationDy.getBoolean("judgeunique"));
            relation.setMustInput(fieldRelationDy.getBoolean("mustinput"));
            relation.setOverLenIntercept(fieldRelationDy.getBoolean("isintercept"));
            relations.add(relation);
        }
        scheme.setFieldMapRelats(relations);
        DynamicObjectCollection orgDys = smartColSchemeDy.getDynamicObjectCollection("entry_applyorg");
        ArrayList<ApplyOrg> orgs = new ArrayList<ApplyOrg>(orgDys.size());
        for (DynamicObject orgDy : orgDys) {
            DynamicObject org = orgDy.getDynamicObject("org");
            ApplyOrg applyOrg = new ApplyOrg();
            applyOrg.setOrgId(org.getLong("id"));
            applyOrg.setName(org.getString("name"));
            applyOrg.setNumber(org.getString("number"));
            orgs.add(applyOrg);
        }
        scheme.setApplyOrgs(orgs);
        return scheme;
    }
}

