/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.ie.gather.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.tmc.fpm.business.service.ie.gather.model.IntelligentGatherScheme;

public class MetadateDealHelper {
    public static Set<String> collectBillAllProp(MainEntityType mainEntityType) {
        HashSet<String> props = new HashSet<String>(10);
        Map allEntities = mainEntityType.getAllEntities();
        for (Map.Entry entity : allEntities.entrySet()) {
            EntityType entityType = (EntityType)entity.getValue();
            if (LinkEntryType.class.isInstance(entityType)) continue;
            if (EntryType.class.isInstance(entityType)) {
                props.add((String)entity.getKey());
            }
            if (!BillEntityType.class.isInstance(entityType)) continue;
            Map fieldMap = entityType.getFields();
            for (Map.Entry dataEntityPropertyEntry : fieldMap.entrySet()) {
                props.add((String)dataEntityPropertyEntry.getKey());
            }
        }
        return props;
    }

    public static Map<String, DynamicProperty> initFieldPropRelation(DynamicObject bill, Set<String> needAttrs) {
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(16);
        if (fldProperties.isEmpty()) {
            DynamicObjectType dType = bill.getDynamicObjectType();
            for (String prop : needAttrs) {
                if (dType.getProperty(prop = prop.split("\\.")[0]) == null) continue;
                fldProperties.put(prop, dType.getProperty(prop));
            }
        }
        if (fldProperties.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f02\u5e38\uff1a\u6e90\u5355\u5355\u636e\u5c5e\u6027\u96c6\u5408\u4e3a\u7a7a", (String)"MetadateDealHelper_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        return fldProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tuple<DynamicObjectCollection, Map<String, DynamicProperty>> toPlainDynamicObject(DataSet dsn, Set<String> attrs, IntelligentGatherScheme scheme) {
        DynamicObjectCollection ret = null;
        HashMap filterProperties = new HashMap(16);
        try {
            RowMeta rowMeta = dsn.getRowMeta();
            DynamicObjectType dt = new DynamicObjectType("PlainObject");
            int fieldCount = rowMeta.getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                Field field = rowMeta.getField(i);
                String fieldName = field.getAlias();
                if (fieldName.isEmpty() || dt.getProperties().containsKey((Object)fieldName)) {
                    fieldName = "Property" + i;
                }
                Class propertyType = field.getDataType().getJavaType();
                fieldName = String.format("%s.%s", scheme.getLinkEntity(), "id").equals(fieldName) ? "entryid" : fieldName.replace(String.format("%s.", scheme.getLinkEntity()), "");
                DynamicSimpleProperty property = new DynamicSimpleProperty(fieldName, propertyType, null);
                property.setEnableNull(field.isNullable());
                dt.registerSimpleProperty(property);
            }
            DynamicSimpleProperty[] properties = (DynamicSimpleProperty[])dt.getProperties().toArray((Object[])new DynamicSimpleProperty[0]);
            ret = new DynamicObjectCollection(dt, null);
            Iterator iter = dsn.iterator();
            while (iter.hasNext()) {
                DynamicObject obj = new DynamicObject(dt, true);
                obj.beginInit();
                Row row = (Row)iter.next();
                for (int i = 0; i < properties.length; ++i) {
                    properties[i].setValueFast((Object)obj, row.get(i));
                }
                obj.endInit();
                ret.add((Object)obj);
            }
            Optional.ofNullable(ret).filter(o -> !o.isEmpty()).ifPresent(doc -> {
                DynamicObjectType dType = doc.getDynamicObjectType();
                attrs.forEach(elem -> {
                    String tureProp = elem;
                    tureProp = String.format("%s.id", scheme.getLinkEntity()).equals(elem) ? "entryid" : elem.replace(String.format("%s.", scheme.getLinkEntity()), "");
                    filterProperties.put(tureProp, dType.getProperty(tureProp));
                });
                doc.forEach(o -> o.getDynamicObjectType().setName(scheme.getSourceBill()));
            });
        }
        finally {
            dsn.close();
        }
        return Tuple.create((Object)ret, filterProperties);
    }
}

