/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.ie.gather.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.ie.gather.model.FieldMapRelation;
import kd.tmc.fpm.business.service.ie.gather.model.IntelligentGatherScheme;
import kd.tmc.fpm.business.service.ie.gather.service.gather.impl.BalancePoolBillGatherServiceImpl;
import kd.tmc.fpm.common.enums.GetValueTypeEnum;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;

public class SchemeGatherHelper {
    public static QFilter assemblyUniqueQFilter(IntelligentGatherScheme scheme, MainEntityType sourceMainEntityType, MainEntityType targetMainEntityType, List<DynamicObject> sourceBills, Map<String, DynamicProperty> fldProperties) throws Exception {
        Map<String, FieldMapRelation> uniqueFieldMap = scheme.getJudgeUniqeFieldMap();
        if (uniqueFieldMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f02\u5e38\uff1a\u6570\u636e\u5224\u65ad\u89c4\u5219\u552f\u4e00\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SchemeGatherHelper_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        DynamicProperty property = sourceMainEntityType.getProperty(scheme.getLinkEntity());
        QFilter uniqueFilter = new QFilter("1", "!=", (Object)1);
        for (DynamicObject sourceBill : sourceBills) {
            QFilter filter = SchemeGatherHelper.assemblyQFilter(uniqueFieldMap, sourceBill, targetMainEntityType, fldProperties);
            uniqueFilter.or(filter);
        }
        return uniqueFilter;
    }

    public static QFilter assemblyQFilter(Map<String, FieldMapRelation> uniqueFieldMap, DynamicObject sourceBill, MainEntityType targetMainEntityType, Map<String, DynamicProperty> fldProperties) throws Exception {
        QFilter filter = new QFilter("1", "=", (Object)1);
        for (Map.Entry<String, FieldMapRelation> uniqueFieldEntry : uniqueFieldMap.entrySet()) {
            FieldMapRelation relation = uniqueFieldEntry.getValue();
            String targetField = uniqueFieldEntry.getKey();
            if (relation.getGetValueType() == GetValueTypeEnum.SOURCE_FIELD && EmptyUtil.isEmpty((String)relation.getSourceFieldTag())) {
                Object value = null;
                if (targetField.equals("sourcebillid")) {
                    value = sourceBill.get("id");
                } else if (targetField.equals("sourcebillentryid")) {
                    value = sourceBill.get("entryid");
                }
                filter.and(targetField, "=", value);
                continue;
            }
            BalancePoolBillGatherServiceImpl gatherService = new BalancePoolBillGatherServiceImpl(targetMainEntityType);
            Object value = gatherService.getValue(relation, sourceBill, fldProperties);
            if (value instanceof DynamicObject) {
                value = ((DynamicObject)value).getPkValue();
            }
            filter.and(targetField, "=", value);
        }
        return filter;
    }

    public static Set<String> collectQueryAttr(IntelligentGatherScheme scheme, MainEntityType sourceMainEntityType, CRCondition applyFilter) {
        HashSet<String> attrs = new HashSet<String>(8);
        IDataEntityProperty property = sourceMainEntityType.findProperty(scheme.getLinkEntity());
        if (property instanceof EntryProp) {
            attrs.add(scheme.getLinkEntity());
        }
        List filterFiledRows = applyFilter.getFilterCondition().getFilterRow();
        Map<String, String> fieldMappingRelation = SchemeGatherHelper.getFieldMappingRelation(scheme.getSourceBill());
        for (Object filterFiledRow : filterFiledRows) {
            String realField;
            String fieldName2 = filterFiledRow.getFieldName();
            String[] splitStrArr = fieldName2.split("\\.");
            if (splitStrArr.length == 0 || !EmptyUtil.isNoEmpty((String)(realField = SchemeGatherHelper.getRealField(fieldName2, fieldMappingRelation)))) continue;
            attrs.add(realField);
        }
        List<FieldMapRelation> fieldMapRelats = scheme.getFieldMapRelats();
        for (FieldMapRelation fieldMapRelate : fieldMapRelats) {
            Object[] exprVariables;
            CRFormula formula;
            String exp;
            String express;
            GetValueTypeEnum valueType = fieldMapRelate.getGetValueType();
            if (GetValueTypeEnum.SOURCE_FIELD == valueType) {
                express = fieldMapRelate.getSourceFieldTag();
                String realField = SchemeGatherHelper.getRealField(express, fieldMappingRelation);
                if (!EmptyUtil.isNoEmpty((String)realField)) continue;
                attrs.add(realField);
                continue;
            }
            if (GetValueTypeEnum.CALC_FORMULA != valueType || StringUtils.isEmpty((CharSequence)(exp = (formula = (CRFormula)FpmSerializeUtil.deserialize((String)(express = fieldMapRelate.getGetValExpress()), CRFormula.class)).getExpression())) || EmptyUtil.isEmpty((Object[])(exprVariables = CalcExprParser.getExprVariables((String)exp)))) continue;
            Arrays.stream(exprVariables).forEach(fieldName -> {
                String realField = SchemeGatherHelper.getRealField(fieldName, fieldMappingRelation);
                attrs.add(realField);
            });
        }
        String billNo = ((BillEntityType)sourceMainEntityType).getBillNo();
        attrs.add(billNo);
        attrs.add("id");
        if (!scheme.getLinkEntity().equals(scheme.getSourceBill())) {
            attrs.add(String.format("%s.%s", scheme.getLinkEntity(), "id"));
        }
        return attrs;
    }

    private static String getRealField(String prop, Map<String, String> propEntryRelationMap) {
        String[] splitStrArr = prop.split("\\.");
        String billProp = splitStrArr[0];
        boolean exist = propEntryRelationMap.containsKey(billProp);
        if (exist) {
            prop = String.format("%s.%s", propEntryRelationMap.get(billProp), prop);
        }
        return prop;
    }

    public static Map<String, String> getFieldMappingRelation(String billSign) {
        Map allEntities = EntityMetadataCache.getDataEntityType((String)billSign).getAllEntities();
        HashMap<String, String> propEntryRelationMap = new HashMap<String, String>(16);
        for (Map.Entry entry : allEntities.entrySet()) {
            EntityType entityType = (EntityType)entry.getValue();
            if (entityType instanceof LinkEntryType) continue;
            String prefix = "";
            if (!billSign.equals(entry.getKey())) {
                prefix = (String)entry.getKey();
            }
            Map fields = entityType.getFields();
            for (Map.Entry fieldEntry : fields.entrySet()) {
                String field = (String)fieldEntry.getKey();
                if (!EmptyUtil.isNoEmpty((String)prefix)) continue;
                propEntryRelationMap.put(field, prefix);
            }
        }
        return propEntryRelationMap;
    }
}

