/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.ie.gather.service.gather;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.ie.gather.convert.GatherLoggerConvert;
import kd.tmc.fpm.business.service.ie.gather.helper.GatherLoggerHelper;
import kd.tmc.fpm.business.service.ie.gather.helper.MetadateDealHelper;
import kd.tmc.fpm.business.service.ie.gather.model.GatherRecord;
import kd.tmc.fpm.business.service.ie.gather.model.IntelligentGatherScheme;
import kd.tmc.fpm.business.service.ie.gather.service.gather.impl.BalancePoolBillGatherServiceImpl;
import kd.tmc.fpm.business.service.ie.gather.service.gather.impl.BalancePoolDiscardService;
import kd.tmc.fpm.business.utils.CommonUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FpmCollectTransfer {
    private static final Log logger = LogFactory.getLog(FpmCollectTransfer.class);
    private IntelligentGatherScheme scheme;
    private DynamicObject user;
    private Date syncTime;

    public FpmCollectTransfer(IntelligentGatherScheme scheme, DynamicObject user, Date syncTime) {
        this.scheme = scheme;
        this.user = user;
        this.syncTime = syncTime;
    }

    public List<GatherRecord> transfer(DynamicObject[] sourceBills, Map<String, DynamicProperty> fldProperties) {
        DynamicObject[] balancePoolBillArr;
        MainEntityType targetMainEntityType = MetadataServiceHelper.getDataEntityType((String)this.scheme.getTargetBill());
        MainEntityType sourceMainEntityType = MetadataServiceHelper.getDataEntityType((String)this.scheme.getSourceBill());
        Set<String> targetAllProps = MetadateDealHelper.collectBillAllProp(targetMainEntityType);
        ArrayList<GatherRecord> records = new ArrayList<GatherRecord>(10);
        String numberProp = ((BillEntityType)sourceMainEntityType).getBillNo();
        List sourceIdList = Arrays.stream(sourceBills).map(o -> o.getLong("id")).collect(Collectors.toList());
        QFilter sourceIdFilter = new QFilter("sourcebillid", "in", sourceIdList);
        QFilter sourceBillTypeFilter = new QFilter("sourcebill", "=", (Object)this.scheme.getSourceBill());
        DynamicObject[] idWithDiscardStatus = TmcDataServiceHelper.load((String)this.scheme.getTargetBill(), (String)String.join((CharSequence)",", "id", "abandonstatus", "discard", "sourcebillid", "sourcebillentryid"), (QFilter[])new QFilter[]{sourceBillTypeFilter, sourceIdFilter});
        HashSet<Long> discardSourceIdSet = new HashSet<Long>();
        HashSet<Long> existIdSet = new HashSet<Long>();
        HashSet<Long> existEntryIdSet = new HashSet<Long>();
        for (DynamicObject dynamicObject : idWithDiscardStatus) {
            long id = dynamicObject.getLong("id");
            long sourceId = dynamicObject.getLong("sourcebillid");
            long sourceEntryId = dynamicObject.getLong("sourcebillentryid");
            boolean abandon = dynamicObject.getBoolean("abandonstatus");
            boolean discard = dynamicObject.getBoolean("discard");
            if (abandon && !discard) {
                discardSourceIdSet.add(sourceId);
                continue;
            }
            existIdSet.add(id);
            if (sourceEntryId == 0L) continue;
            existEntryIdSet.add(sourceEntryId);
        }
        try {
            balancePoolBillArr = BusinessDataServiceHelper.load((String)this.scheme.getTargetBill(), (String)targetAllProps.stream().collect(Collectors.joining(",")), (QFilter[])new QFilter[]{new QFilter("id", "in", existIdSet)});
        }
        catch (Exception e) {
            if (e.getMessage().contains("You might need to add explicit type casts")) {
                String errMsg = ResManager.loadKDString((String)"\u6570\u636e\u5224\u65ad\u89c4\u5219\u552f\u4e00\u503c\u5b57\u6bb5\u67e5\u8be2\u76ee\u6807\u5355\u6570\u636e\u5f02\u5e38\uff0c\u53ef\u80fd\u539f\u56e0\u662f\u65b9\u6848\u914d\u7f6e\u4e2d\u6765\u6e90\u503c\u548c\u76ee\u6807\u5355\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\u5bfc\u81f4\uff0c\u8bf7\u68c0\u67e5\u3010%1$s\u3011\u667a\u80fd\u91c7\u96c6\u65b9\u6848\u914d\u7f6e\u3002\r\n \u5f02\u5e38\u4fe1\u606f\uff1a%2$s", (String)"FpmCollectTransfer_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
                throw new KDBizException(String.format(errMsg, this.scheme.getName(), ExceptionUtils.getStackTrace((Throwable)e)));
            }
            throw e;
        }
        ArrayList<DynamicObject> saveBills = new ArrayList<DynamicObject>(10);
        List<Object> updateBills = new ArrayList(10);
        logger.info("\u5f00\u59cb\u91c7\u96c6\u6d41\u7a0b");
        for (DynamicObject sourceBill : sourceBills) {
            try {
                DynamicObject newBill;
                BalancePoolBillGatherServiceImpl gatherService = new BalancePoolBillGatherServiceImpl(balancePoolBillArr, fldProperties, targetMainEntityType, sourceMainEntityType, this.user);
                Tuple gathers = gatherService.gather(this.scheme, sourceBill);
                DynamicObject updateBill = (DynamicObject)gathers.item1;
                if (EmptyUtil.isNoEmpty((DynamicObject)updateBill)) {
                    updateBill.set("synctime", (Object)this.syncTime);
                    updateBills.add(updateBill);
                }
                if (!EmptyUtil.isNoEmpty((DynamicObject)(newBill = (DynamicObject)gathers.item2))) continue;
                long sourceId = newBill.getLong("sourcebillid");
                long sourceEntryId = newBill.getLong("sourcebillentryid");
                boolean repeat = false;
                if (discardSourceIdSet.contains(sourceId)) {
                    repeat = true;
                } else if (sourceEntryId != 0L) {
                    repeat = existEntryIdSet.contains(sourceEntryId);
                } else if (existIdSet.contains(sourceId)) {
                    repeat = true;
                }
                if (repeat) {
                    newBill.set("repeatcollect", (Object)"1");
                }
                newBill.set("synctime", (Object)this.syncTime);
                saveBills.add(newBill);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%1$s\u3011\u91c7\u96c6\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a\n %2$s", (String)"FpmCollectTransfer_1", (String)"tmc-fpm-business", (Object[])new Object[0]), sourceBill.getString("id"), ExceptionUtils.getStackTrace((Throwable)e));
                GatherRecord gatherRecord = GatherLoggerConvert.createGatherRecord(sourceBill, message, Boolean.FALSE, true, numberProp);
                records.add(gatherRecord);
            }
        }
        boolean bl = !this.scheme.getLinkEntity().equals(this.scheme.getSourceBill());
        this.discardBalancePoolBill(balancePoolBillArr, sourceBills, bl);
        logger.info("\u91c7\u96c6\u5b8c\u6210");
        updateBills = CommonUtils.getDistinctList(updateBills, DataEntityBase::getPkValue);
        if (EmptyUtil.isNoEmpty(updateBills)) {
            OperationResult updateResult = TmcOperateServiceHelper.execOperate((String)"save", (String)this.scheme.getTargetBill(), (DynamicObject[])updateBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            List<GatherRecord> upRecords = GatherLoggerHelper.gatherExecLogger("update-op", updateResult, updateBills, numberProp);
            records.addAll(upRecords);
        }
        if (EmptyUtil.isNoEmpty(saveBills)) {
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)this.scheme.getTargetBill(), (DynamicObject[])saveBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            List<GatherRecord> saRecords = GatherLoggerHelper.gatherExecLogger("save-op", saveResult, saveBills, numberProp);
            records.addAll(saRecords);
        }
        logger.info("{} \u91c7\u96c6\u65b9\u6848\u91c7\u96c6\u6570\u636e\u7ed3\u675f\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)this.scheme.getName(), (Object)DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd HH:mm:ss"));
        return records;
    }

    private void discardBalancePoolBill(DynamicObject[] balancePoolBillArr, DynamicObject[] sourceBills, boolean collectEntry) {
        Map<Long, List<DynamicObject>> sourceBillMap = Arrays.stream(sourceBills).filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getLong("id")));
        Map<Long, List<DynamicObject>> balancePoolBillMap = Arrays.stream(balancePoolBillArr).filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getLong("sourcebillid")));
        HashSet discardBalancePoolBillIdSet = Sets.newHashSetWithExpectedSize((int)8);
        for (Map.Entry<Long, List<DynamicObject>> mapEntry : balancePoolBillMap.entrySet()) {
            Long sourceBillId = mapEntry.getKey();
            if (!sourceBillMap.containsKey(sourceBillId)) {
                Set billIdSet = mapEntry.getValue().stream().filter(Objects::nonNull).map(bill -> bill.getLong("id")).collect(Collectors.toSet());
                discardBalancePoolBillIdSet.addAll(billIdSet);
                continue;
            }
            if (!collectEntry) continue;
            List<DynamicObject> sourceBillEntryRows = sourceBillMap.get(sourceBillId);
            Set sourceBillEntryRowIdSet = sourceBillEntryRows.stream().filter(Objects::nonNull).filter(entryRow -> entryRow.containsProperty("entryid")).map(entryRow -> entryRow.getLong("entryid")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
            List<DynamicObject> balancePoolBills = mapEntry.getValue();
            Set noneExistSourceDataBillIdSet = balancePoolBills.stream().filter(Objects::nonNull).filter(bill -> {
                Long sourceBillEntryId = bill.getLong("sourcebillentryid");
                if (EmptyUtil.isEmpty((Long)sourceBillEntryId)) {
                    return false;
                }
                return !sourceBillEntryRowIdSet.contains(sourceBillEntryId);
            }).map(bill -> bill.getLong("id")).collect(Collectors.toSet());
            discardBalancePoolBillIdSet.addAll(noneExistSourceDataBillIdSet);
        }
        BalancePoolDiscardService.getInstance().discard(discardBalancePoolBillIdSet, this.syncTime);
    }
}

