/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.ie.gather.service.gather.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.ie.gather.model.FieldMapRelation;
import kd.tmc.fpm.business.service.ie.gather.model.IntelligentGatherScheme;
import kd.tmc.fpm.business.service.ie.gather.service.gather.IGatherService;
import kd.tmc.fpm.common.enums.GetValueTypeEnum;
import kd.tmc.fpm.common.enums.InoutCollectApplyStatusEnum;
import kd.tmc.fpm.common.enums.InoutCollectApprovalStatusEnum;
import kd.tmc.fpm.common.enums.InoutCollectBusinessTypeEnum;
import kd.tmc.fpm.common.enums.InoutCollectDataSourceEnum;
import kd.tmc.fpm.common.property.InOutPlanCollectProp;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang3.tuple.Pair;

public class BalancePoolBillGatherServiceImpl
implements IGatherService<DynamicObject> {
    private static final Log logger = LogFactory.getLog(BalancePoolBillGatherServiceImpl.class);
    private DynamicObject[] balancePoolBillArr;
    private Map<String, DynamicProperty> fldProperties;
    private MainEntityType targetMainEntityType;
    private MainEntityType sourceMainEntityType;
    private DynamicObject currUser;

    public BalancePoolBillGatherServiceImpl(DynamicObject[] balancePoolBillArr, Map<String, DynamicProperty> fldProperties, MainEntityType targetMainEntityType, MainEntityType sourceMainEntityType, DynamicObject currUser) {
        this.balancePoolBillArr = balancePoolBillArr;
        this.fldProperties = fldProperties;
        this.targetMainEntityType = targetMainEntityType;
        this.sourceMainEntityType = sourceMainEntityType;
        this.currUser = currUser;
    }

    public BalancePoolBillGatherServiceImpl(MainEntityType targetMainEntityType) {
        this.targetMainEntityType = targetMainEntityType;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object getValue(FieldMapRelation mappingRelation, DynamicObject sourceBill, Map<String, DynamicProperty> fldProperties, Map<String, String> mulitTypeMappingRelations, String schemeName) throws Exception {
        Object value = IGatherService.super.getValue(mappingRelation, sourceBill, fldProperties);
        String targetField = mappingRelation.getTargetFieldTag();
        IDataEntityProperty property = this.targetMainEntityType.findProperty(targetField);
        BillEntityType type = (BillEntityType)MetadataServiceHelper.getDataEntityType((String)sourceBill.getDataEntityType().getName());
        String number = sourceBill.getString(type.getBillNo());
        String billLCName = type.getDisplayName().getLocaleValue();
        BiFunction<String, Object, Object> baseDataPropDealFunction = (baseDataType, sourceValue) -> {
            DynamicObject[] bills = null;
            if (sourceValue instanceof String) {
                bills = TmcDataServiceHelper.load((String)baseDataType, (String)String.join((CharSequence)",", "id", "name"), (QFilter[])new QFilter[]{new QFilter("name", "=", sourceValue)});
            } else if (sourceValue instanceof Long) {
                bills = TmcDataServiceHelper.load((String)baseDataType, (String)String.join((CharSequence)",", "id", "name"), (QFilter[])new QFilter[]{new QFilter("id", "=", sourceValue)});
            }
            if (bills != null && bills.length > 0) {
                return bills[0];
            }
            return null;
        };
        if (property instanceof BasedataProp) {
            if (property instanceof ItemClassProp) {
                String typePropName = ((ItemClassProp)property).getTypePropName();
                String basedataType = mulitTypeMappingRelations.get(typePropName);
                if (EmptyUtil.isEmpty((String)basedataType) || value == null) {
                    String ceMsg = ResManager.loadKDString((String)"\r\n%1$s\u5355\u636e\u3010%2$s\u3011\u7684\u8bb0\u5f55\u540c\u6b65\u91c7\u96c6\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\u3010%3$s\u3011\u76ee\u6807\u5b57\u6bb5\u8bbe\u7f6e\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u667a\u80fd\u65b9\u6848\u914d\u7f6e\u3002\r\n \u8f6c\u6362\u5f02\u5e38\u4fe1\u606f\uff1a\u6b64\u7c7b\u578b\u4e3a\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7c7b\u522b\u7c7b\u578b\u3002", (String)"BalancePoolBillGatherServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    throw new KDBizException(String.format(ceMsg, billLCName, number, property.getDisplayName()));
                }
                value = baseDataPropDealFunction.apply(basedataType, value);
            } else {
                BasedataProp targetProp = (BasedataProp)property;
                String targetBaseEntityId = targetProp.getBaseEntityId();
                value = baseDataPropDealFunction.apply(targetBaseEntityId, value);
            }
        } else if (property instanceof TextProp) {
            String valStr = null;
            valStr = value instanceof DynamicObject ? Optional.ofNullable((DynamicObject)value).map(o -> o.getString("name")).orElseGet(() -> "") : Optional.ofNullable(value).map(o -> o.toString()).orElseGet(() -> "");
            int maxLenth = ((TextProp)property).getMaxLenth();
            if (valStr.length() < maxLenth) {
                value = valStr;
            } else {
                if (!mappingRelation.isOverLenIntercept()) {
                    String ceMsg = ResManager.loadKDString((String)"\r\n%1$s\u5355\u636e\u3010%2$s\u3011\u7684\u8bb0\u5f55\u540c\u6b65\u91c7\u96c6\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\u3010%3$s\u3011\u5b57\u6bb5\u503c\u8d85\u957f\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BalancePoolBillGatherServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    throw new KDBizException(String.format(ceMsg, billLCName, number, property.getDisplayName()));
                }
                value = valStr.substring(0, maxLenth - 1);
            }
        } else if (property instanceof ItemClassTypeProp && value != null && EmptyUtil.isNoEmpty((Object)value)) {
            mulitTypeMappingRelations.put(targetField, value.toString());
        }
        boolean mustInput = mappingRelation.isMustInput();
        if (mustInput && EmptyUtil.isEmpty((Object)value)) {
            String ceMsg = ResManager.loadKDString((String)"\r\n%1$s\u5355\u636e\u3010%2$s\u3011\u7684\u8bb0\u5f55\u540c\u6b65\u91c7\u96c6\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\u3010%3$s\u3011\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u4f46\u503c\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BalancePoolBillGatherServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(ceMsg, billLCName, number, property.getDisplayName()));
        }
        return value;
    }

    @Override
    public Tuple<DynamicObject, DynamicObject> gather(IntelligentGatherScheme scheme, DynamicObject sourcebill) throws Exception {
        DynamicObject updateBill = null;
        DynamicObject saveBill = null;
        Tuple<Boolean, DynamicObject> result = this.mapping(scheme, sourcebill);
        this.manualAssignVal((DynamicObject)result.item2, scheme, sourcebill, (Boolean)result.item1);
        if (((Boolean)result.item1).booleanValue()) {
            updateBill = (DynamicObject)result.item2;
        } else {
            saveBill = (DynamicObject)result.item2;
        }
        return Tuple.create((Object)updateBill, (Object)saveBill);
    }

    private void manualAssignVal(DynamicObject balancePoolBill, IntelligentGatherScheme scheme, DynamicObject sourcebill, boolean isUpdate) {
        if (isUpdate) {
            balancePoolBill.set("modifier", (Object)this.currUser);
            balancePoolBill.set("modifytime", (Object)new Date());
            balancePoolBill.set("discard", (Object)"0");
            balancePoolBill.set("abandonstatus", (Object)"0");
            balancePoolBill.set("abandonreason", (Object)"");
        } else {
            balancePoolBill.set("creator", (Object)this.currUser);
            balancePoolBill.set("createtime", (Object)new Date());
            balancePoolBill.set("createdate", (Object)new Date());
            balancePoolBill.set("approvalstatus", (Object)InoutCollectApprovalStatusEnum.NOT_APPROVAL.getCode());
            balancePoolBill.set("applystatus", (Object)InoutCollectApplyStatusEnum.NOT_APPLY.getCode());
            balancePoolBill.set("applyuser", (Object)this.currUser);
            balancePoolBill.set("name", (Object)" ");
            balancePoolBill.set("billno", null);
        }
        this.setIfAbsent(balancePoolBill, "businesstype", InoutCollectBusinessTypeEnum.INOUT_PLAN_APPLY.getCode());
        this.setIfAbsent(balancePoolBill, "currentplandate", balancePoolBill.get("expectdate"));
        this.setIfAbsent(balancePoolBill, "currentplanamount", balancePoolBill.get("expectcashamount"));
        this.setIfAbsent(balancePoolBill, "billstatus", BillStatusEnum.SAVE.getValue());
        balancePoolBill.set("datasource", (Object)InoutCollectDataSourceEnum.INTELLIGENT_COLLECT.getCode());
        balancePoolBill.set("sourcebill", (Object)scheme.getSourceBill());
        balancePoolBill.set("sourcebillnumber", (Object)sourcebill.getString(((BillEntityType)this.sourceMainEntityType).getBillNo()));
        balancePoolBill.set("sourcebillid", (Object)sourcebill.getLong("id"));
        Long entryId = 0L;
        if (!scheme.getLinkEntity().equals(scheme.getSourceBill())) {
            entryId = sourcebill.getLong("entryid");
        }
        balancePoolBill.set("sourcebillentryid", (Object)entryId);
        if (isUpdate) {
            String batchNo = balancePoolBill.getString("batchno");
            if (EmptyUtil.isEmpty((String)batchNo)) {
                batchNo = String.format("%s-%s", balancePoolBill.getString("billno"), 1);
            } else {
                Long serialNumber;
                String[] batchSplitArr = batchNo.split("-");
                Long l = serialNumber = Long.valueOf(batchSplitArr[batchSplitArr.length - 1]);
                Long l2 = serialNumber = Long.valueOf(serialNumber + 1L);
                batchSplitArr[batchSplitArr.length - 1] = serialNumber.toString();
                batchNo = Arrays.stream(batchSplitArr).collect(Collectors.joining("-"));
            }
            balancePoolBill.set("batchno", (Object)batchNo);
        }
    }

    private Tuple<Boolean, DynamicObject> mapping(IntelligentGatherScheme scheme, DynamicObject sourcebill) throws Exception {
        DynamicObject balancePoolBill = null;
        Boolean isUpdate = Boolean.FALSE;
        HashMap<String, String> mulitTypeMappingRelations = new HashMap<String, String>(16);
        Map<String, FieldMapRelation> judgeUniqeFieldMap = scheme.getJudgeUniqeFieldMap();
        HashMap<String, Object> uniqueFieldAndValMap = new HashMap<String, Object>(16);
        for (Map.Entry<String, FieldMapRelation> uniqueFieldEntry : judgeUniqeFieldMap.entrySet()) {
            FieldMapRelation relation = uniqueFieldEntry.getValue();
            String targetField = uniqueFieldEntry.getKey();
            Object value = null;
            if (relation.getGetValueType() == GetValueTypeEnum.SOURCE_FIELD && EmptyUtil.isEmpty((String)relation.getSourceFieldTag())) {
                if (targetField.equals("sourcebillid")) {
                    value = sourcebill.get("id");
                } else if (targetField.equals("sourcebillentryid")) {
                    value = sourcebill.get("entryid");
                }
            } else {
                value = this.getValue(relation, sourcebill, this.fldProperties, mulitTypeMappingRelations, scheme.getName());
            }
            uniqueFieldAndValMap.put(targetField, value);
        }
        Pair<Boolean, DynamicObject> findPair = this.find(uniqueFieldAndValMap);
        if (((Boolean)findPair.getKey()).booleanValue()) {
            balancePoolBill = (DynamicObject)findPair.getValue();
            isUpdate = Boolean.TRUE;
        } else {
            balancePoolBill = TmcDataServiceHelper.newDynamicObject((String)scheme.getTargetBill());
        }
        List<FieldMapRelation> fieldMapRelats = scheme.getFieldMapRelats();
        fieldMapRelats.sort((o1, o2) -> {
            IDataEntityProperty property1 = this.targetMainEntityType.findProperty(o1.getTargetFieldTag());
            IDataEntityProperty property2 = this.targetMainEntityType.findProperty(o2.getTargetFieldTag());
            boolean prop1IsItemClass = property1 instanceof ItemClassTypeProp;
            boolean prop2IsItemClass = property2 instanceof ItemClassTypeProp;
            if (prop1IsItemClass) {
                return -1;
            }
            if (prop2IsItemClass) {
                return 1;
            }
            return 0;
        });
        for (FieldMapRelation fieldMapRelat : fieldMapRelats) {
            GetValueTypeEnum valueType;
            String targetProp = fieldMapRelat.getTargetFieldTag();
            if (isUpdate.booleanValue() && (!fieldMapRelat.isCoreProp() || InOutPlanCollectProp.CONST_VAL_PROPS.contains(targetProp)) || GetValueTypeEnum.SOURCE_FIELD == (valueType = fieldMapRelat.getGetValueType()) && EmptyUtil.isEmpty((String)fieldMapRelat.getSourceFieldTag()) || GetValueTypeEnum.CALC_FORMULA == valueType && EmptyUtil.isEmpty((String)fieldMapRelat.getGetValExpress())) continue;
            Object value = this.getValue(fieldMapRelat, sourcebill, this.fldProperties, mulitTypeMappingRelations, scheme.getName());
            String targetFieldTag = fieldMapRelat.getTargetFieldTag();
            IDataEntityProperty property = this.targetMainEntityType.findProperty(targetFieldTag);
            if (value == null) {
                if (property instanceof DecimalProp) {
                    value = BigDecimal.ZERO;
                } else if (property instanceof TextProp) {
                    value = "";
                }
            }
            try {
                balancePoolBill.set(targetProp, value);
            }
            catch (ConversionException ce) {
                String ceMsg = ResManager.loadKDString((String)"\r\n%1$s \u65b9\u6848\u7684 %2$s \u76ee\u6807\u5b57\u6bb5\u8bbe\u7f6e\u7c7b\u578b\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u667a\u80fd\u65b9\u6848\u914d\u7f6e\u3002\r\n \u8f6c\u6362\u5f02\u5e38\u4fe1\u606f\uff1a%1$s", (String)"BalancePoolBillGatherServiceImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]);
                throw new KDBizException(String.format(ceMsg, scheme.getName(), property.getDisplayName(), ce.getMessage()));
            }
            catch (Exception e) {
                throw e;
            }
        }
        return Tuple.create((Object)isUpdate, (Object)balancePoolBill);
    }

    private Pair<Boolean, DynamicObject> find(Map<String, Object> uniqueFieldAndValMap) {
        Optional<DynamicObject> first = Arrays.stream(this.balancePoolBillArr).filter(Objects::nonNull).filter(targetbill -> {
            Boolean result = Boolean.TRUE;
            for (Map.Entry entry : uniqueFieldAndValMap.entrySet()) {
                Object matchPropValue;
                Object targerPropValue;
                Object parseVal = entry.getValue();
                Object targetVal = targetbill.get((String)entry.getKey());
                IDataEntityProperty property = this.targetMainEntityType.findProperty((String)entry.getKey());
                if (parseVal == null && targetVal != null || parseVal != null && targetbill == null) {
                    result = Boolean.FALSE;
                } else if (parseVal == null && targetVal == null) {
                    result = Boolean.TRUE;
                } else if (targetVal instanceof DynamicObject) {
                    if (!(parseVal instanceof DynamicObject)) {
                        String cvMsg = ResManager.loadKDString((String)"\u6570\u636e\u5339\u914d\u5f02\u5e38\uff0c\u76ee\u6807\u5355%1$s\u5b57\u6bb5\u4e3a\u57fa\u7840\u8d44\u6599\u7c7b\u578b\uff0c\u6765\u6e90\u89e3\u6790\u503c\u4e0d\u4e3a\u57fa\u7840\u8d44\u6599\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u91c7\u96c6\u65b9\u6848\u914d\u7f6e", (String)"BalancePoolBillGatherServiceImpl_4", (String)"tmc-fpm-business", (Object[])new Object[0]);
                        throw new KDBizException(String.format(cvMsg, property.getDisplayName()));
                    }
                    String targerPkValue = Optional.ofNullable(targetVal).map(o -> ((DynamicObject)o).getPkValue().toString()).orElseGet(() -> "");
                    String matchPkValue = Optional.ofNullable(parseVal).map(o -> ((DynamicObject)o).getPkValue().toString()).orElseGet(() -> "");
                    result = targerPkValue.equals(matchPkValue);
                } else if (targetVal instanceof String) {
                    targerPropValue = Optional.ofNullable(targetVal).map(o -> o.toString()).orElseGet(() -> "");
                    matchPropValue = Optional.ofNullable(parseVal).map(o -> o.toString()).orElseGet(() -> "");
                    result = ((String)targerPropValue).equals(matchPropValue);
                } else if (targetVal instanceof BigDecimal) {
                    targerPropValue = Optional.ofNullable(targetVal).map(o -> new BigDecimal(o.toString())).orElseGet(() -> BigDecimal.ZERO);
                    result = ((BigDecimal)targerPropValue).compareTo((BigDecimal)(matchPropValue = Optional.ofNullable(parseVal).map(o -> new BigDecimal(o.toString())).orElseGet(() -> BigDecimal.ZERO))) == 0;
                } else if (targetVal instanceof Long) {
                    targerPropValue = Optional.ofNullable(targetVal).map(o -> Long.valueOf(o.toString())).orElseGet(() -> 0L);
                    result = ((Long)targerPropValue).compareTo((Long)(matchPropValue = Optional.ofNullable(parseVal).map(o -> Long.valueOf(o.toString())).orElseGet(() -> 0L))) == 0;
                } else if (targetVal instanceof Integer) {
                    targerPropValue = Optional.ofNullable(targetVal).map(o -> Integer.valueOf(o.toString())).orElseGet(() -> 0);
                    result = ((Integer)targerPropValue).compareTo((Integer)(matchPropValue = Optional.ofNullable(parseVal).map(o -> Integer.valueOf(o.toString())).orElseGet(() -> 0))) == 0;
                } else if (targetVal instanceof Boolean) {
                    targerPropValue = Optional.ofNullable(targetVal).map(o -> Boolean.valueOf(o.toString())).orElseGet(() -> Boolean.FALSE);
                    result = ((Boolean)targerPropValue).compareTo((Boolean)(matchPropValue = Optional.ofNullable(parseVal).map(o -> Boolean.valueOf(o.toString())).orElseGet(() -> Boolean.FALSE))) == 0;
                } else if (targetVal instanceof Date) {
                    targerPropValue = Optional.ofNullable(targetVal).map(o -> {
                        Date d = (Date)o;
                        return DateUtils.formatString((Date)d, (String)"yyyyMMdd");
                    }).orElseGet(() -> "");
                    matchPropValue = Optional.ofNullable(parseVal).map(o -> {
                        Date d = (Date)o;
                        return DateUtils.formatString((Date)d, (String)"yyyyMMdd");
                    }).orElseGet(() -> "");
                    result = ((String)targerPropValue).equals(matchPropValue);
                }
                if (result.booleanValue()) continue;
                break;
            }
            return result;
        }).max(Comparator.comparing(o -> o.getDate("createtime")));
        return Pair.of((Object)first.isPresent(), first.orElse(null));
    }

    private void setIfAbsent(DynamicObject obj, String propKey, Object value) {
        if (EmptyUtil.isEmpty((Object)obj.get(propKey))) {
            obj.set(propKey, value);
        }
    }
}

