/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.ie.gather.service.gather.impl;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncData;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.service.ie.gather.convert.IEGatherSchemeDataConvert;
import kd.tmc.fpm.business.service.ie.gather.helper.MetadateDealHelper;
import kd.tmc.fpm.business.service.ie.gather.helper.SchemeGatherHelper;
import kd.tmc.fpm.business.service.ie.gather.model.IntelligentGatherScheme;
import kd.tmc.fpm.business.service.rpc.impl.FpmETLSyncDataService;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class BalancePoolDiscardService {
    private static final Log logger = LogFactory.getLog(BalancePoolDiscardService.class);
    private static volatile BalancePoolDiscardService instance;
    private static final String UPDATE_SQL = "update t_fpm_inoutcollect set fabandonstatus = '1', fdiscard = '1' ,fabandonreason = ?, fsynctime = ? where fsourcebillid = ? and fsourcebill = ? and fabandonstatus = '0';";
    private static final String DISCARD_SQL = "update t_fpm_inoutcollect set fabandonstatus = '1', fdiscard = '1' ,fabandonreason = ?, fsynctime = ? where fid = ? and fabandonstatus = '0';";

    private BalancePoolDiscardService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BalancePoolDiscardService getInstance() {
        if (instance != null) return instance;
        Class<BalancePoolDiscardService> clazz = BalancePoolDiscardService.class;
        synchronized (BalancePoolDiscardService.class) {
            if (instance != null) return instance;
            instance = new BalancePoolDiscardService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard(String entityType, List<SyncData> discardList, Date syncTime) {
        List<IntelligentGatherScheme> schemes = this.loadEnableGatherScheme(entityType);
        Set<Long> discardBillIdSet = discardList.stream().map(SyncData::getId).collect(Collectors.toSet());
        Set<String> successLockIds = this.lockBill(discardBillIdSet, entityType);
        if (successLockIds.size() == 0) {
            return;
        }
        discardBillIdSet.removeIf(t -> !successLockIds.contains(String.valueOf(t)));
        try (TXHandle tx = TX.requiresNew();){
            try {
                Set<Long> existNewEntryRowSourceBillIdSet = this.loadExistNewEntryRowSourceBillId(schemes, discardBillIdSet);
                String reason = ResManager.loadKDString((String)"\u6267\u884c\u6e90\u5355\u64cd\u4f5c\u540e\uff0c\u5e9f\u5f03\u91c7\u96c6\u5355\u5c06\u88ab\u89e6\u53d1\u3002", (String)"BalancePoolDiscardService_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
                List paramList = discardBillIdSet.stream().map(id -> new Object[]{reason, syncTime, id, entityType}).collect(Collectors.toList());
                DB.executeBatch((DBRoute)DBRoute.of((String)"tmc"), (String)UPDATE_SQL, paramList);
                ArrayList<Map<String, Object>> discardSyncDataList = new ArrayList<Map<String, Object>>(discardBillIdSet.size() - existNewEntryRowSourceBillIdSet.size());
                ArrayList<Map<String, Object>> waitSyncDataList = new ArrayList<Map<String, Object>>(existNewEntryRowSourceBillIdSet.size());
                for (SyncData syncData : discardList) {
                    HashMap<String, Number> syncInfoMap = new HashMap<String, Number>();
                    syncInfoMap.put("__KEY_DATA_ID", syncData.getId());
                    int version = syncData.getVersion();
                    syncInfoMap.put("__KEY_VERSION", version);
                    if (existNewEntryRowSourceBillIdSet.contains(syncData.getId())) {
                        waitSyncDataList.add(syncInfoMap);
                        continue;
                    }
                    discardSyncDataList.add(syncInfoMap);
                }
                this.reverseWriteTableSts(entityType, "DISCARD", 3, discardSyncDataList);
                this.reverseWriteTableSts(entityType, "UPDATE", 0, waitSyncDataList);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("BalancePoolDiscardService.discard error", (Object)ExceptionUtils.getMessage((Throwable)e));
                throw e;
            }
        }
        finally {
            MutexServiceHelper.batchRelease(new ArrayList<String>(successLockIds), (String)entityType, (String)"_collect_");
        }
    }

    public void discard(Collection<Long> balancePoolBillIds, Date syncTime) {
        if (EmptyUtil.isEmpty(balancePoolBillIds)) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                String reason = ResManager.loadKDString((String)"\u6267\u884c\u6e90\u5355\u64cd\u4f5c\u540e\uff0c\u5e9f\u5f03\u91c7\u96c6\u5355\u5c06\u88ab\u89e6\u53d1\u3002", (String)"BalancePoolDiscardService_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
                List paramList = balancePoolBillIds.stream().map(id -> new Object[]{reason, syncTime, id}).collect(Collectors.toList());
                DB.executeBatch((DBRoute)DBRoute.of((String)"tmc"), (String)DISCARD_SQL, paramList);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("BalancePoolDiscardService.discard error", (Object)ExceptionUtils.getMessage((Throwable)e));
                throw e;
            }
        }
    }

    private DynamicObjectCollection loadBalancePoolBill(IntelligentGatherScheme scheme, DynamicObject[] sourceBills) {
        Set sourceIdList = Arrays.stream(sourceBills).map(o -> o.getLong("id")).collect(Collectors.toSet());
        QFilter sourceIdFilter = new QFilter("sourcebillid", "in", sourceIdList);
        QFilter sourceBillTypeFilter = new QFilter("sourcebill", "=", (Object)scheme.getSourceBill());
        return QueryServiceHelper.query((String)scheme.getTargetBill(), (String)String.join((CharSequence)",", "id", "abandonstatus", "sourcebillid", "sourcebillentryid"), (QFilter[])new QFilter[]{sourceBillTypeFilter, sourceIdFilter});
    }

    public Set<Long> loadExistNewEntryRowSourceBillId(List<IntelligentGatherScheme> schemes, Collection<Long> discardBillIdSet) {
        HashSet existNewEntryRowSourceBillIdSet = Sets.newHashSetWithExpectedSize((int)8);
        for (IntelligentGatherScheme scheme : schemes) {
            Tuple<DynamicObjectCollection, Map<String, DynamicProperty>> tuple;
            MainEntityType sourceMainEntityType = MetadataServiceHelper.getDataEntityType((String)scheme.getSourceBill());
            CRCondition applyFilter = (CRCondition)SerializationUtils.fromJsonString((String)scheme.getApplyCondi(), CRCondition.class);
            Set<String> attrs = SchemeGatherHelper.collectQueryAttr(scheme, sourceMainEntityType, applyFilter);
            String queryProps = String.join((CharSequence)",", attrs);
            FilterBuilder filterBuilder = new FilterBuilder(sourceMainEntityType, applyFilter.getFilterCondition(), true);
            filterBuilder.buildFilter(true);
            QFilter qFilter = filterBuilder.getQFilter();
            if (qFilter == null) continue;
            QFilter idFilter = new QFilter("id", "in", discardBillIdSet);
            try (DataSet dsn = ORM.create().queryDataSet(FpmETLSyncDataService.class.getName(), scheme.getSourceBill(), queryProps, new QFilter[]{idFilter, qFilter});){
                tuple = MetadateDealHelper.toPlainDynamicObject(dsn, attrs, scheme);
            }
            DynamicObjectCollection rets = (DynamicObjectCollection)tuple.item1;
            DynamicObject[] bills = (DynamicObject[])rets.toArray((Object[])new DynamicObject[0]);
            DynamicObjectCollection balancePoolBillColl = this.loadBalancePoolBill(scheme, bills);
            boolean collectEntry = !scheme.getLinkEntity().equals(scheme.getSourceBill());
            Set<Long> existNewEntryRowBillIdSet = this.loadExistNewEntryRowSourceBillId(balancePoolBillColl, bills, collectEntry);
            existNewEntryRowSourceBillIdSet.addAll(existNewEntryRowBillIdSet);
        }
        return existNewEntryRowSourceBillIdSet;
    }

    public Set<Long> loadExistNewEntryRowSourceBillId(DynamicObjectCollection balancePoolBillColl, DynamicObject[] sourceBills, boolean collectEntry) {
        Map<Long, List<DynamicObject>> sourceBillMap = Arrays.stream(sourceBills).filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getLong("id")));
        Map<Long, List<DynamicObject>> balancePoolBillMap = balancePoolBillColl.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getLong("sourcebillid")));
        HashSet existNewEntryRowSourceBillIdSet = Sets.newHashSetWithExpectedSize((int)8);
        for (Map.Entry<Long, List<DynamicObject>> mapEntry : sourceBillMap.entrySet()) {
            Long sourceBillId = mapEntry.getKey();
            if (!balancePoolBillMap.containsKey(sourceBillId)) {
                existNewEntryRowSourceBillIdSet.add(sourceBillId);
                continue;
            }
            if (!collectEntry) continue;
            List<DynamicObject> entryRowBalancePoolBills = balancePoolBillMap.get(sourceBillId);
            Set balancePoolBillEntryRowIdSet = entryRowBalancePoolBills.stream().filter(Objects::nonNull).map(bill -> bill.getLong("sourcebillentryid")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
            List<DynamicObject> sourceBillEntryRows = mapEntry.getValue();
            boolean existNewEntryRow = sourceBillEntryRows.stream().filter(Objects::nonNull).filter(entryRow -> entryRow.containsProperty("entryid")).map(entryRow -> entryRow.getLong("entryid")).filter(EmptyUtil::isNoEmpty).anyMatch(entryRowId -> !balancePoolBillEntryRowIdSet.contains(entryRowId));
            if (!existNewEntryRow) continue;
            existNewEntryRowSourceBillIdSet.add(sourceBillId);
        }
        return existNewEntryRowSourceBillIdSet;
    }

    private List<IntelligentGatherScheme> loadEnableGatherScheme(String entityType) {
        QFilter filter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue()).and(new QFilter("sourcebill", "=", (Object)entityType));
        List smartCollectPlanIds = QueryServiceHelper.queryPrimaryKeys((String)"fpm_smartcollect", (QFilter[])new QFilter[]{filter}, null, (int)-1);
        Set<Long> ids = smartCollectPlanIds.stream().filter(Objects::nonNull).map(id -> (Long)id).collect(Collectors.toSet());
        return IEGatherSchemeDataConvert.getSmartCollectScheme(ids);
    }

    private Set<String> lockBill(Collection<Long> billIdCollection, String entityType) {
        List lockIds = billIdCollection.stream().distinct().map(String::valueOf).collect(Collectors.toList());
        Map lockResult = MutexServiceHelper.batchRequest(lockIds, (String)entityType, (String)"_collect_");
        HashSet<String> successLockIds = new HashSet<String>(lockIds.size());
        for (Map.Entry entry : lockResult.entrySet()) {
            String key = (String)entry.getKey();
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            successLockIds.add(key);
        }
        return successLockIds;
    }

    private void reverseWriteTableSts(String entityType, String operateType, Integer operateStatus, List<Map<String, Object>> syncDataList) {
        CommonParam param = new CommonParam();
        param.put((Object)"__ENTITY_TYPE", (Object)entityType);
        param.put((Object)"__DATA", syncDataList);
        param.put((Object)"__OPERATE_TYPE", (Object)operateType);
        param.put((Object)"__OPERATE_STATUS", (Object)operateStatus);
        ECGlobalSession.begin((String)"fpm_etlupdate", (DBRoute)DBRoute.of((String)"tmc"), (boolean)true);
        ECGlobalSession.setAsync((boolean)true);
        ECGlobalSession.register((String)"tmc", (String)"fpm", (String)"FpmETLUpdateDataService", (Param)param);
    }
}

