/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.interior.offset.model;

import java.util.ArrayList;
import java.util.List;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.sumplan.InnerRuleSubjectConfig;

public class AuxiliaryDataInfo {
    private DimMember currencyDimMember;
    private DimMember periodDimMember;
    private InnerRuleSubjectConfig subjectConfig;
    private List<DimMember> optionalDimMembers;

    private AuxiliaryDataInfo(AuxiliaryDataInfoBuilder builder) {
        this.currencyDimMember = builder.currencyDimMember;
        this.periodDimMember = builder.periodDimMember;
        this.subjectConfig = builder.subjectConfig;
        this.optionalDimMembers = builder.optionalDimMembers;
    }

    public DimMember getCurrencyDimMember() {
        return this.currencyDimMember;
    }

    public DimMember getPeriodDimMember() {
        return this.periodDimMember;
    }

    public InnerRuleSubjectConfig getSubjectConfig() {
        return this.subjectConfig;
    }

    public List<InnerRuleSubjectConfig.SubjectOrder> getAllSubjectOrder() {
        List<InnerRuleSubjectConfig.SubjectOrder> outflowAcctOrders;
        ArrayList<InnerRuleSubjectConfig.SubjectOrder> subjectOrders = new ArrayList<InnerRuleSubjectConfig.SubjectOrder>(10);
        List<InnerRuleSubjectConfig.SubjectOrder> inflowAcctOrders = this.subjectConfig.getInSubjectOrderList();
        if (EmptyUtil.isNoEmpty(inflowAcctOrders)) {
            subjectOrders.addAll(inflowAcctOrders);
        }
        if (EmptyUtil.isNoEmpty(outflowAcctOrders = this.subjectConfig.getOutSubjectOrderList())) {
            subjectOrders.addAll(outflowAcctOrders);
        }
        return subjectOrders;
    }

    public Long getCurrencyId() {
        return this.currencyDimMember.getSourceId();
    }

    public List<DimMember> getOptionalDimMembers() {
        return this.optionalDimMembers;
    }

    public static class AuxiliaryDataInfoBuilder {
        private DimMember currencyDimMember;
        private DimMember periodDimMember;
        private InnerRuleSubjectConfig subjectConfig;
        private List<DimMember> optionalDimMembers;

        public AuxiliaryDataInfo builder() {
            return new AuxiliaryDataInfo(this);
        }

        public AuxiliaryDataInfoBuilder setCurrencyDimMember(DimMember currencyDimMember) {
            this.currencyDimMember = currencyDimMember;
            return this;
        }

        public AuxiliaryDataInfoBuilder setPeriodDimMember(DimMember periodDimMember) {
            this.periodDimMember = periodDimMember;
            return this;
        }

        public AuxiliaryDataInfoBuilder setSubjectConfig(InnerRuleSubjectConfig subjectConfig) {
            this.subjectConfig = subjectConfig;
            return this;
        }

        public AuxiliaryDataInfoBuilder setOptionalDimMembers(List<DimMember> optionalDimMembers) {
            this.optionalDimMembers = optionalDimMembers;
            return this;
        }
    }
}

