/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.interior.offset.service.datasource.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetGroupData;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetParam;
import kd.tmc.fpm.business.service.interior.offset.service.datasource.IInternalOffsetDataSource;

public class InexactMatchMode
implements IInternalOffsetDataSource {
    private IInternalOffsetDataSource dataSource;

    public InexactMatchMode(IInternalOffsetDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public List<ReportDataQueryResult> dataFilter(InternalOffsetParam internalOffsetParam, List<ReportDataQueryResult> reportDataQueryResults) {
        reportDataQueryResults = this.dataSource.dataFilter(internalOffsetParam, reportDataQueryResults);
        return reportDataQueryResults;
    }

    @Override
    public void dataGroup(InternalOffsetParam internalOffsetParam, List<ReportDataQueryResult> reportDataQueryResults) {
        String validateMsg = this.validate(internalOffsetParam, reportDataQueryResults);
        ArrayList<InternalOffsetGroupData> groupDatas = new ArrayList<InternalOffsetGroupData>(1);
        internalOffsetParam.setGroupDatas(groupDatas);
        if (EmptyUtil.isNoEmpty((String)validateMsg)) {
            InternalOffsetGroupData groupData = new InternalOffsetGroupData();
            groupData.setSuccess(false);
            groupData.setErrMsg(validateMsg);
            groupDatas.add(groupData);
            return;
        }
        InternalOffsetGroupData groupData = new InternalOffsetGroupData();
        groupData.setDataResult(reportDataQueryResults);
        groupData.setSuccess(true);
        groupData.setGroupKey(this.generateGroupKey("001"));
        groupDatas.add(groupData);
    }

    private Set<String> getUniqueKey(List<ReportDataQueryResult> mainTableResults) {
        HashSet<String> keys = new HashSet<String>(mainTableResults.size());
        for (ReportDataQueryResult mainTableResult : mainTableResults) {
            Long reportId = mainTableResult.getReportId();
            Object subjectId = this.getSubjectDimId(mainTableResult.getDimList(), mainTableResult.getDimValList());
            keys.add(String.format("%s.%s", reportId, subjectId.toString()));
        }
        return keys;
    }

    private Object getSubjectDimId(List<TemplateDim> dimList, List<Object> dimValList) {
        Object subjectId = 0L;
        for (int i = 0; i < dimList.size(); ++i) {
            TemplateDim templateDim = dimList.get(i);
            if (templateDim.getDimType() != DimensionType.SUBJECTS) continue;
            subjectId = dimValList.get(i);
            break;
        }
        return subjectId;
    }
}

