/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.interior.offset.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.enums.DiffProcessModeType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelDetail;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRecord;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancleTotal;
import kd.tmc.fpm.business.domain.model.sumplan.InnerRuleSubjectConfig;
import kd.tmc.fpm.business.service.interior.offset.model.AuxiliaryDataInfo;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetDetailModel;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetGroupData;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetParam;
import kd.tmc.fpm.business.service.interior.offset.model.OptionalDimSetValInfo;
import kd.tmc.fpm.business.service.interior.offset.service.impl.AbsInternalOffsetStrategy;
import org.apache.commons.lang3.tuple.Pair;

public class DiffOffsetStrategy
extends AbsInternalOffsetStrategy {
    public DiffOffsetStrategy(InternalOffsetParam internalOffsetParam) {
        super(internalOffsetParam);
    }

    @Override
    public InnerCancelRecord execInternalOffset() {
        HashMap<Long, Pair<Integer, OptionalDimSetValInfo>> relationMap = new HashMap<Long, Pair<Integer, OptionalDimSetValInfo>>();
        AuxiliaryDataInfo auxiliaryData = this.internalOffsetParam.getAuxiliaryData();
        InnerRuleSubjectConfig subjectConfig = auxiliaryData.getSubjectConfig();
        ArrayList<InnerCancleTotal> totals = new ArrayList<InnerCancleTotal>(this.internalOffsetParam.getGroupDatas().size());
        ArrayList<InnerCancelDetail> details = new ArrayList<InnerCancelDetail>(this.internalOffsetParam.getGroupDatas().size());
        for (InternalOffsetGroupData groupData : this.internalOffsetParam.getGroupDatas()) {
            BigDecimal inflowAmt = this.calcSumAcctAmt(subjectConfig.getInSubjectOrderList(), groupData.getDataResult());
            BigDecimal outflowAmt = this.calcSumAcctAmt(subjectConfig.getOutSubjectOrderList(), groupData.getDataResult());
            if (inflowAmt.compareTo(BigDecimal.ZERO) == 0 && outflowAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            Set inflowSubjectIds = subjectConfig.getInSubjectOrderList().stream().filter(Objects::nonNull).map(o -> o.getSubjectId()).collect(Collectors.toSet());
            List<ReportDataQueryResult> inflowReportDatas = groupData.getDataResult().stream().filter(Objects::nonNull).filter(o -> inflowSubjectIds.contains(this.getAppointDimVal(DimensionType.SUBJECTS, (ReportDataQueryResult)o))).collect(Collectors.toList());
            Set outflowSubjectIds = subjectConfig.getOutSubjectOrderList().stream().filter(Objects::nonNull).map(o -> o.getSubjectId()).collect(Collectors.toSet());
            List<ReportDataQueryResult> outflowReportDatas = groupData.getDataResult().stream().filter(Objects::nonNull).filter(o -> outflowSubjectIds.contains(this.getAppointDimVal(DimensionType.SUBJECTS, (ReportDataQueryResult)o))).collect(Collectors.toList());
            DiffProcessModeType diffMode = subjectConfig.getDiffProcessMode();
            InternalOffsetDetailModel detailModel = null;
            if (DiffProcessModeType.INFLOWDIFF == diffMode) {
                detailModel = this.offset(inflowReportDatas, outflowReportDatas, groupData.getGroupKey(), auxiliaryData, relationMap);
            } else if (DiffProcessModeType.OUTFLOWDIFF == diffMode) {
                detailModel = this.offset(outflowReportDatas, inflowReportDatas, groupData.getGroupKey(), auxiliaryData, relationMap);
            }
            if (detailModel != null && EmptyUtil.isNoEmpty(detailModel.getAllCancleDetails())) {
                details.addAll(detailModel.getAllCancleDetails());
            }
            if (detailModel == null) continue;
            totals.add(this.buildInnerCancleTotal(groupData, detailModel, diffMode));
        }
        this.innerCancelRecord.setInnerCancleTotals(totals);
        this.innerCancelRecord.setCancelDetailList(details);
        if (EmptyUtil.isEmpty(totals)) {
            return null;
        }
        return this.innerCancelRecord;
    }

    private InternalOffsetDetailModel offset(List<ReportDataQueryResult> pendingDatas, List<ReportDataQueryResult> referenceDatas, String groupKey, AuxiliaryDataInfo auxiliaryData, Map<Long, Pair<Integer, OptionalDimSetValInfo>> relationMap) {
        InnerCancelDetail innerCancelDetail;
        BigDecimal offsetAmt;
        InternalOffsetDetailModel detailModel = new InternalOffsetDetailModel();
        ArrayList<InnerCancelDetail> pendingCancelDetails = new ArrayList<InnerCancelDetail>(pendingDatas.size());
        BigDecimal needCancelAmt = referenceDatas.stream().map(data -> this.transferAmt().apply(data.getAmountUnit(), data.getOriginalPlanAmt())).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        for (int i = 0; i < pendingDatas.size(); ++i) {
            ReportDataQueryResult pendingData = pendingDatas.get(i);
            Long subjectId = this.getAppointDimVal(DimensionType.SUBJECTS, pendingData);
            BigDecimal avCancelAmt = this.transferAmt().apply(pendingData.getAmountUnit(), pendingData.getOriginalPlanAmt());
            offsetAmt = i + 1 == pendingDatas.size() ? needCancelAmt : (needCancelAmt.compareTo(avCancelAmt) >= 0 ? avCancelAmt : needCancelAmt);
            needCancelAmt = needCancelAmt.subtract(offsetAmt);
            innerCancelDetail = this.builderInnerCancelDetail(pendingData, subjectId, offsetAmt, groupKey, auxiliaryData, relationMap);
            if (innerCancelDetail.getAvCancelAmt().compareTo(BigDecimal.ZERO) == 0 && innerCancelDetail.getCancelAmt().compareTo(BigDecimal.ZERO) == 0) continue;
            pendingCancelDetails.add(innerCancelDetail);
        }
        ArrayList<InnerCancelDetail> refrenceCancelDetails = new ArrayList<InnerCancelDetail>(referenceDatas.size());
        for (ReportDataQueryResult referenceData : referenceDatas) {
            Long subjectId;
            innerCancelDetail = this.builderInnerCancelDetail(referenceData, subjectId = this.getAppointDimVal(DimensionType.SUBJECTS, referenceData), offsetAmt = this.transferAmt().apply(referenceData.getAmountUnit(), referenceData.getOriginalPlanAmt()), groupKey, auxiliaryData, relationMap);
            if (innerCancelDetail.getAvCancelAmt().compareTo(BigDecimal.ZERO) == 0 && innerCancelDetail.getCancelAmt().compareTo(BigDecimal.ZERO) == 0) continue;
            refrenceCancelDetails.add(innerCancelDetail);
        }
        if (auxiliaryData.getSubjectConfig().getDiffProcessMode() == DiffProcessModeType.INFLOWDIFF) {
            detailModel.setInflowCancelDetails(pendingCancelDetails);
            detailModel.setOutflowCancelDetails(refrenceCancelDetails);
        } else {
            detailModel.setInflowCancelDetails(refrenceCancelDetails);
            detailModel.setOutflowCancelDetails(pendingCancelDetails);
        }
        return detailModel;
    }
}

