/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.interior.offset.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.enums.DiffProcessModeType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelDetail;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRecord;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancleTotal;
import kd.tmc.fpm.business.domain.model.sumplan.InnerRuleSubjectConfig;
import kd.tmc.fpm.business.service.interior.offset.model.AuxiliaryDataInfo;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetDetailModel;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetGroupData;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetParam;
import kd.tmc.fpm.business.service.interior.offset.model.OptionalDimSetValInfo;
import kd.tmc.fpm.business.service.interior.offset.service.impl.AbsInternalOffsetStrategy;
import org.apache.commons.lang3.tuple.Pair;

public class MaxOrMinStrategy
extends AbsInternalOffsetStrategy {
    private Log logger = LogFactory.getLog(MaxOrMinStrategy.class);

    public MaxOrMinStrategy(InternalOffsetParam internalOffsetParam) {
        super(internalOffsetParam);
    }

    @Override
    public InnerCancelRecord execInternalOffset() {
        AuxiliaryDataInfo auxiliaryData = this.internalOffsetParam.getAuxiliaryData();
        InnerRuleSubjectConfig subjectConfig = auxiliaryData.getSubjectConfig();
        DiffProcessModeType diffMode = subjectConfig.getDiffProcessMode();
        HashMap<Long, Pair<Integer, OptionalDimSetValInfo>> relationMap = new HashMap<Long, Pair<Integer, OptionalDimSetValInfo>>();
        ArrayList<InnerCancleTotal> totals = new ArrayList<InnerCancleTotal>(this.internalOffsetParam.getGroupDatas().size());
        ArrayList<InnerCancelDetail> details = new ArrayList<InnerCancelDetail>(this.internalOffsetParam.getGroupDatas().size());
        for (InternalOffsetGroupData groupData : this.internalOffsetParam.getGroupDatas()) {
            BigDecimal inflowAmt = this.calcSumAcctAmt(subjectConfig.getInSubjectOrderList(), groupData.getDataResult());
            BigDecimal outflowAmt = this.calcSumAcctAmt(subjectConfig.getOutSubjectOrderList(), groupData.getDataResult());
            if (inflowAmt.compareTo(BigDecimal.ZERO) == 0 && outflowAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal needCancleAmt = BigDecimal.ZERO;
            InternalOffsetDetailModel detailModel = new InternalOffsetDetailModel();
            if (diffMode == DiffProcessModeType.BIG) {
                needCancleAmt = inflowAmt.compareTo(outflowAmt) > 0 ? inflowAmt : outflowAmt;
            } else if (diffMode == DiffProcessModeType.SMALL) {
                needCancleAmt = inflowAmt.compareTo(outflowAmt) > 0 ? outflowAmt : inflowAmt;
            }
            List<InnerCancelDetail> inflowCancleDetails = this.generateRecordDetails(needCancleAmt, subjectConfig.getInSubjectOrderList(), groupData, auxiliaryData, relationMap);
            detailModel.setInflowCancelDetails(inflowCancleDetails);
            List<InnerCancelDetail> outflowCancleDetails = this.generateRecordDetails(needCancleAmt, subjectConfig.getOutSubjectOrderList(), groupData, auxiliaryData, relationMap);
            detailModel.setOutflowCancelDetails(outflowCancleDetails);
            if (detailModel != null && EmptyUtil.isNoEmpty(detailModel.getAllCancleDetails())) {
                details.addAll(detailModel.getAllCancleDetails());
            }
            totals.add(this.buildInnerCancleTotal(groupData, detailModel, diffMode));
        }
        this.innerCancelRecord.setInnerCancleTotals(totals);
        this.innerCancelRecord.setCancelDetailList(details);
        if (EmptyUtil.isEmpty(totals)) {
            return null;
        }
        return this.innerCancelRecord;
    }

    private List<InnerCancelDetail> generateRecordDetails(BigDecimal needCancleAmt, List<InnerRuleSubjectConfig.SubjectOrder> subjectOrderList, InternalOffsetGroupData groupData, AuxiliaryDataInfo auxiliaryData, Map<Long, Pair<Integer, OptionalDimSetValInfo>> relationMap) {
        ArrayList<InnerCancelDetail> innerCancelDetails = new ArrayList<InnerCancelDetail>(subjectOrderList.size());
        Set subjectIds = subjectOrderList.stream().filter(Objects::nonNull).map(o -> o.getSubjectId()).collect(Collectors.toSet());
        List queryResults = groupData.getDataResult().stream().filter(Objects::nonNull).filter(o -> subjectIds.contains(this.getAppointDimVal(DimensionType.SUBJECTS, (ReportDataQueryResult)o))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(queryResults)) {
            this.logger.error("\u65e0\u6cd5\u67e5\u8be2\u8ba1\u5212\u79d1\u76ee{}\u5230\u5bf9\u5e94\u7684\u6570\u636e\u3002", subjectIds);
            return innerCancelDetails;
        }
        for (int i = 0; i < queryResults.size(); ++i) {
            ReportDataQueryResult queryResult = (ReportDataQueryResult)queryResults.get(i);
            BigDecimal avCancelAmt = this.transferAmt().apply(queryResult.getAmountUnit(), queryResult.getOriginalPlanAmt());
            BigDecimal offsetAmt = i + 1 == queryResults.size() ? needCancleAmt : (needCancleAmt.compareTo(avCancelAmt) >= 0 ? avCancelAmt : needCancleAmt);
            needCancleAmt = needCancleAmt.subtract(offsetAmt);
            Long subjectId = this.getAppointDimVal(DimensionType.SUBJECTS, queryResult);
            InnerCancelDetail innerCancelDetail = this.builderInnerCancelDetail(queryResult, subjectId, offsetAmt, groupData.getGroupKey(), auxiliaryData, relationMap);
            if (innerCancelDetail.getAvCancelAmt().compareTo(BigDecimal.ZERO) == 0 && innerCancelDetail.getCancelAmt().compareTo(BigDecimal.ZERO) == 0) continue;
            innerCancelDetails.add(innerCancelDetail);
        }
        return innerCancelDetails;
    }
}

