/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.rpc.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.builder.FormulaGetHandle;
import kd.tmc.fbp.common.builder.ISingleTaskContext;
import kd.tmc.fbp.common.builder.SingleTaskContext;
import kd.tmc.fbp.common.builder.mode.IVariableMode;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.control.ControlActTime;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ControlRepository;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.dto.ControlExcuteServiceLogParamDTO;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.service.rpc.helper.AssemblyBizPropHelper;

public class GenerateControlExecLogParamHelper {
    private static final Log logger = LogFactory.getLog(GenerateControlExecLogParamHelper.class);
    private static final IControlRepository controlRepository = new ControlRepository();

    public static List<ControlExcuteServiceLogParamDTO> generatePlanExecuteRecordParamsOfWrite(DynamicObject[] selectBills, ControlContext controlContext) {
        if (EmptyUtil.isEmpty((Object[])selectBills)) {
            return Collections.emptyList();
        }
        String billSign = selectBills[0].getDataEntityType().getName();
        controlContext.setEntityType(billSign);
        List<BillMatchRule> billMatchRules = GenerateControlExecLogParamHelper.getMatchRule(billSign);
        if (EmptyUtil.isEmpty(billMatchRules)) {
            return Collections.emptyList();
        }
        List<Long> ids = GenerateControlExecLogParamHelper.getIdsFromDyBills(selectBills);
        logger.info("sourceBills-ids:{}", ids);
        Set<Long> systemIdS = billMatchRules.stream().map(BillMatchRule::getSystemId).collect(Collectors.toSet());
        List<ControlTime> controlTimes = controlRepository.loadControlTimes(systemIdS, true);
        controlContext.addControlTimes(controlTimes);
        ArrayList<ControlExcuteServiceLogParamDTO> controlMatchParamLst = new ArrayList<ControlExcuteServiceLogParamDTO>(20);
        for (BillMatchRule billMatchRule : billMatchRules) {
            PrepareParam prepareParam = GenerateControlExecLogParamHelper.toPlainDynamicObjectCollection(billMatchRule, selectBills, controlContext);
            controlMatchParamLst.addAll(GenerateControlExecLogParamHelper.doGeneratePlanExecuteRecordParamsOfWrite(prepareParam, controlContext));
        }
        return controlMatchParamLst;
    }

    public static List<ControlExcuteServiceLogParamDTO> generatePlanExecuteRecordParamsOfWrite(DynamicObject[] selectBills, ControlContext controlContext, List<BillMatchRule> billMatchRuleList) {
        if (EmptyUtil.isEmpty(billMatchRuleList)) {
            return new ArrayList<ControlExcuteServiceLogParamDTO>(1);
        }
        ArrayList<ControlExcuteServiceLogParamDTO> controlMatchParamLst = new ArrayList<ControlExcuteServiceLogParamDTO>(20);
        for (BillMatchRule billMatchRule : billMatchRuleList) {
            PrepareParam prepareParam = GenerateControlExecLogParamHelper.toPlainDynamicObjectCollection(billMatchRule, selectBills, controlContext);
            controlMatchParamLst.addAll(GenerateControlExecLogParamHelper.doGeneratePlanExecuteRecordParamsOfWrite(prepareParam, controlContext));
        }
        return controlMatchParamLst;
    }

    public static List<ControlExcuteServiceLogParamDTO> generateInspectParamList(BillMatchRule billMatchRule, DynamicObject[] selectBills) {
        ControlContext controlContext = new ControlContext();
        controlContext.setPlanExecuteOpType(PlanExecuteOpType.INSPECT);
        controlContext.setOpCode("inspect-repair");
        controlContext.addControlTimes(controlRepository.loadControlTime(billMatchRule.getSystemId(), true));
        PrepareParam prepareParam = GenerateControlExecLogParamHelper.toPlainDynamicObjectCollection(billMatchRule, selectBills, controlContext);
        return GenerateControlExecLogParamHelper.doGeneratePlanExecuteRecordParamsOfWrite(prepareParam, controlContext);
    }

    public static List<ControlExcuteServiceLogParamDTO> generateInspectParamList(InspectContext inspectContext, BillMatchRule billMatchRule, DynamicObject[] selectBills) {
        ControlContext controlContext = new ControlContext();
        controlContext.setPlanExecuteOpType(PlanExecuteOpType.INSPECT);
        ControlTime controlTime = inspectContext.getControlTime();
        controlContext.addControlTimes(Collections.singletonList(controlTime));
        controlContext.setOpCode("inspect-repair");
        PrepareParam prepareParam = GenerateControlExecLogParamHelper.toPlainDynamicObjectCollection(billMatchRule, selectBills, controlContext);
        List<ControlExcuteServiceLogParamDTO> logParamDTOS = GenerateControlExecLogParamHelper.doGeneratePlanExecuteRecordParamsOfWrite(prepareParam, controlContext);
        Optional<ControlActTime> first = controlTime.getControlActTimeList().stream().filter(controlActTime -> Objects.equals(controlActTime.getBizBill(), billMatchRule.getEntityType())).filter(controlActTime -> EmptyUtil.isNoEmpty(controlActTime.getReleaseActTime()) || EmptyUtil.isNoEmpty(controlActTime.getActUpdateTime())).findFirst();
        if (!first.isPresent()) {
            return logParamDTOS;
        }
        ControlActTime controlActTime2 = first.get();
        if (EmptyUtil.isNoEmpty(controlActTime2.getReleaseActTime())) {
            logParamDTOS.forEach(p -> p.getBillBizInfo().getBizProps().add(new BizProps(controlActTime2.getFactBackAmtField(), p.getOpAmount())));
            return logParamDTOS;
        }
        logParamDTOS.forEach(p -> p.getBillBizInfo().getBizProps().add(new BizProps(controlActTime2.getAclUpdateAmtField(), p.getOpAmount())));
        return logParamDTOS;
    }

    private static List<ControlExcuteServiceLogParamDTO> doGeneratePlanExecuteRecordParamsOfWrite(PrepareParam param, ControlContext controlContext) {
        ArrayList<ControlExcuteServiceLogParamDTO> controlMatchParamLst = new ArrayList<ControlExcuteServiceLogParamDTO>(16);
        BillMatchRule matchRule = param.getMatchRule();
        String extraCondition = matchRule.getExtraCondition();
        String billSign = matchRule.getEntityType();
        for (DynamicObject sourceBill : param.getSelectBills()) {
            if (StringUtils.isEmpty((String)extraCondition)) {
                controlMatchParamLst.add(AssemblyBizPropHelper.createControlMatchParam(sourceBill, matchRule, controlContext));
                continue;
            }
            Object checkResult = GenerateControlExecLogParamHelper.getResultOfExecExpression(extraCondition, sourceBill, param.getFilterProperties(), billSign);
            if (!(checkResult instanceof Boolean)) {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)extraCondition, CRCondition.class);
                String errMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u3010%1$s\u3011\u5339\u914d\u4f8b\u5916\u6761\u4ef6\u5931\u8d25\uff0c\u6267\u884c\u7ed3\u679c\u503c\uff1a\u3010%2$s\u3011\n\t\u4f8b\u5916\u6761\u4ef6\uff1a\u3010%3$s\u3011", (String)"GenerateControlExecLogParamHelper_1", (String)"tmc-fpm-business", (Object[])new Object[0]), matchRule.getNumber(), checkResult, condition.getExpression());
                logger.error(errMsg);
                throw new KDBizException(errMsg);
            }
            Boolean result = (Boolean)checkResult;
            if (result.booleanValue()) {
                logger.info("\u4e1a\u52a1\u5355\u636e\uff1a{} \u6ee1\u8db3\u4e1a\u52a1\u53d6\u6570\u89c4\u5219{} \u4f8b\u5916\u6761\u4ef6\u914d\u7f6e\uff0c\u4e0d\u8fdb\u884c\u6570\u636e\u5c01\u88c5\u3002", (Object)sourceBill.getString("billno"), (Object)matchRule.getNumber());
                continue;
            }
            logger.info(String.format("\u4e1a\u52a1\u53d6\u6570%s\u5b58\u5728\u4f8b\u5916\u6761\u4ef6\u914d\u7f6e\uff0c\u4e14\u4e0d\u6ee1\u8db3\u4f8b\u5916\u6761\u4ef6\uff0c\u8fdb\u884c\u6570\u636e\u5c01\u88c5\uff1acondition = %s, billSign = %s, billId = %s", matchRule.getNumber(), extraCondition, billSign, sourceBill.getPkValue()));
            ControlExcuteServiceLogParamDTO controlMatchParam = AssemblyBizPropHelper.createControlMatchParam(sourceBill, matchRule, controlContext);
            controlMatchParamLst.add(controlMatchParam);
        }
        return controlMatchParamLst;
    }

    private static Set<String> collectExtraConditionFields(BillMatchRule billMatchRule, Set<String> needLoadFields) {
        String extraCondition = billMatchRule.getExtraCondition();
        if (EmptyUtil.isEmpty((String)extraCondition)) {
            return Collections.emptySet();
        }
        Map<String, String> propEntryRelationMap = GenerateControlExecLogParamHelper.getEntryPropMapEntryName(billMatchRule);
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)extraCondition, CRCondition.class);
        List filterFiledRows = condition.getFilterCondition().getFilterRow();
        HashSet<String> extraConditionFields = new HashSet<String>(16);
        for (SimpleFilterRow filterFiledRow : filterFiledRows) {
            String fieldName = filterFiledRow.getFieldName();
            String[] splitStrArr = fieldName.split("\\.");
            if (splitStrArr.length == 0) continue;
            extraConditionFields.add(fieldName);
            String trueField = fieldName;
            String propName = splitStrArr[0];
            if (propEntryRelationMap.containsKey(propName)) {
                String prefix = propEntryRelationMap.get(propName);
                trueField = String.format("%s.%s", prefix, fieldName);
            }
            needLoadFields.add(trueField);
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billMatchRule.getEntityType());
        String filterStr = condition.buildFullFormula(mainEntityType);
        if (StringUtils.isEmpty((String)filterStr)) {
            return extraConditionFields;
        }
        SingleTaskContext taskContext = new SingleTaskContext();
        taskContext.setSrcEntityType(mainEntityType);
        FormulaGetHandle formulaGetHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, filterStr, (Object)Boolean.FALSE);
        List vars = formulaGetHandle.getVars();
        if (EmptyUtil.isEmpty((Collection)vars)) {
            return extraConditionFields;
        }
        for (IVariableMode var : vars) {
            String trueField = var.getVar();
            String[] splitStrArr = trueField.split("\\.");
            if (splitStrArr.length == 0) continue;
            extraConditionFields.add(trueField);
            String propName = splitStrArr[0];
            if (propEntryRelationMap.containsKey(propName)) {
                String prefix = propEntryRelationMap.get(propName);
                trueField = String.format("%s.%s", prefix, trueField);
            }
            needLoadFields.add(trueField);
        }
        return extraConditionFields;
    }

    private static Map<String, String> getEntryPropMapEntryName(BillMatchRule billMatchRule) {
        String billSign = billMatchRule.getEntityType();
        Map allEntities = EntityMetadataCache.getDataEntityType((String)billSign).getAllEntities();
        HashMap<String, String> propEntryRelationMap = new HashMap<String, String>(32);
        for (Map.Entry entry : allEntities.entrySet()) {
            String prefix;
            EntityType entityType = (EntityType)entry.getValue();
            if (LinkEntryType.class.isInstance(entityType)) continue;
            String string = prefix = Objects.equals(billSign, entry.getKey()) ? "" : (String)entry.getKey();
            if (EmptyUtil.isEmpty((String)prefix)) continue;
            Map fields = entityType.getFields();
            for (Map.Entry fieldEntry : fields.entrySet()) {
                String field = (String)fieldEntry.getKey();
                propEntryRelationMap.put(field, prefix);
            }
        }
        return propEntryRelationMap;
    }

    private static Object getResultOfExecExpression(String datafilter, DynamicObject sourceBill, Map<String, DynamicProperty> fldProperties, String billSign) {
        if (StringUtils.isEmpty((String)datafilter)) {
            return datafilter;
        }
        CRCondition condition = null;
        try {
            condition = (CRCondition)SerializationUtils.fromJsonString((String)datafilter, CRCondition.class);
        }
        catch (Exception e) {
            logger.error("\u4f8b\u5916\u6761\u4ef6\u975ejson\u683c\u5f0f: " + e.getMessage(), (Throwable)e);
            return datafilter;
        }
        Object value = null;
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billSign);
        String filterStr = condition.buildFullFormula(mainEntityType);
        logger.info(String.format("\u4f8b\u5916\u6761\u4ef6\u6761\u4ef6\u5b57\u7b26:%s", filterStr));
        Set<Map.Entry<String, DynamicProperty>> entries = fldProperties.entrySet();
        HashSet entryProps = new HashSet(10);
        Map allEntities = EntityMetadataCache.getDataEntityType((String)billSign).getAllEntities();
        for (Map.Entry entry : allEntities.entrySet()) {
            EntityType entityType = (EntityType)entry.getValue();
            if (entityType instanceof LinkEntryType || billSign.equals(entry.getKey())) continue;
            entryProps.add(entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : entries) {
            String fillProp = (String)entry.getKey();
            if (EmptyUtil.isEmpty((String)fillProp)) continue;
            String[] split = fillProp.split("\\.");
            boolean isEntryProp = entryProps.contains(split[0]);
            if (split.length != 2 || !filterStr.startsWith(split[1]) || !isEntryProp) continue;
            filterStr = filterStr.replace(split[1] + ".", "");
        }
        logger.info(String.format("\u4f8b\u5916\u6761\u4ef6\u6761\u4ef6\u5b57\u7b26:%s", filterStr));
        SingleTaskContext taskContext = new SingleTaskContext();
        taskContext.setSrcEntityType(mainEntityType);
        if (!StringUtils.isEmpty((String)filterStr)) {
            try {
                FormulaGetHandle formulaGetHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, filterStr, (Object)Boolean.FALSE);
                value = formulaGetHandle.GetVchFldValue(fldProperties, sourceBill, null);
            }
            catch (Exception exception) {
                value = String.format("%s%s => %s", ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u662f\u5426\u9519\u8bef\uff1a", (String)"GenerateControlExecLogParamHelper_2", (String)"tmc-fpm-business", (Object[])new Object[0]), condition.getExpression(), exception.getMessage());
                logger.error(value.toString(), (Throwable)exception);
                throw new KDBizException(value.toString());
            }
        } else {
            value = "";
        }
        return value;
    }

    public static List<Long> getIdsFromDyBills(DynamicObject[] bills) {
        return Arrays.stream(bills).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList());
    }

    private static Set<String> getNeedQueryProp(BillMatchRule billMatchRule, ControlContext controlContext) {
        ControlActTime controlActTime;
        String aclUpdateAmtField;
        List controlActTimeList;
        ControlActTime controlActTime2;
        String factBackAmtField;
        PlanExecuteOpType planExecuteOpType;
        HashSet<String> props = new HashSet<String>(32);
        String entityType = billMatchRule.getEntityType();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
        props.add(((BillEntityType)mainEntityType).getBillNo());
        props.add("id");
        List<MatchMapping> mappings = billMatchRule.getMappings();
        if (EmptyUtil.isEmpty(mappings)) {
            return props;
        }
        for (MatchMapping mapping : mappings) {
            if (EmptyUtil.isEmpty((Object)mapping)) continue;
            if (EmptyUtil.isNoEmpty((String)mapping.getBizProp())) {
                props.add(mapping.getBizProp());
            }
            if (!EmptyUtil.isNoEmpty((String)mapping.getAssistBizProp())) continue;
            props.add(mapping.getAssistBizProp());
        }
        if (!Objects.equals(billMatchRule.getMappingEntryNumber(), entityType)) {
            props.add(String.format("%s.id", billMatchRule.getMappingEntryNumber()));
        }
        if (!(planExecuteOpType = controlContext.getPlanExecuteOpType()).isReleaseOrUpdateOrInspect()) {
            return props;
        }
        ControlTime controlTime = controlContext.getControlTime(billMatchRule.getSystemId());
        if (EmptyUtil.isEmpty((Object)controlTime)) {
            return props;
        }
        String opCode = controlContext.getOpCode();
        List controlActTimes = controlTime.getControlActTimeList().stream().filter(Objects::nonNull).filter(item -> Objects.equals(item.getBizBill(), entityType)).filter(item -> EmptyUtil.isNoEmpty(item.getReleaseActTime())).filter(item -> item.getReleaseActTime().contains(opCode) || Objects.equals(opCode, "inspect-repair")).collect(Collectors.toList());
        if (controlActTimes.size() == 1 && StringUtils.isNotEmpty((String)(factBackAmtField = (controlActTime2 = (ControlActTime)controlActTimes.get(0)).getFactBackAmtField()))) {
            props.add(factBackAmtField);
        }
        if ((controlActTimeList = controlTime.getControlActTimeList().stream().filter(Objects::nonNull).filter(item -> Objects.equals(item.getBizBill(), entityType)).filter(item -> EmptyUtil.isNoEmpty(item.getActUpdateTime())).filter(item -> item.getActUpdateTime().contains(opCode) || Objects.equals(opCode, "inspect-repair")).collect(Collectors.toList())).size() == 1 && StringUtils.isNotEmpty((String)(aclUpdateAmtField = (controlActTime = (ControlActTime)controlActTimeList.get(0)).getAclUpdateAmtField()))) {
            props.add(aclUpdateAmtField);
        }
        return props;
    }

    private static List<BillMatchRule> getMatchRule(String billSign) {
        return controlRepository.loadControlMatchRule(billSign, Boolean.TRUE, new Long[0]);
    }

    private static PrepareParam toPlainDynamicObjectCollection(BillMatchRule billMatchRule, DynamicObject[] selectBills, ControlContext controlContext) {
        Set<String> needProps = GenerateControlExecLogParamHelper.getNeedQueryProp(billMatchRule, controlContext);
        Set<String> extraConditionFields = GenerateControlExecLogParamHelper.collectExtraConditionFields(billMatchRule, needProps);
        HashMap<String, Boolean> relations = new HashMap<String, Boolean>(16);
        DynamicObjectType dt = GenerateControlExecLogParamHelper.getDynamicObjectType(billMatchRule, needProps, relations);
        DynamicSimpleProperty[] properties = (DynamicSimpleProperty[])dt.getProperties().toArray((Object[])new DynamicSimpleProperty[0]);
        DynamicObjectCollection ret = new DynamicObjectCollection(dt, null);
        if (billMatchRule.isBillHead()) {
            for (DynamicObject selectBill : selectBills) {
                DynamicObject obj = new DynamicObject(dt, true);
                GenerateControlExecLogParamHelper.fillBillHeadProperty(properties, selectBill, obj);
                ret.add((Object)obj);
            }
        } else {
            for (DynamicObject selectBill : selectBills) {
                GenerateControlExecLogParamHelper.fillBillEntryProperty(billMatchRule, relations, dt, properties, ret, selectBill);
            }
        }
        Map<String, DynamicProperty> filterProperties = GenerateControlExecLogParamHelper.getFilterProperties(billMatchRule, extraConditionFields, ret);
        DynamicObject[] plainDynamicArr = (DynamicObject[])ret.toArray((Object[])new DynamicObject[0]);
        return new PrepareParam(plainDynamicArr, filterProperties, billMatchRule);
    }

    private static void fillBillEntryProperty(BillMatchRule billMatchRule, Map<String, Boolean> relations, DynamicObjectType dt, DynamicSimpleProperty[] properties, DynamicObjectCollection ret, DynamicObject selectBill) {
        String mappingEntryNumber = billMatchRule.getMappingEntryNumber();
        DynamicObjectCollection entrys = selectBill.getDynamicObjectCollection(mappingEntryNumber);
        for (DynamicObject entry : entrys) {
            DynamicObject obj = new DynamicObject(dt, true);
            obj.beginInit();
            for (int i = 0; i < properties.length; ++i) {
                Object value;
                DynamicSimpleProperty simplePropertie = properties[i];
                String name = simplePropertie.getName();
                Boolean isHeadProp = relations.get(name);
                try {
                    value = isHeadProp != false ? selectBill.get(name) : entry.get(Objects.equals(name, String.format("%s.id", mappingEntryNumber)) ? "id" : name);
                }
                catch (ORMDesignException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fpm_bodysysmanage", (String)"name", (QFilter[])new QFilter("id", "=", (Object)billMatchRule.getSystemId()).toArray());
                    String sb = e.getMessage() + String.format(ResManager.loadKDString((String)"\u4f46\u3010%1$s\u3011\u8ba1\u5212\u4f53\u7cfb\u7684\u3010%2$s\u3011\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u5df2\u5f15\u7528\u8be5\u5c5e\u6027\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"GenerateControlExecLogParamHelper_3", (String)"tmc-fpm-business", (Object[])new Object[0]), dynamicObject.getString("name"), billMatchRule.getName());
                    throw new KDBizException(sb);
                }
                if (value instanceof OrmLocaleValue) {
                    value = ((OrmLocaleValue)value).getLocaleValue();
                }
                simplePropertie.setValueFast((Object)obj, value);
            }
            obj.endInit();
            ret.add((Object)obj);
        }
    }

    private static Map<String, DynamicProperty> getFilterProperties(BillMatchRule billMatchRule, Set<String> extraConditionFields, DynamicObjectCollection ret) {
        HashMap<String, DynamicProperty> filterProperties = new HashMap<String, DynamicProperty>(extraConditionFields.size());
        Set entryNames = EntityMetadataCache.getDataEntityType((String)billMatchRule.getEntityType()).getAllEntities().keySet();
        String billSign = billMatchRule.getEntityType();
        Optional.ofNullable(ret).filter(o -> !o.isEmpty()).ifPresent(doc -> {
            DynamicObjectType dType = doc.getDynamicObjectType();
            extraConditionFields.forEach(elem -> {
                String entryName;
                int index = elem.indexOf(".");
                String elemFinal = elem;
                if (index != -1 && entryNames.contains(entryName = elem.substring(0, index))) {
                    elemFinal = elem.substring(index + 1);
                }
                filterProperties.put((String)elem, dType.getProperty(elemFinal));
            });
            doc.forEach(o -> o.getDynamicObjectType().setName(billSign));
        });
        return filterProperties;
    }

    private static void fillBillHeadProperty(DynamicSimpleProperty[] properties, DynamicObject selectBill, DynamicObject obj) {
        obj.beginInit();
        for (int i = 0; i < properties.length; ++i) {
            DynamicSimpleProperty simpleProperties = properties[i];
            String name = simpleProperties.getName();
            properties[i].setValueFast((Object)obj, selectBill.get(name));
        }
        obj.endInit();
    }

    private static DynamicObjectType getDynamicObjectType(BillMatchRule billMatchRule, Set<String> needProps, Map<String, Boolean> relations) {
        String billSign = billMatchRule.getEntityType();
        String mappingEntryNumber = billMatchRule.getMappingEntryNumber();
        boolean isBillHead = Objects.equals(billSign, mappingEntryNumber);
        DynamicObjectType dt = new DynamicObjectType("PlainObject");
        for (String fieldName : needProps) {
            Class<Object> propertyType = Object.class;
            String tureProp = fieldName;
            String entrySign = String.format("%s.", mappingEntryNumber);
            if (!isBillHead) {
                String entryIdProp = String.format("%s.id", mappingEntryNumber);
                tureProp = Objects.equals(fieldName, entryIdProp) ? fieldName : fieldName.replace(entrySign, "");
            }
            relations.put(tureProp, !fieldName.contains(entrySign));
            DynamicSimpleProperty property = new DynamicSimpleProperty(tureProp, propertyType, null);
            property.setEnableNull(true);
            dt.registerSimpleProperty(property);
        }
        return dt;
    }

    private static final class PrepareParam {
        private DynamicObject[] selectBills;
        private Map<String, DynamicProperty> filterProperties;
        private BillMatchRule matchRule;

        public PrepareParam(DynamicObject[] selectBills, Map<String, DynamicProperty> filterProperties, BillMatchRule matchRule) {
            this.selectBills = selectBills;
            this.filterProperties = filterProperties;
            this.matchRule = matchRule;
        }

        public DynamicObject[] getSelectBills() {
            return this.selectBills;
        }

        public void setSelectBills(DynamicObject[] selectBills) {
            this.selectBills = selectBills;
        }

        public Map<String, DynamicProperty> getFilterProperties() {
            return this.filterProperties;
        }

        public void setFilterProperties(Map<String, DynamicProperty> filterProperties) {
            this.filterProperties = filterProperties;
        }

        public BillMatchRule getMatchRule() {
            return this.matchRule;
        }

        public void setMatchRule(BillMatchRule matchRule) {
            this.matchRule = matchRule;
        }
    }
}

