/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.rpc.impl;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.mvc.enums.UpgradeServiceEnum;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import kd.tmc.fpm.business.service.rpc.IFpmUpdateRPCService;
import kd.tmc.fpm.business.service.rpc.param.IParam;
import kd.tmc.fpm.business.service.rpc.param.ParamFactory;

public class DefaultFpmUpdateRpcService
implements IFpmUpdateRPCService {
    private static final Log LOGGER = LogFactory.getLog(DefaultFpmUpdateRpcService.class);

    @Override
    public String upgrade(List params) {
        RpcResult rpcResult = new RpcResult();
        if (EmptyUtil.isEmpty((Collection)params)) {
            rpcResult.setStatusCode(RpcResultStatusCode.ERROR);
            rpcResult.setMessage(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"DefaultFpmUpdateRpcService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return JSON.toJSONString((Object)rpcResult);
        }
        rpcResult.setStatusCode(RpcResultStatusCode.SUCCESS);
        ArrayList<String> errorMsg = new ArrayList<String>(8);
        for (Object param : params) {
            if (!(param instanceof String)) {
                LOGGER.info("\u53c2\u6570\u7c7b\u578b\u4e0d\u662f\u5b57\u7b26\u4e32");
                continue;
            }
            String paramStr = (String)param;
            IParam iParam = ParamFactory.getParam(paramStr);
            IUpgradeService upgradeServiceByTypeClass = this.getUpgradeService(iParam);
            try {
                upgradeServiceByTypeClass.updateData();
            }
            catch (KDBizException bizException) {
                LOGGER.error((Throwable)bizException);
                errorMsg.add(String.join((CharSequence)":", paramStr, bizException.getMessage()));
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                upgradeServiceByTypeClass.handleException(e, errorMsg);
            }
        }
        if (EmptyUtil.isNoEmpty(errorMsg)) {
            rpcResult.setStatusCode(RpcResultStatusCode.ERROR);
            rpcResult.setMessage(errorMsg.stream().collect(Collectors.joining(";")));
        }
        return JSON.toJSONString((Object)rpcResult);
    }

    protected IUpgradeService getUpgradeService(IParam iParam) {
        IUpgradeService upgradeServiceByTypeClass = UpgradeServiceEnum.getUpgradeServiceByTypeClass(iParam.getUpgradeClassName());
        if (upgradeServiceByTypeClass != UpgradeServiceEnum.DEFAULT_UPDATE_SERVICE.getInstance()) {
            return upgradeServiceByTypeClass;
        }
        if (EmptyUtil.isEmpty((String)iParam.getUpgradeClassName())) {
            return upgradeServiceByTypeClass;
        }
        try {
            Class<?> aClass = Class.forName(iParam.getUpgradeClassName());
            try {
                Constructor<?> constructor = aClass.getConstructor(IParam.class);
                return (IUpgradeService)constructor.newInstance(iParam);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("NoSuchMethodException", (Throwable)e);
                return (IUpgradeService)aClass.newInstance();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }
}

