/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.rpc.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncData;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.service.ie.gather.convert.IEGatherSchemeDataConvert;
import kd.tmc.fpm.business.service.ie.gather.helper.MetadateDealHelper;
import kd.tmc.fpm.business.service.ie.gather.helper.SchemeGatherHelper;
import kd.tmc.fpm.business.service.ie.gather.model.GatherRecord;
import kd.tmc.fpm.business.service.ie.gather.model.IntelligentGatherScheme;
import kd.tmc.fpm.business.service.ie.gather.service.gather.FpmCollectTransfer;
import kd.tmc.fpm.business.service.ie.gather.service.gather.impl.BalancePoolDiscardService;

public class FpmETLSyncDataService
extends EventualConsistencyService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DtxResponse execute(Object o, Object o1) throws Exception {
        block29: {
            CommonParam commonParam = (CommonParam)o;
            String entityType = (String)commonParam.get((Object)"__ENTITY_TYPE");
            String opType = (String)commonParam.get((Object)"__OPERATE_TYPE");
            Date operateTime = (Date)commonParam.get((Object)"__OPERATE_TIME");
            long userId = RequestContext.get().getCurrUserId();
            DynamicObject currUser = null;
            if (userId != 0L) {
                currUser = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
            }
            List dataList = (List)commonParam.get((Object)"__DATA");
            ArrayList<SyncData> syncDataList = new ArrayList<SyncData>(dataList.size());
            for (Map dataMap : dataList) {
                Long dataId = (Long)dataMap.get("__KEY_DATA_ID");
                Integer version = (Integer)dataMap.get("__KEY_VERSION");
                SyncData syncData = new SyncData(dataId, version);
                syncDataList.add(syncData);
            }
            List sourceIdList = syncDataList.stream().map(SyncData::getId).collect(Collectors.toList());
            QFilter sourceIdFilter = new QFilter("sourcebillid", "in", sourceIdList);
            DynamicObjectCollection dbCollectList = QueryServiceHelper.query((String)"fpm_inoutcollect", (String)String.join((CharSequence)",", "sourcebillid", "synctime"), (QFilter[])new QFilter[]{sourceIdFilter});
            Set idSet = dbCollectList.stream().filter(t -> {
                if (operateTime == null) {
                    return true;
                }
                Date syncTime = t.getDate("synctime");
                if (syncTime == null) {
                    return true;
                }
                return operateTime.compareTo(syncTime) > 0;
            }).map(t -> t.getLong("sourcebillid")).collect(Collectors.toSet());
            if (idSet.size() == 0) {
                return null;
            }
            if ("UPDATE".equals(opType)) {
                QFilter filter = new QFilter("enable", "=", (Object)"1");
                filter.and(new QFilter("sourcebill", "=", (Object)entityType));
                DynamicObject[] smartCollectPlans = TmcDataServiceHelper.load((String)"fpm_smartcollect", (String)String.format("%s,%s", "name", "id"), (QFilter[])new QFilter[]{filter});
                Set<Long> ids = Arrays.stream(smartCollectPlans).filter(Objects::nonNull).map(smartColPlan -> smartColPlan.getLong("id")).collect(Collectors.toSet());
                List<IntelligentGatherScheme> schemes = IEGatherSchemeDataConvert.getSmartCollectScheme(ids);
                List lockIds = idSet.stream().map(String::valueOf).collect(Collectors.toList());
                Map lockResult = MutexServiceHelper.batchRequest(lockIds, (String)entityType, (String)"_collect_");
                HashSet<String> successLockIds = new HashSet<String>();
                for (Map.Entry entry : lockResult.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    successLockIds.add(key);
                }
                if (successLockIds.size() == 0) {
                    return null;
                }
                idSet.removeIf(t -> !successLockIds.contains(String.valueOf(t)));
                HashSet waitSyncIdSet = new HashSet();
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        for (IntelligentGatherScheme scheme : schemes) {
                            MainEntityType sourceMainEntityType = MetadataServiceHelper.getDataEntityType((String)scheme.getSourceBill());
                            CRCondition applyFilter = (CRCondition)SerializationUtils.fromJsonString((String)scheme.getApplyCondi(), CRCondition.class);
                            Set<String> attrs = SchemeGatherHelper.collectQueryAttr(scheme, sourceMainEntityType, applyFilter);
                            String queryProps = attrs.stream().collect(Collectors.joining(","));
                            FilterBuilder filterBuilder = new FilterBuilder(sourceMainEntityType, applyFilter.getFilterCondition(), true);
                            filterBuilder.buildFilter(true);
                            QFilter qFilter = filterBuilder.getQFilter();
                            if (qFilter == null) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u5f02\u5e38\uff1a\u9002\u7528\u6761\u4ef6\u4e3a\u7a7a\uff0c\u68c0\u67e5\u63d2\u4ef6\u6821\u9a8c", (String)"FpmETLSyncDataService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
                            }
                            QFilter idFilter = new QFilter("id", "in", idSet);
                            DataSet dsn = ORM.create().queryDataSet(FpmETLSyncDataService.class.getName(), scheme.getSourceBill(), queryProps, new QFilter[]{idFilter, qFilter});
                            Tuple<DynamicObjectCollection, Map<String, DynamicProperty>> tuple = MetadateDealHelper.toPlainDynamicObject(dsn, attrs, scheme);
                            DynamicObjectCollection rets = (DynamicObjectCollection)tuple.item1;
                            DynamicObject[] bills = (DynamicObject[])rets.toArray((Object[])new DynamicObject[0]);
                            FpmCollectTransfer transfer = new FpmCollectTransfer(scheme, currUser, operateTime == null ? new Date() : operateTime);
                            List<GatherRecord> result = transfer.transfer(bills, (Map)tuple.item2);
                            List successIdList = result.stream().filter(GatherRecord::getExecuteResult).map(GatherRecord::getSourceBillId).collect(Collectors.toList());
                            waitSyncIdSet.addAll(successIdList);
                        }
                        CommonParam param = new CommonParam();
                        ArrayList paramList = new ArrayList(waitSyncIdSet.size());
                        for (SyncData syncData : syncDataList) {
                            if (!waitSyncIdSet.contains(syncData.getId())) continue;
                            HashMap<String, Number> syncInfoMap = new HashMap<String, Number>();
                            syncInfoMap.put("__KEY_DATA_ID", syncData.getId());
                            int version = syncData.getVersion();
                            syncInfoMap.put("__KEY_VERSION", version);
                            paramList.add(syncInfoMap);
                        }
                        if (paramList.size() > 0) {
                            param.put((Object)"__ENTITY_TYPE", (Object)entityType);
                            param.put((Object)"__DATA", paramList);
                            param.put((Object)"__OPERATE_TYPE", (Object)"UPDATE");
                            ECGlobalSession.begin((String)"fpm_etlupdate", (DBRoute)DBRoute.of((String)"tmc"), (boolean)true);
                            ECGlobalSession.setAsync((boolean)true);
                            ECGlobalSession.register((String)"tmc", (String)"fpm", (String)"FpmETLUpdateDataService", (Param)param);
                        }
                        break block29;
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
                finally {
                    MutexServiceHelper.batchRelease(new ArrayList(successLockIds), (String)entityType, (String)"_collect_");
                }
            }
            if ("DISCARD".equals(opType)) {
                syncDataList.removeIf(t -> !idSet.contains(t.getId()));
                if (syncDataList.size() > 0) {
                    BalancePoolDiscardService.getInstance().discard(entityType, syncDataList, operateTime == null ? new Date() : operateTime);
                }
            }
        }
        return null;
    }
}

