/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.rules.reportcheck.service.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportDataSourceType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.ReportValueFormulaTypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportVerifyCheckTypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportVerifyDataRelTypeEnum;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportChangeData;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportVerifyRule;
import kd.tmc.fpm.business.domain.model.report.ReportVerifyRuleDimension;
import kd.tmc.fpm.business.domain.model.report.ReportVerifyRuleDimensionMember;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.report.VerifyReport;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionCombination;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.IReportVerifyRuleRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportQDTO;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportVerifyRuleRepository;
import kd.tmc.fpm.business.mvc.service.dto.ReportRuleCheckDTO;
import kd.tmc.fpm.business.mvc.service.dto.ReportRuleCheckParamDTO;
import kd.tmc.fpm.business.mvc.service.dto.ReportVerifyRuleNotifyDTO;
import kd.tmc.fpm.business.service.rules.reportcheck.service.IReportRuleCheck;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.bean.FpmContext;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.utils.AmountUtil;
import org.apache.commons.lang3.tuple.Pair;

public class ReportRuleCheckService
implements IReportRuleCheck {
    private static final Log logger = LogFactory.getLog(ReportRuleCheckService.class);
    private final IDimensionRepository dimensionRepository = new DimensionRepository();
    private final IReportRepository reportRepository = new ReportRepository();
    private IReportVerifyRuleRepository ruleRepository = new ReportVerifyRuleRepository();

    @Override
    public List<ReportRuleCheckDTO> initRuleCheck(ReportRuleCheckParamDTO checkParam) {
        List<ReportRuleCheckDTO> ruleChecks = checkParam.getRuleChecks();
        if (!EmptyUtil.isEmpty(ruleChecks)) {
            return ruleChecks.stream().filter(d -> !TemplateType.isDetail(d.getTemplateType())).collect(Collectors.toList());
        }
        return this.initReportRuleChecks(checkParam);
    }

    private List<ReportRuleCheckDTO> initReportRuleChecks(ReportRuleCheckParamDTO checkParam) {
        Collection verifyReports = checkParam.getVerifyReports();
        if (EmptyUtil.isEmpty((Collection)(verifyReports = (Collection)verifyReports.stream().filter(d -> !d.getTemplate().getTemplateType().isDetail()).collect(Collectors.toList())))) {
            return Collections.emptyList();
        }
        Map<String, List<ReportVerifyRule>> verifyRuleMap = this.getVerifyRuleMap(verifyReports);
        return this.getReportRuleChecks(checkParam, verifyReports, verifyRuleMap);
    }

    private List<ReportRuleCheckDTO> getReportRuleChecks(ReportRuleCheckParamDTO checkParam, Collection<VerifyReport> verifyReports, Map<String, List<ReportVerifyRule>> verifyRuleMap) {
        ArrayList<ReportRuleCheckDTO> ruleChecks = new ArrayList<ReportRuleCheckDTO>(verifyReports.size());
        for (VerifyReport report : verifyReports) {
            long systemId = report.getSystemId();
            PeriodMember periodMember = report.getPeriodMember();
            long reportTypeId = periodMember.getPeriodTypeId();
            List<ReportVerifyRule> verifyRules = verifyRuleMap.get(this.getRuleKey(systemId, reportTypeId));
            if (EmptyUtil.isEmpty(verifyRules)) continue;
            ReportRuleCheckDTO checkDTO = new ReportRuleCheckDTO();
            checkDTO.setReportId(report.getId());
            OrgMember orgMember = report.getOrgMember();
            checkDTO.setOrgId(orgMember.getId());
            checkDTO.setOrgName(orgMember.getName());
            checkDTO.setReportTypeId(reportTypeId);
            checkDTO.setReportPeriodId(periodMember.getId());
            checkDTO.setReportPeriodName(periodMember.getName());
            checkDTO.setDataSourceType(checkParam.getDataSourceType());
            checkDTO.setReportManagerJson(checkParam.getReportManagerJson());
            checkDTO.setFromCommit(checkParam.isFromCommit());
            checkDTO.setBatchCommit(checkParam.isBatchCommit());
            ReportTemplate template = report.getTemplate();
            checkDTO.setTemplateType(template != null ? template.getTemplateType().getNumber() : null);
            checkDTO.setSystemId(systemId);
            checkDTO.setVerifyRules(verifyRules);
            checkDTO.setSystem(this.dimensionRepository.loadSystem(checkDTO.getSystemId()));
            ruleChecks.add(checkDTO);
        }
        return ruleChecks;
    }

    private Map<String, List<ReportVerifyRule>> getVerifyRuleMap(Collection<VerifyReport> verifyReports) {
        Map<String, List<VerifyReport>> reportGroupMap = verifyReports.stream().collect(Collectors.groupingBy(d -> this.getRuleKey(d.getSystemId(), d.getPeriodMember().getPeriodTypeId())));
        HashMap<String, List<ReportVerifyRule>> verifyRuleMap = new HashMap<String, List<ReportVerifyRule>>(reportGroupMap.size());
        for (Map.Entry<String, List<VerifyReport>> entry : reportGroupMap.entrySet()) {
            Long[] ids = this.splitRuleKey(entry.getKey());
            List<ReportVerifyRule> verifyRules = this.ruleRepository.load(ids[0], Collections.singletonList(ids[1]));
            if (EmptyUtil.isEmpty(verifyRules)) continue;
            verifyRuleMap.put(entry.getKey(), verifyRules);
        }
        return verifyRuleMap;
    }

    private String getRuleKey(Long systemId, Long reportTypeId) {
        return String.format("%d_%d", systemId, reportTypeId);
    }

    private Long[] splitRuleKey(String ruleKey) {
        String[] split = ruleKey.split("_");
        return new Long[]{Long.parseLong(split[0]), Long.parseLong(split[1])};
    }

    @Override
    public List<ReportVerifyRule> loadRuleAndFilter(ReportRuleCheckDTO checkDTO) {
        ReportDataSource dataSource = checkDTO.getDataSource();
        List<ReportVerifyRule> verifyRules = checkDTO.getVerifyRules();
        if (verifyRules == null) {
            verifyRules = this.loadRule(checkDTO.getSystem().getId(), checkDTO.getReportTypeId());
        }
        if (CollectionUtils.isEmpty(verifyRules)) {
            return verifyRules;
        }
        ArrayList<ReportVerifyRule> finalRule = new ArrayList<ReportVerifyRule>(verifyRules.size());
        for (ReportVerifyRule verifyRule : verifyRules) {
            ReportTemplate template;
            Set numbers;
            boolean matchMember;
            ReportPeriodType reportPeriodType = dataSource.getReportPeriodType();
            List periodTypeIdList = verifyRule.getPeriodTypeList().stream().map(ReportPeriodType::getReportPeriodId).collect(Collectors.toList());
            if (!periodTypeIdList.contains(reportPeriodType.getReportPeriodId())) {
                logger.info("ReportRuleCheckService.ruleCheck \u9002\u7528\u7f16\u62a5\u7c7b\u578b\u4e0d\u5339\u914d, \u89c4\u5219:{}, \u62a5\u8868\u7f16\u62a5\u7c7b\u578b:{}-{}", new Object[]{verifyRule.getId(), reportPeriodType.getId(), reportPeriodType.getNumber()});
                continue;
            }
            ReportVerifyRuleDimension orgDimension = this.getOrgDimension(verifyRule);
            if (Objects.nonNull(orgDimension) && CollectionUtils.isNotEmpty(orgDimension.getMemberParams()) && !(matchMember = orgDimension.getMemberParams().stream().anyMatch(item -> item.getDimensionMemberId().equals(checkDTO.getOrgId())))) {
                logger.info("ReportRuleCheckService.ruleCheck \u7f16\u62a5\u4e3b\u4f53\u4e0d\u5339\u914d, \u89c4\u5219:{}, \u62a5\u8868\u7f16\u62a5\u4e3b\u4f53:{}", (Object)verifyRule.getId(), (Object)orgDimension.getDimensionId());
                continue;
            }
            if (verifyRule.isTemplateCheck() && !(numbers = verifyRule.getReportTemplateList().stream().map(ReportTemplate::getNumber).collect(Collectors.toSet())).contains((template = dataSource.getTemplate()).getNumber())) {
                logger.info("ReportRuleCheckService.ruleCheck \u6a21\u677f\u4e0d\u5339\u914d, \u89c4\u5219:{}, \u62a5\u8868\u6a21\u677f:{}-{}", new Object[]{verifyRule.getId(), template.getId(), template.getName()});
                continue;
            }
            finalRule.add(verifyRule);
        }
        return finalRule;
    }

    @Override
    public List<ReportVerifyRuleNotifyDTO> ruleCheck(ReportRuleCheckDTO checkDTO) {
        List<ReportVerifyRule> verifyRules = checkDTO.getVerifyRules();
        ReportDataSource dataSource = checkDTO.getDataSource();
        ArrayList<ReportVerifyRuleNotifyDTO> notifys = new ArrayList<ReportVerifyRuleNotifyDTO>(16);
        if (Objects.isNull(checkDTO.getSystem())) {
            checkDTO.setSystem(this.dimensionRepository.loadSystem(dataSource.getTemplate().getSystemId()));
        }
        FpmContext.get().put("fundSystem", (Object)checkDTO.getSystem());
        if (dataSource instanceof Report) {
            logger.info("ReportRuleCheckService.ruleCheck \u5f00\u59cb\u68c0\u6d4b\u62a5\u8868\u6570\u636e\uff0c\u5f53\u524d\u62a5\u8868:{}", (Object)((Report)dataSource).getNumber());
        }
        for (ReportVerifyRule verifyRule : verifyRules) {
            ReportVerifyRuleNotifyDTO notify = this.startCheck(checkDTO, verifyRule);
            if (notify.isPass()) {
                logger.info("ReportRuleCheckService.ruleCheck \u6821\u9a8c\u901a\u8fc7\uff0c\u89c4\u5219:{}, \u5de6\u4fa7\u503c:{} ,\u53f3\u4fa7\u503c:{}", new Object[]{notify.getRuleId(), notify.getLeftExpressResult(), notify.getRightExpressResult()});
                continue;
            }
            logger.info("ReportRuleCheckService.ruleCheck \u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u89c4\u5219:{}, \u5de6\u4fa7\u503c:{} ,\u53f3\u4fa7\u503c:{}", new Object[]{notify.getRuleId(), notify.getLeftExpressResult(), notify.getRightExpressResult()});
            notifys.add(notify);
        }
        FpmContext.get().clear();
        return notifys;
    }

    @Override
    public List<ReportVerifyRule> loadRule(Long systemId, Long reportTypeId) {
        return this.ruleRepository.load(systemId, Collections.singletonList(reportTypeId));
    }

    private ReportVerifyRuleNotifyDTO startCheck(ReportRuleCheckDTO checkDTO, ReportVerifyRule verifyRule) {
        Pair<Boolean, List<ReportVerifyRuleDimension>> dimensionRange = this.getAndConfirmDimensionRange(checkDTO, verifyRule);
        List<Long> checkedReportPeriod = this.getCheckedReportPeriod(checkDTO.getReportPeriodId(), verifyRule, checkDTO.getSystem());
        List<ReportDataSource> checkReports = this.getReports(checkDTO, Lists.newArrayList((Object[])new Long[]{checkDTO.getReportPeriodId()}));
        ReportVerifyRuleNotifyDTO result = this.initRuleNotify(verifyRule);
        if (CollectionUtils.isEmpty(checkReports)) {
            return result;
        }
        this.setDimensionMember(result, (List)dimensionRange.getRight());
        this.setReportInfo(result, checkDTO, checkReports.get(0));
        if (((Boolean)dimensionRange.getLeft()).booleanValue()) {
            this.verifyDataByAdd(checkDTO, verifyRule, dimensionRange, checkedReportPeriod, checkReports, result);
        } else {
            this.verifyDataByOrder(checkDTO, verifyRule, dimensionRange, checkedReportPeriod, checkReports, result);
        }
        return result;
    }

    private ReportVerifyRuleNotifyDTO initRuleNotify(ReportVerifyRule verifyRule) {
        ReportVerifyRuleNotifyDTO result = new ReportVerifyRuleNotifyDTO();
        result.setPass(true);
        result.setRuleId(verifyRule.getId());
        result.setCheckEffect(verifyRule.getCheckEffect());
        return result;
    }

    private void setDimensionMember(ReportVerifyRuleNotifyDTO result, List<ReportVerifyRuleDimension> dimensionList) {
        result.setCurrencyDimensionId(this.getMemberByType(DimensionType.CURRENCY, dimensionList));
        result.setPeriodDimensionId(this.getMemberByType(DimensionType.PERIOD, dimensionList));
        result.setSubjectDimensionId(this.getMemberByType(DimensionType.SUBJECTS, dimensionList));
        result.setSettlementTypeDimensionId(this.getMemberByType(DimensionType.SETTLEMENT_TYPE, dimensionList));
        result.setCompanyDimensionId(this.getMemberByType(DimensionType.COMPANY, dimensionList));
    }

    private void setReportInfo(ReportVerifyRuleNotifyDTO result, ReportRuleCheckDTO checkDTO, ReportDataSource dataSource) {
        PlanChangeReport changeReport;
        Report report;
        result.setFromCommit(checkDTO.getFromCommit());
        result.setBatchCommit(checkDTO.getBatchCommit());
        result.setOrgName(checkDTO.getOrgName());
        result.setPeriodName(checkDTO.getReportPeriodName());
        if (dataSource instanceof Report) {
            Report report2 = (Report)dataSource;
            result.setReportNumber(report2.getNumber());
            if (dataSource instanceof SumPlanReport) {
                SumPlanReport sumPlanReport = (SumPlanReport)dataSource;
                result.setReportNumber(sumPlanReport.getNumber());
            }
            List<Long> orgIds = report2.getCompanyMemberList().stream().map(DimMember::getId).collect(Collectors.toList());
            result.setReportOrgDimensionId(orgIds);
        } else if (dataSource instanceof PlanChangeReport && EmptyUtil.isNoEmpty((Object)(report = this.reportRepository.loadReport((changeReport = (PlanChangeReport)dataSource).getReportId())))) {
            result.setReportNumber(report.getNumber());
            List<Long> orgIds = report.getCompanyMemberList().stream().map(DimMember::getId).collect(Collectors.toList());
            result.setReportOrgDimensionId(orgIds);
        }
        if (StringUtils.isNotEmpty((String)checkDTO.getNumber())) {
            result.setReportNumber(checkDTO.getNumber());
        }
    }

    private List<Long> getMemberByType(DimensionType type, List<ReportVerifyRuleDimension> dimensionList) {
        return dimensionList.stream().filter(item -> type.getNumber().equals(item.getDimsionEnums().getNumber())).map(ReportVerifyRuleDimension::getMemberParams).flatMap(Collection::stream).map(ReportVerifyRuleDimensionMember::getDimensionMemberId).collect(Collectors.toList());
    }

    private void verifyDataByAdd(ReportRuleCheckDTO checkDTO, ReportVerifyRule verifyRule, Pair<Boolean, List<ReportVerifyRuleDimension>> dimensionRange, List<Long> periodIds, List<ReportDataSource> checkReports, ReportVerifyRuleNotifyDTO result) {
        List<ReportDataSource> checkedReports;
        ReportDataSource dataSource = checkDTO.getDataSource();
        AmountUnit amountUnit = dataSource.getTemplate().getAmountUnit();
        TemplateType templateType = dataSource.getTemplate().getTemplateType();
        boolean mainTable = dataSource.getTemplate().isMainTable();
        if (this.checkBetweenTable(verifyRule)) {
            checkedReports = this.getReports(checkDTO.getOrgId(), checkDTO.getDataSource(), periodIds, ReportStatus.ENABLE);
            if (CollectionUtils.isEmpty(checkedReports)) {
                logger.info("ReportRuleCheckService.ruleCheck \u6821\u9a8c\u901a\u8fc7\uff0c\u89c4\u5219:{},\u6821\u9a8c\u7c7b\u578b:{},\u671f\u95f4\u8303\u56f4\u4e0b\u65e0\u53ef\u7528\u62a5\u8868 \u8df3\u8fc7\u6821\u9a8c", (Object)verifyRule.getId(), (Object)verifyRule.getCheckType().getValue());
                result.setPass(true);
                return;
            }
            checkedReports = checkedReports.stream().filter(item -> item.getTemplate().getTemplateType() == templateType).filter(item -> item.getTemplate().isMainTable() == mainTable).collect(Collectors.toList());
        } else {
            checkedReports = checkReports;
        }
        if (ReportRuleCheckService.isContainCurrency(dimensionRange)) {
            this.validate(checkDTO, verifyRule, periodIds, result, amountUnit, checkReports, checkedReports);
        } else {
            this.validateOrderByCurrency(checkDTO, verifyRule, periodIds, result, amountUnit, checkReports, checkedReports);
        }
    }

    private void verifyDataByOrder(ReportRuleCheckDTO checkDTO, ReportVerifyRule verifyRule, Pair<Boolean, List<ReportVerifyRuleDimension>> dimensionRange, List<Long> periodIds, List<ReportDataSource> checkReports, ReportVerifyRuleNotifyDTO result) {
        List<ReportDataSource> checkedReports;
        Set<List<ReportVerifyRuleDimensionMember>> circulateMembers = this.filterAndCirculateMembers((List)dimensionRange.getRight(), checkReports);
        if (CollectionUtils.isEmpty(circulateMembers)) {
            result.setPass(true);
            return;
        }
        ReportDataSource dataSource = checkDTO.getDataSource();
        AmountUnit amountUnit = dataSource.getTemplate().getAmountUnit();
        TemplateType templateType = dataSource.getTemplate().getTemplateType();
        boolean mainTable = dataSource.getTemplate().isMainTable();
        if (this.checkBetweenTable(verifyRule)) {
            checkedReports = this.getReports(checkDTO.getOrgId(), checkDTO.getDataSource(), periodIds, ReportStatus.ENABLE);
            if (CollectionUtils.isEmpty(checkedReports)) {
                result.setPass(true);
                return;
            }
            checkedReports = checkedReports.stream().filter(item -> item.getTemplate().getTemplateType() == templateType).filter(item -> item.getTemplate().isMainTable() == mainTable).collect(Collectors.toList());
        } else {
            checkedReports = checkReports;
        }
        if (ReportRuleCheckService.isContainCurrency(dimensionRange)) {
            this.orderValidate(checkDTO, verifyRule, periodIds, result, amountUnit, checkReports, checkedReports, circulateMembers);
        } else {
            FundPlanSystem system = checkDTO.getSystem();
            List currencyList = system.getDimList().stream().filter(item -> item.getDimType() == DimensionType.CURRENCY).collect(Collectors.toList());
            Dimension dimension = (Dimension)currencyList.get(0);
            for (DimMember dimMember : dimension.getAllDimMemberList()) {
                ReportVerifyRuleDimensionMember member = new ReportVerifyRuleDimensionMember();
                member.setDimensionId(dimension.getId());
                member.setDimensionMemberId(dimMember.getId());
                member.setDimensionMemberName(dimMember.getName());
                result.setCurrencyDimensionId(Lists.newArrayList((Object[])new Long[]{dimMember.getId()}));
                circulateMembers.forEach(item -> item.add(member));
                this.orderValidate(checkDTO, verifyRule, periodIds, result, amountUnit, checkReports, checkedReports, circulateMembers);
                if (!result.isPass()) break;
                circulateMembers = circulateMembers.stream().map(item -> item.stream().filter(i -> !Objects.equals(i.getDimensionMemberId(), member.getDimensionMemberId())).collect(Collectors.toList())).collect(Collectors.toSet());
            }
        }
    }

    private void orderValidate(ReportRuleCheckDTO checkDTO, ReportVerifyRule verifyRule, List<Long> periodIds, ReportVerifyRuleNotifyDTO result, AmountUnit amountUnit, List<ReportDataSource> checkReports, List<ReportDataSource> checkedReports, Set<List<ReportVerifyRuleDimensionMember>> circulateMembers) {
        ReportDataSource reportDataSource = checkReports.get(0);
        for (List<ReportVerifyRuleDimensionMember> circulateMember : circulateMembers) {
            List<ReportData> rightReportData;
            List dimensionIdList = circulateMember.stream().map(ReportVerifyRuleDimensionMember::getDimensionId).collect(Collectors.toList());
            List membersIdList = circulateMember.stream().map(ReportVerifyRuleDimensionMember::getDimensionMemberId).collect(Collectors.toList());
            List<ReportData> leftReportData = checkReports.stream().map(item -> item.getReportDataByDimInfo(dimensionIdList, membersIdList)).flatMap(Collection::stream).collect(Collectors.toList());
            leftReportData = this.getReportData(checkDTO.getReportPeriodId(), reportDataSource, leftReportData, verifyRule);
            if (this.checkBetweenTable(verifyRule)) {
                rightReportData = checkedReports.stream().map(item -> item.getReportDataByDimInfo(dimensionIdList, membersIdList)).flatMap(Collection::stream).collect(Collectors.toList());
                rightReportData = this.getReportData(periodIds.get(0), reportDataSource, rightReportData, verifyRule);
            } else {
                rightReportData = leftReportData;
                rightReportData = this.getReportData(checkDTO.getReportPeriodId(), reportDataSource, rightReportData, verifyRule);
            }
            if (CollectionUtils.isEmpty(leftReportData) || CollectionUtils.isEmpty(rightReportData)) {
                return;
            }
            this.computeAndSetResult(checkDTO.getSystem(), verifyRule, result, amountUnit, leftReportData, rightReportData);
            if (result.isPass()) continue;
            return;
        }
    }

    private void validateOrderByCurrency(ReportRuleCheckDTO checkDTO, ReportVerifyRule verifyRule, List<Long> periodIds, ReportVerifyRuleNotifyDTO result, AmountUnit amountUnit, List<ReportDataSource> checkReports, List<ReportDataSource> checkedReports) {
        FundPlanSystem system = checkDTO.getSystem();
        List currencyList = system.getDimList().stream().filter(item -> item.getDimType() == DimensionType.CURRENCY).collect(Collectors.toList());
        Dimension dimension = (Dimension)currencyList.get(0);
        ReportVerifyRuleDimension currency = new ReportVerifyRuleDimension();
        currency.setDimensionId(dimension.getId());
        currency.setDimensionName(dimension.getName());
        currency.setDimsionEnums(DimensionType.CURRENCY);
        verifyRule.getCheckDimensionValue().add(currency);
        verifyRule.getCheckedDimensionValue().add(currency);
        for (DimMember dimMember : dimension.getAllDimMemberList()) {
            ArrayList<ReportVerifyRuleDimensionMember> memberParams = new ArrayList<ReportVerifyRuleDimensionMember>();
            ReportVerifyRuleDimensionMember member = new ReportVerifyRuleDimensionMember();
            member.setDimensionId(dimension.getId());
            member.setDimensionMemberId(dimMember.getId());
            member.setDimensionMemberName(dimMember.getName());
            memberParams.add(member);
            currency.setMemberParams(memberParams);
            result.setCurrencyDimensionId(Lists.newArrayList((Object[])new Long[]{dimMember.getId()}));
            this.validate(checkDTO, verifyRule, periodIds, result, amountUnit, checkReports, checkedReports);
            if (result.isPass()) continue;
            break;
        }
    }

    private void validate(ReportRuleCheckDTO checkDTO, ReportVerifyRule verifyRule, List<Long> periodIds, ReportVerifyRuleNotifyDTO result, AmountUnit amountUnit, List<ReportDataSource> checkReports, List<ReportDataSource> checkedReports) {
        Set<List<ReportVerifyRuleDimensionMember>> leftMembers = this.filterAndCirculateMembers(verifyRule.getCheckDimensionValue(), checkReports);
        if (CollectionUtils.isEmpty(leftMembers)) {
            logger.info("ReportRuleCheckService.ruleCheck \u6821\u9a8c\u901a\u8fc7\uff0c\u89c4\u5219:{},\u6821\u9a8c\u7c7b\u578b:{}, \u6821\u9a8c\u65b9\u6839\u636e\u6a21\u677f\u7ef4\u5ea6\u8fc7\u6ee4\u540e\u4e3a\u7a7a", (Object)verifyRule.getId(), (Object)verifyRule.getCheckType().getValue());
            result.setPass(true);
            return;
        }
        List<ReportData> leftReportData = this.getReportDataByMembers(checkReports, leftMembers, checkDTO.getReportPeriodId(), verifyRule);
        Set<List<ReportVerifyRuleDimensionMember>> rightMembers = this.filterAndCirculateMembers(verifyRule.getCheckedDimensionValue(), checkedReports);
        Long rightPeriodId = this.checkBetweenTable(verifyRule) ? periodIds.get(0) : checkDTO.getReportPeriodId();
        List<ReportData> rightReportData = this.getReportDataByMembers(checkedReports, rightMembers, rightPeriodId, verifyRule);
        this.computeAndSetResult(checkDTO.getSystem(), verifyRule, result, amountUnit, leftReportData, rightReportData);
    }

    private static boolean isContainCurrency(Pair<Boolean, List<ReportVerifyRuleDimension>> dimensionRange) {
        List allDimension = (List)dimensionRange.getRight();
        return allDimension.stream().anyMatch(item -> item.getDimsionEnums() == DimensionType.CURRENCY);
    }

    private void computeAndSetResult(FundPlanSystem system, ReportVerifyRule verifyRule, ReportVerifyRuleNotifyDTO result, AmountUnit amountUnit, List<ReportData> leftReportData, List<ReportData> rightReportData) {
        if (CollectionUtils.isEmpty(leftReportData) && CollectionUtils.isEmpty(rightReportData)) {
            result.setPass(true);
            logger.info("ReportRuleCheckService.ruleCheck \u89c4\u5219:{},\u6821\u9a8c\u7c7b\u578b:{}, \u5de6\u53f3\u4e24\u4fa7\u53d6\u503c\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u6821\u9a8c", (Object)verifyRule.getId(), (Object)verifyRule.getCheckType().getValue());
            return;
        }
        BigDecimal leftValue = this.addValueThenGetValueByExpress(system, verifyRule.getValueFormulaValue(), amountUnit, leftReportData);
        BigDecimal rightValue = this.addValueThenGetValueByExpress(system, verifyRule.getValuedFormulaValue(), amountUnit, rightReportData);
        boolean finalResult = false;
        ReportVerifyDataRelTypeEnum formulaType = verifyRule.getFormulaType();
        switch (formulaType) {
            case EQ: {
                finalResult = leftValue.subtract(rightValue).abs().compareTo(verifyRule.getTolerance()) <= 0;
                break;
            }
            case LT: 
            case LT_EQ: {
                finalResult = leftValue.subtract(rightValue).compareTo(verifyRule.getTolerance()) <= 0;
                break;
            }
            case GT: {
                finalResult = leftValue.subtract(rightValue).compareTo(verifyRule.getTolerance()) > 0;
                break;
            }
            case GT_EQ: {
                finalResult = leftValue.subtract(rightValue).compareTo(verifyRule.getTolerance()) >= 0;
                break;
            }
            case NOT_EQ: {
                finalResult = leftValue.subtract(rightValue).abs().compareTo(verifyRule.getTolerance()) > 0;
                break;
            }
        }
        result.setLeftExpressResult(leftValue);
        result.setRightExpressResult(rightValue);
        result.setPass(finalResult);
        logger.info("ReportRuleCheckService.ruleCheck \u89c4\u5219:{},\u6821\u9a8c\u7c7b\u578b:{},\u6821\u9a8c\u7ed3\u679c:{},\u5de6\u4fa7\u503c:{},\u53f3\u4fa7\u503c:{},\u8868\u8fbe\u5f0f:{}", new Object[]{verifyRule.getId(), verifyRule.getCheckType().getValue(), finalResult, leftValue, rightValue, formulaType.getCode()});
    }

    private List<ReportData> getReportDataByMembers(List<ReportDataSource> checkReports, Set<List<ReportVerifyRuleDimensionMember>> circulateMembers, Long reportPeriodId, ReportVerifyRule verifyRule) {
        ReportDataSource reportDataSource = checkReports.get(0);
        ArrayList<ReportData> resultData = new ArrayList<ReportData>();
        for (List<ReportVerifyRuleDimensionMember> memberList : circulateMembers) {
            List targetDimIdList = memberList.stream().map(ReportVerifyRuleDimensionMember::getDimensionId).collect(Collectors.toList());
            List targetDimValList = memberList.stream().map(ReportVerifyRuleDimensionMember::getDimensionMemberId).collect(Collectors.toList());
            List<ReportData> reportDataList = checkReports.stream().map(item -> item.getReportDataByDimInfo(targetDimIdList, targetDimValList)).flatMap(Collection::stream).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(reportDataList)) continue;
            List<ReportData> detailReportData = this.getReportData(reportPeriodId, reportDataSource, reportDataList, verifyRule);
            resultData.addAll(detailReportData);
        }
        return resultData;
    }

    private List<ReportData> getReportData(Long reportPeriodId, ReportDataSource reportDataSource, List<ReportData> reportDataList, ReportVerifyRule verifyRule) {
        FundPlanSystem system = (FundPlanSystem)FpmContext.get().get("fundSystem", FundPlanSystem.class);
        ArrayList<ReportData> detailReportData = new ArrayList();
        PeriodType detailPeriodType = reportDataSource.getReportPeriodType().getDetailPeriodType();
        if (EmptyUtil.isEmpty((Object)((Object)detailPeriodType))) {
            detailReportData = reportDataList.stream().filter(item -> item.getDimValList().contains(reportPeriodId)).collect(Collectors.toList());
        } else {
            Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
            List<DimMember> memberList = subjectDim.getAllDimMemberList();
            Set periodBeginEndSubjectId = memberList.stream().map(AccountMember.class::cast).filter(accountMember -> Objects.nonNull(accountMember.getPeriodDirection())).map(DimMember::getId).collect(Collectors.toSet());
            List<PeriodMember> periodMemberList = reportDataSource.getPeriodMemberList();
            List<PeriodMember> detailPeriodMember = periodMemberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(item -> (PeriodMember)item).filter(item -> item.getPeriodType() == detailPeriodType).filter(item -> {
                if (Objects.nonNull(item.getParentId())) {
                    return item.getParentId().equals(reportPeriodId);
                }
                return true;
            }).sorted(Comparator.comparing(PeriodMember::getStartDate).reversed()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(detailPeriodMember)) {
                if (this.checkBetweenTable(verifyRule)) {
                    this.addAllPeriodReportData(reportDataList, detailReportData, detailPeriodMember);
                } else {
                    List<ReportData> beginEndReportDataList = reportDataList.stream().filter(item -> periodBeginEndSubjectId.contains((Long)item.getDimValByDimensionId(subjectDim.getId()))).collect(Collectors.toList());
                    this.addLastPeriodReportData(beginEndReportDataList, detailReportData, detailPeriodMember);
                    List<ReportData> otherReportDataList = reportDataList.stream().filter(item -> !periodBeginEndSubjectId.contains((Long)item.getDimValByDimensionId(subjectDim.getId()))).collect(Collectors.toList());
                    this.addAllPeriodReportData(otherReportDataList, detailReportData, detailPeriodMember);
                }
            }
        }
        return detailReportData;
    }

    private void addLastPeriodReportData(List<ReportData> reportDataList, List<ReportData> detailReportData, List<PeriodMember> detailPeriodMember) {
        Long periodId = detailPeriodMember.get(0).getId();
        List reportData = reportDataList.stream().filter(item -> item.getDimValList().contains(periodId)).collect(Collectors.toList());
        detailReportData.addAll(reportData);
    }

    private void addAllPeriodReportData(List<ReportData> reportDataList, List<ReportData> detailReportData, List<PeriodMember> detailPeriodMember) {
        for (PeriodMember periodMember : detailPeriodMember) {
            List reportData = reportDataList.stream().filter(item -> item.getDimValList().contains(periodMember.getId())).collect(Collectors.toList());
            detailReportData.addAll(reportData);
        }
    }

    private Set<List<ReportVerifyRuleDimensionMember>> filterAndCirculateMembers(List<ReportVerifyRuleDimension> dimensionRange, List<ReportDataSource> checkReports) {
        List<ReportVerifyRuleDimension> filterDimension = this.filterDimensionByTemplateSet(checkReports, dimensionRange);
        if (CollectionUtils.isEmpty(filterDimension)) {
            return Collections.emptySet();
        }
        List<List<ReportVerifyRuleDimensionMember>> members = filterDimension.stream().map(ReportVerifyRuleDimension::getMemberParams).collect(Collectors.toList());
        return ReportRuleCheckService.circulate(members);
    }

    private List<ReportVerifyRuleDimension> filterDimensionByTemplateSet(List<ReportDataSource> checkReports, List<ReportVerifyRuleDimension> right) {
        List reportAllTemplate = checkReports.stream().map(item -> item.getTemplate().getAllTemplateDim()).flatMap(Collection::stream).collect(Collectors.toList());
        List reportAllTemplateExistDimension = reportAllTemplate.stream().map(TemplateDim::getDimensionId).collect(Collectors.toList());
        return right.stream().filter(item -> reportAllTemplateExistDimension.contains(item.getDimensionId())).collect(Collectors.toList());
    }

    private BigDecimal addValueThenGetValueByExpress(FundPlanSystem system, String valueFormulaValue, AmountUnit amountUnit, List<ReportData> reportData) {
        Object result;
        Expr expr = FormulaEngine.parseFormula((String)valueFormulaValue);
        HashMap<String, BigDecimal> variableMap = new HashMap<String, BigDecimal>(16);
        for (ReportValueFormulaTypeEnum typeEnum : ReportValueFormulaTypeEnum.values()) {
            if (!valueFormulaValue.contains(typeEnum.getValue())) continue;
            BigDecimal value = BigDecimal.ZERO;
            if ((value = this.getReportDataValueV1(reportData, typeEnum, value)).compareTo(BigDecimal.ZERO) == 0) {
                TemplateMetricType templateMetricType = MetricValueUtils.switchType(typeEnum);
                Dimension metricDim = system.getMainDimensionByDimType(DimensionType.METRIC);
                MetricMember metricMember = metricDim.getAllDimMemberList().stream().map(item -> (MetricMember)item).filter(item -> templateMetricType == item.getTemplateMetricType()).findFirst().orElse(null);
                if (Objects.nonNull(metricMember)) {
                    List<ReportData> reportDataByMetricType = reportData.stream().filter(item -> item.getDimValList().contains(metricMember.getId())).collect(Collectors.toList());
                    value = ReportRuleCheckService.getReportDataValueV2(reportDataByMetricType, typeEnum, value);
                } else {
                    logger.info("ReportRuleCheckService metric value is null, system id:{}", (Object)system.getId());
                }
            }
            value = AmountUtil.convert((AmountUnitEnum)((AmountUnitEnum)AmountUnitEnum.valueOf(AmountUnitEnum.class, (String)amountUnit.name())), (AmountUnitEnum)AmountUnitEnum.ONE, (BigDecimal)value);
            variableMap.put(typeEnum.getValue(), value);
        }
        try {
            result = FormulaEngine.execExcelFormula((Expr)expr, variableMap);
        }
        catch (Throwable ex) {
            if (ex instanceof ArithmeticException) {
                result = BigDecimal.ZERO;
            }
            if (ex instanceof FormulaException) {
                result = BigDecimal.ZERO;
            }
            throw new KDBizException(ex.getMessage());
        }
        if (CollectionUtils.isNotEmpty(reportData)) {
            List idList = reportData.stream().map(item -> {
                if (Objects.nonNull(item) && Objects.nonNull(item.getId())) {
                    return item.getId().toString();
                }
                return "";
            }).collect(Collectors.toList());
            logger.info("ReportRuleCheckService.ruleCheck \u5f53\u524dreportDataListsId: {}", (Object)String.join((CharSequence)",", idList));
        }
        logger.info("ReportRuleCheckService.ruleCheck \u8868\u8fbe\u5f0f\u89e3\u6790\u7ed3\u679c:{}, \u5f53\u524d\u8868\u8fbe\u5f0f:{}", result, (Object)valueFormulaValue);
        return Optional.ofNullable(result).map(o -> new BigDecimal(o.toString())).orElse(BigDecimal.ZERO);
    }

    private static BigDecimal getReportDataValueV2(List<ReportData> reportData, ReportValueFormulaTypeEnum typeEnum, BigDecimal value) {
        switch (typeEnum) {
            case REPORT_QUOTA: 
            case ORIGIN_QUOTA: 
            case EXECUTED_QUOTA: 
            case PLAN_TEM_QUOTA: 
            case PRE_QUOTA: {
                value = reportData.stream().map(ReportData::getValue).filter(Objects::nonNull).map(item -> (BigDecimal)item).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                break;
            }
            case PLAN_QUOTA: {
                value = reportData.stream().map(item -> {
                    if (item instanceof ReportChangeData) {
                        return ((ReportChangeData)item).getCurrentAdjustAmt();
                    }
                    return item.getValue();
                }).filter(Objects::nonNull).map(item -> (BigDecimal)item).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                break;
            }
        }
        return value;
    }

    private BigDecimal getReportDataValueV1(List<ReportData> reportData, ReportValueFormulaTypeEnum typeEnum, BigDecimal value) {
        switch (typeEnum) {
            case PRE_QUOTA: {
                value = reportData.stream().map(ReportData::getLockAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                break;
            }
            case PLAN_QUOTA: {
                Map<EvalDimensionCombination, ReportData> reportDataGroup = reportData.stream().collect(Collectors.toMap(EvalDimensionCombination::getEvalDimensionCombinationByReportData, v -> v, (a, b) -> {
                    if (a instanceof ReportChangeData) {
                        return a;
                    }
                    if (b instanceof ReportChangeData) {
                        return b;
                    }
                    return a;
                }));
                value = reportDataGroup.values().stream().map(item -> {
                    if (item instanceof ReportChangeData) {
                        return ((ReportChangeData)item).getAdjustedPlanAmt();
                    }
                    return item.getPlanAmt();
                }).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                break;
            }
            case REPORT_QUOTA: {
                value = reportData.stream().map(ReportData::getReportPlanAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                break;
            }
            case ORIGIN_QUOTA: {
                value = reportData.stream().map(ReportData::getOriginalPlanAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                break;
            }
            case EXECUTED_QUOTA: {
                value = reportData.stream().map(ReportData::getActAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                break;
            }
            case PLAN_TEM_QUOTA: {
                value = reportData.stream().map(ReportData::getPlanReferenceAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                break;
            }
        }
        return value;
    }

    private Pair<Boolean, List<ReportVerifyRuleDimension>> getAndConfirmDimensionRange(ReportRuleCheckDTO checkDTO, ReportVerifyRule verifyRule) {
        ArrayList<String> fixedDimension = new ArrayList<String>(8);
        fixedDimension.add(DimensionType.ORG.getNumber());
        fixedDimension.add(DimensionType.PERIOD.getNumber());
        fixedDimension.add(DimensionType.CURRENCY.getNumber());
        long count = verifyRule.getDimensionList().stream().filter(item -> !fixedDimension.contains(item.getDimsionEnums().getNumber())).count();
        List<ReportVerifyRuleDimension> leftDimension = verifyRule.getCheckDimensionValue();
        List<ReportVerifyRuleDimension> rightDimension = verifyRule.getCheckedDimensionValue();
        boolean exist = count == 0L;
        List dimensionList = verifyRule.getDimensionList().stream().filter(item -> DimensionType.ORG != item.getDimsionEnums()).collect(Collectors.toList());
        this.setOrgDimension(verifyRule, checkDTO, leftDimension, rightDimension);
        leftDimension.addAll(dimensionList);
        rightDimension.addAll(dimensionList);
        return Pair.of((Object)exist, leftDimension);
    }

    private void setOrgDimension(ReportVerifyRule verifyRule, ReportRuleCheckDTO checkDTO, List<ReportVerifyRuleDimension> leftDimension, List<ReportVerifyRuleDimension> rightDimension) {
        ReportDataSource dataSource = checkDTO.getDataSource();
        ReportTemplate template = dataSource.getTemplate();
        List orgList = verifyRule.getDimensionList().stream().filter(item -> DimensionType.ORG == item.getDimsionEnums()).collect(Collectors.toList());
        ReportVerifyRuleDimension orgDimension = (ReportVerifyRuleDimension)orgList.get(0);
        if (dataSource instanceof SumPlanReport) {
            OrgMember reportOrg = ((SumPlanReport)dataSource).getCompanyMemberList().get(0);
            ReportVerifyRuleDimension orgSumDimension = new ReportVerifyRuleDimension();
            orgSumDimension.setDimensionId(orgDimension.getDimensionId());
            orgSumDimension.setDimensionName(orgDimension.getDimensionName());
            ArrayList<ReportVerifyRuleDimensionMember> memberParams = new ArrayList<ReportVerifyRuleDimensionMember>(8);
            ReportVerifyRuleDimensionMember member = new ReportVerifyRuleDimensionMember();
            member.setDimensionMemberId(reportOrg.getId());
            member.setDimensionMemberName(reportOrg.getName());
            member.setDimensionId(orgDimension.getDimensionId());
            memberParams.add(member);
            orgSumDimension.setMemberParams(memberParams);
            orgSumDimension.setDimsionEnums(DimensionType.ORG);
            leftDimension.add(orgSumDimension);
            rightDimension.add(orgSumDimension);
            return;
        }
        if (CollectionUtils.isEmpty(orgDimension.getMemberParams())) {
            return;
        }
        List orgTemplateDim = template.getAllTemplateDim().stream().filter(item -> item.getDimensionId().equals(orgDimension.getDimensionId())).collect(Collectors.toList());
        DimLocation location = ((TemplateDim)orgTemplateDim.get(0)).getLocation();
        if (location == DimLocation.PAGE) {
            return;
        }
        leftDimension.add(orgDimension);
        rightDimension.add(orgDimension);
    }

    private List<ReportDataSource> getReports(ReportRuleCheckDTO checkDTO, List<Long> reportPeriodIds) {
        if (checkDTO.getDataSource() instanceof PlanChangeReport) {
            return Lists.newArrayList((Object[])new ReportDataSource[]{checkDTO.getDataSource()});
        }
        List<ReportDataSource> reports = this.getReports(checkDTO.getOrgId(), checkDTO.getDataSource(), reportPeriodIds, null);
        return this.replaceCacheReport(checkDTO.getDataSource(), reports);
    }

    private List<ReportDataSource> getReports(Long orgId, ReportDataSource dataSource, List<Long> reportPeriodIds, ReportStatus status) {
        ReportQDTO reportQuery = new ReportQDTO();
        reportQuery.setBodySysId(dataSource.getTemplate().getSystemId());
        reportQuery.setReportOrgId(orgId);
        reportQuery.setReportPeriodIdList(reportPeriodIds);
        reportQuery.setReportStatus(status);
        ReportPlanType reportPlan = null;
        ReportDataSourceType type = ReportDataSourceType.REPORT;
        if (dataSource instanceof SumPlanReport) {
            type = ReportDataSourceType.REPORT_SUM;
        }
        switch (Objects.requireNonNull(type)) {
            case REPORT: {
                reportPlan = ReportPlanType.REPORTPLAN;
                break;
            }
            case REPORT_SUM: {
                reportPlan = ReportPlanType.SUMPLAN;
                break;
            }
        }
        reportQuery.setReportPlanType(reportPlan);
        reportQuery.setSplit(true);
        List<Report> reports = this.reportRepository.loadReport(reportQuery);
        return new ArrayList<ReportDataSource>(reports);
    }

    private List<ReportDataSource> replaceCacheReport(ReportDataSource dataSource, List<ReportDataSource> reports) {
        ArrayList<ReportDataSource> result = new ArrayList<ReportDataSource>();
        if (CollectionUtils.isNotEmpty(reports)) {
            result.add(dataSource);
            Long reportId = dataSource instanceof Report ? ((Report)dataSource).getId() : (dataSource instanceof PlanChangeReport ? ((PlanChangeReport)dataSource).getReportId() : Long.valueOf(0L));
            reports = reports.stream().filter(item -> item.getTemplate().isMainTable()).map(item -> (Report)item).filter(item -> !Objects.equals(item.getId(), reportId)).collect(Collectors.toList());
            result.addAll(reports);
        }
        return result;
    }

    private List<Long> getCheckedReportPeriod(Long reportPeriodId, ReportVerifyRule verifyRule, FundPlanSystem system) {
        if (!this.checkBetweenTable(verifyRule)) {
            return null;
        }
        ArrayList<PeriodMember> result = new ArrayList<PeriodMember>(16);
        Optional<Dimension> dimensionOptional = system.getDimList().stream().filter(Objects::nonNull).filter(item -> DimensionType.PERIOD == item.getDimType()).findFirst();
        if (!dimensionOptional.isPresent()) {
            return null;
        }
        Dimension periodDimension = dimensionOptional.get();
        PeriodMember reportPeriod = periodDimension.getDimMemberByDimId(PeriodMember.class, reportPeriodId);
        Integer duringDeviation = verifyRule.getDuringDeviation();
        PeriodType reportType = verifyRule.getCheckReportPeriodType().getPeriodType();
        PeriodType periodType = verifyRule.getCheckedReportPeriodType().getPeriodType();
        List<PeriodMember> allSystemPeriodChild = this.filterPeriod(periodDimension, verifyRule.getCheckedReportPeriodType());
        int interval = duringDeviation;
        block0 : switch (periodType) {
            case DAY: {
                for (PeriodMember dimMember : allSystemPeriodChild) {
                    Date lastDay = DateUtils.getNextDay((Date)reportPeriod.getStartDate(), (int)interval);
                    if (!DateUtils.isSameYear((Date)dimMember.getStartDate(), (Date)lastDay) || !DateUtils.isSameDay((Date)dimMember.getStartDate(), (Date)lastDay)) continue;
                    if (!dimMember.isEnable()) {
                        --interval;
                        continue;
                    }
                    result.add(dimMember);
                    break block0;
                }
                break;
            }
            case TEN_DAY: {
                Date lastTenDayPeriod = ReportRuleCheckService.getLastTenDayPeriod(reportPeriod.getStartDate());
                for (PeriodMember dimMember : allSystemPeriodChild) {
                    if (!DateUtils.isSameYear((Date)dimMember.getStartDate(), (Date)lastTenDayPeriod) || !DateUtils.isSameDay((Date)dimMember.getStartDate(), (Date)lastTenDayPeriod)) continue;
                    if (!dimMember.isEnable()) {
                        if (dimMember.getPeriodType() != reportType) break block0;
                        lastTenDayPeriod = ReportRuleCheckService.getLastTenDayPeriod(lastTenDayPeriod);
                        continue;
                    }
                    result.add(dimMember);
                    break block0;
                }
                break;
            }
            case MONTH_WEEK: {
                for (PeriodMember dimMember : allSystemPeriodChild) {
                    boolean inRange;
                    Date lastDay = DateUtils.getNextWeek((Date)reportPeriod.getEndDate(), (int)interval);
                    if (!DateUtils.isSameYear((Date)dimMember.getStartDate(), (Date)lastDay) || !DateUtils.isSameMonth((Date)lastDay, (Date)dimMember.getStartDate()) || !(inRange = lastDay.compareTo(dimMember.getStartDate()) >= 0 && lastDay.compareTo(dimMember.getEndDate()) <= 0)) continue;
                    if (!dimMember.isEnable()) {
                        if (dimMember.getPeriodType() != reportType) break block0;
                        --interval;
                        continue;
                    }
                    result.add(dimMember);
                    break block0;
                }
                break;
            }
            case MONTH: {
                for (PeriodMember dimMember : allSystemPeriodChild) {
                    Date lastDay = DateUtils.getNextMonth((Date)reportPeriod.getStartDate(), (int)interval);
                    if (!DateUtils.isSameYear((Date)dimMember.getStartDate(), (Date)lastDay) || !DateUtils.isSameMonth((Date)dimMember.getStartDate(), (Date)lastDay)) continue;
                    if (!dimMember.isEnable()) {
                        if (dimMember.getPeriodType() != reportType) break block0;
                        --interval;
                        continue;
                    }
                    result.add(dimMember);
                    break block0;
                }
                break;
            }
            case YEAR_WEEK: {
                break;
            }
            case QUARTER: {
                for (PeriodMember dimMember : allSystemPeriodChild) {
                    Date lastSeason = ReportRuleCheckService.getStartQuarter(reportPeriod.getStartDate(), interval);
                    if (!DateUtils.isSameYear((Date)dimMember.getStartDate(), (Date)lastSeason) || !DateUtils.isSameMonth((Date)dimMember.getStartDate(), (Date)lastSeason)) continue;
                    if (!dimMember.isEnable()) {
                        if (dimMember.getPeriodType() != reportType) break block0;
                        --interval;
                        continue;
                    }
                    result.add(dimMember);
                    break block0;
                }
                break;
            }
            case HALF_YEAR: {
                for (PeriodMember dimMember : allSystemPeriodChild) {
                    Date lastSeason = ReportRuleCheckService.getStartHalfYear(reportPeriod.getStartDate(), interval);
                    if (!DateUtils.isSameYear((Date)dimMember.getStartDate(), (Date)lastSeason) || !DateUtils.isSameMonth((Date)dimMember.getStartDate(), (Date)lastSeason)) continue;
                    if (!dimMember.isEnable()) {
                        if (dimMember.getPeriodType() != reportType) break block0;
                        --interval;
                        continue;
                    }
                    result.add(dimMember);
                    break block0;
                }
                break;
            }
            case YEAR: {
                for (PeriodMember dimMember : allSystemPeriodChild) {
                    Date lastSeason = this.getStartYear(reportPeriod.getStartDate(), interval);
                    if (!DateUtils.isSameYear((Date)dimMember.getStartDate(), (Date)lastSeason) || !DateUtils.isSameMonth((Date)dimMember.getStartDate(), (Date)lastSeason)) continue;
                    if (!dimMember.isEnable()) {
                        if (dimMember.getPeriodType() != reportType) break block0;
                        --interval;
                        continue;
                    }
                    result.add(dimMember);
                    break block0;
                }
                break;
            }
        }
        if (CollectionUtils.isEmpty(result)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u88ab\u6821\u9a8c\u62a5\u8868\u671f\u95f4\u786e\u8ba4\u8303\u56f4\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u770b", (String)"ReportRuleCheckService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        ArrayList<Long> periodIds = new ArrayList<Long>();
        Optional.of(result).ifPresent(item -> periodIds.addAll(item.stream().map(DimMember::getId).collect(Collectors.toList())));
        return periodIds;
    }

    private List<PeriodMember> filterPeriod(Dimension dimension, ReportPeriodType reportPeriodType) {
        PeriodType periodType = reportPeriodType.getPeriodType();
        PeriodType detailPeriodType = reportPeriodType.getDetailPeriodType();
        List<DimMember> allDimMemberList = dimension.getAllDimMemberList();
        List<PeriodMember> allSystemPeriodChild = allDimMemberList.stream().map(item -> (PeriodMember)item).filter(item -> periodType == item.getPeriodType()).collect(Collectors.toList());
        DynamicObject[] reportPeriodObjects = TmcDataServiceHelper.load((Object[])allSystemPeriodChild.stream().map(PeriodMember::getPeriodTypeId).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_orgreporttype"));
        Map reportTypeMap = Arrays.stream(reportPeriodObjects).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        allSystemPeriodChild = allSystemPeriodChild.stream().filter(item -> {
            DynamicObject dynamicObject = (DynamicObject)reportTypeMap.get(item.getPeriodTypeId());
            if (Objects.isNull(dynamicObject)) {
                return false;
            }
            PeriodType itemPeriodType = PeriodType.getByNumber(dynamicObject.getString("orgreportcycle"));
            if (Objects.isNull((Object)itemPeriodType)) {
                return false;
            }
            if (Objects.isNull((Object)detailPeriodType)) {
                return periodType == itemPeriodType;
            }
            PeriodType itemDetailPeriodType = PeriodType.getByNumber(dynamicObject.getString("orgreporttype"));
            if (Objects.isNull((Object)itemDetailPeriodType)) {
                return false;
            }
            return periodType == itemPeriodType && detailPeriodType == itemDetailPeriodType;
        }).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        return allSystemPeriodChild;
    }

    private boolean checkBetweenTable(ReportVerifyRule verifyRule) {
        return ReportVerifyCheckTypeEnum.BETWEEN_TABLE == verifyRule.getCheckType();
    }

    private ReportVerifyRuleDimension getOrgDimension(ReportVerifyRule verifyRule) {
        ReportVerifyRuleDimension dimension = null;
        if (CollectionUtils.isNotEmpty(verifyRule.getDimensionList())) {
            Optional<ReportVerifyRuleDimension> first = verifyRule.getDimensionList().stream().filter(item -> DimsionEnums.ORG.getNumber().equals(item.getDimsionEnums().getNumber())).findFirst();
            if (!first.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u62a5\u89c4\u5219\u4e2d\u672a\u8bbe\u7f6e\u7f16\u62a5\u4e3b\u4f53\uff0c\u8bf7\u67e5\u770b", (String)"ReportRuleCheckService_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            dimension = first.get();
        }
        return dimension;
    }

    private static Set<List<ReportVerifyRuleDimensionMember>> circulate(List<List<ReportVerifyRuleDimensionMember>> dimValue) {
        int total = 1;
        for (List<ReportVerifyRuleDimensionMember> list : dimValue) {
            total *= list.size();
        }
        HashMap result = new HashMap();
        int now = 1;
        for (List<ReportVerifyRuleDimensionMember> list : dimValue) {
            int index = 0;
            int currentSize = list.size();
            int itemLoopNum = total / (now *= list.size());
            int loopPerItem = total / (itemLoopNum * currentSize);
            int myIndex = 0;
            for (ReportVerifyRuleDimensionMember ignored : list) {
                for (int i = 0; i < loopPerItem; ++i) {
                    if (myIndex == list.size()) {
                        myIndex = 0;
                    }
                    for (int j = 0; j < itemLoopNum; ++j) {
                        if (!result.containsKey(index)) {
                            ArrayList<ReportVerifyRuleDimensionMember> row = new ArrayList<ReportVerifyRuleDimensionMember>();
                            row.add(list.get(myIndex));
                            result.put(index, row);
                        } else {
                            List dimensionList = (List)result.get(index);
                            dimensionList.add(list.get(myIndex));
                        }
                        ++index;
                    }
                    ++myIndex;
                }
            }
        }
        HashSet resultSet = new HashSet(result.values());
        return resultSet.stream().filter(item -> {
            boolean sameDimension = item.stream().map(ReportVerifyRuleDimensionMember::getDimensionId).distinct().count() < (long)item.size();
            return !sameDimension;
        }).collect(Collectors.toSet());
    }

    public static Date getLastTenDayPeriod(Date inDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(inDate);
        int day = cal.get(5);
        if (day < 11) {
            cal.set(2, cal.get(2) - 1);
            cal.set(5, 21);
            return cal.getTime();
        }
        if (day < 21) {
            cal.set(5, 1);
            return cal.getTime();
        }
        cal.set(5, 11);
        return cal.getTime();
    }

    private static Date getStartYearMonth(Date date, int interval, int months) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(date);
        startCalendar.set(2, (startCalendar.get(2) / months - Math.abs(interval)) * months);
        startCalendar.set(5, 1);
        startCalendar.set(11, 0);
        startCalendar.set(12, 0);
        startCalendar.set(13, 0);
        startCalendar.set(14, 0);
        return startCalendar.getTime();
    }

    private static Date getStartQuarter(Date date, int interval) {
        return ReportRuleCheckService.getStartYearMonth(date, interval, 3);
    }

    private static Date getStartHalfYear(Date date, int interval) {
        return ReportRuleCheckService.getStartYearMonth(date, interval, 6);
    }

    private Date getStartYear(Date date, int interval) {
        return ReportRuleCheckService.getStartYearMonth(date, interval, 12);
    }
}

