/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.smart.getval.service.mapping.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.tmc.fpm.business.domain.enums.MatchPropType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.domain.model.dimension.DimMemberMapping;
import kd.tmc.fpm.business.domain.model.dimension.MappingInfo;
import kd.tmc.fpm.business.provider.DimMappingBaseDataProvider;
import kd.tmc.fpm.business.service.smart.getval.service.mapping.IMappingStrategy;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.helper.StringHelper;

public class DimMemberMappingStrategy
implements IMappingStrategy {
    private MatchMapping matchMapping;
    private BillBizInfo billBizInfo;
    private boolean enableOptionalMember;
    private List<Long> optionalMemberScope;
    private MappingInfo matchedMappingInfo;

    public DimMemberMappingStrategy(MatchMapping matchMapping, BillBizInfo billBizInfo) {
        this(matchMapping, billBizInfo, false, new ArrayList<Long>(0));
    }

    public DimMemberMappingStrategy(MatchMapping matchMapping, BillBizInfo billBizInfo, boolean enableOptionalMember, List<Long> optionalMemberScope) {
        this.matchMapping = matchMapping;
        this.billBizInfo = billBizInfo;
        this.enableOptionalMember = enableOptionalMember;
        this.optionalMemberScope = optionalMemberScope;
    }

    @Override
    public void process() {
        if (Objects.isNull(this.matchMapping.getDimMapping())) {
            return;
        }
        ArrayList<DimMemberMapping> dimMemberMappingList = new ArrayList<DimMemberMapping>(1);
        dimMemberMappingList.add(this.matchMapping.getDimMapping());
        DimMappingBaseDataProvider dimMappingBaseDataProvider = new DimMappingBaseDataProvider(dimMemberMappingList);
        Map billBizPropMap = this.billBizInfo.getBizProps().stream().collect(HashMap::new, (m, v) -> m.put(v.getBizProp(), v.getValue()), HashMap::putAll);
        this.dimMemberMapping(this.matchMapping, billBizPropMap, dimMappingBaseDataProvider);
    }

    public MappingInfo getResult() {
        return this.matchedMappingInfo;
    }

    private void dimMemberMapping(MatchMapping matchMapping, Map<String, Object> bizPropsMap, DimMappingBaseDataProvider dimMappingBaseDataProvider) {
        DimMemberMapping dimMapping = matchMapping.getDimMapping();
        if (Objects.isNull(dimMapping)) {
            return;
        }
        String bizProp = matchMapping.getBizProp();
        String assistBizProp = matchMapping.getAssistBizProp();
        Object bizPropValue = bizPropsMap.get(bizProp);
        Object assistBizValue = bizPropsMap.get(assistBizProp);
        MatchPropType matchPropType = CommonUtils.getOrDefault(matchMapping.getMatchPropType(), MatchPropType.NAME);
        List<MappingInfo> mappings = dimMapping.getMappings();
        for (MappingInfo mappingInfo : mappings) {
            if (this.enableOptionalMember && !this.optionalMemberScope.contains(mappingInfo.getMemberId())) continue;
            Long assistId = mappingInfo.getAssistId();
            Long mainId = mappingInfo.getMainId();
            if (dimMapping.isAssistEntity()) {
                String assistName = dimMappingBaseDataProvider.getBaseData(dimMapping.getAssistEntityType(), assistId).getString(matchPropType.getNumber().toLowerCase());
                if (!Objects.equals(StringHelper.trimIfString((Object)assistBizValue), assistName)) continue;
            }
            String mainName = dimMappingBaseDataProvider.getBaseData(dimMapping.getMainEntityType(), mainId).getString(matchPropType.getNumber().toLowerCase());
            if (!Objects.equals(StringHelper.trimIfString((Object)bizPropValue), mainName)) continue;
            this.matchedMappingInfo = mappingInfo;
            break;
        }
    }
}

