/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.sumreport.model;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.SunReportSumStatus;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.generate.bean.DimensionInfo;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.service.sumreport.model.ReportDataSumModel;

public class ReportDataSumHandlerModel
implements Serializable {
    private DimensionIndexTree indexTree;
    private FundPlanSystem system;
    private List<Long> sumDimMemberList;
    private List<DimensionInfo> indexTreeDimScope;
    private List<ReportData> orgDataList;
    private DimensionType dimensionType;
    private Long reportId;
    private Report targetReport;
    private SunReportSumStatus sumStatus;
    private List<TemplateMetricType> typeList;
    private AmountUnit amountUnit;

    public ReportDataSumHandlerModel() {
    }

    public ReportDataSumHandlerModel(ReportDataSumModel sumModel) {
        this.targetReport = sumModel.getTargetReport();
        this.sumStatus = sumModel.getSumStatus();
        this.typeList = sumModel.getTypeList();
        this.reportId = Objects.nonNull(sumModel.getTargetReport()) ? sumModel.getTargetReport().getId() : null;
        this.indexTree = sumModel.getIndexTree();
        this.indexTreeDimScope = sumModel.getIndexTreeDimScope();
        this.sumDimMemberList = sumModel.getSumDimMemberList();
        this.system = sumModel.getSystem();
        this.amountUnit = sumModel.getAmountUnit();
    }

    public DimensionIndexTree getIndexTree() {
        return this.indexTree;
    }

    public void setIndexTree(DimensionIndexTree indexTree) {
        this.indexTree = indexTree;
    }

    public FundPlanSystem getSystem() {
        return this.system;
    }

    public void setSystem(FundPlanSystem system) {
        this.system = system;
    }

    public List<Long> getSumDimMemberList() {
        return this.sumDimMemberList;
    }

    public void setSumDimMemberList(List<Long> sumDimMemberList) {
        this.sumDimMemberList = sumDimMemberList;
    }

    public List<DimensionInfo> getIndexTreeDimScope() {
        return this.indexTreeDimScope;
    }

    public void setIndexTreeDimScope(List<DimensionInfo> indexTreeDimScope) {
        this.indexTreeDimScope = indexTreeDimScope;
    }

    public List<ReportData> getOrgDataList() {
        return this.orgDataList;
    }

    public void setOrgDataList(List<ReportData> orgDataList) {
        this.orgDataList = orgDataList;
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    public void setDimensionType(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    public Long getReportId() {
        return this.reportId;
    }

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    public SunReportSumStatus getSumStatus() {
        return this.sumStatus;
    }

    public void setSumStatus(SunReportSumStatus sumStatus) {
        this.sumStatus = sumStatus;
    }

    public List<TemplateMetricType> getTypeList() {
        return this.typeList;
    }

    public void setTypeList(List<TemplateMetricType> typeList) {
        this.typeList = typeList;
    }

    public Report getTargetReport() {
        return this.targetReport;
    }

    public void setTargetReport(Report targetReport) {
        this.targetReport = targetReport;
    }

    public static ReportDataSumHandlerModel getInstance(ReportDataSumModel sumModel) {
        return new ReportDataSumHandlerModel(sumModel);
    }

    public AmountUnit getAmountUnit() {
        return this.amountUnit;
    }

    public void setAmountUnit(AmountUnit amountUnit) {
        this.amountUnit = amountUnit;
    }
}

