/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.service.sumreport.strategy;

import com.google.common.collect.Lists;
import java.util.List;
import kd.tmc.fpm.business.domain.enums.SunReportSumStatus;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.report.Report;

public class ReportAggregatePrepareBuilder {
    private Long targetReportId;
    private Report targetReport;
    private List<Report> waitMergeReport;
    private FundPlanSystem system;
    private SunReportSumStatus sumStatus;
    private List<MetricMember> needSumMetrics;

    public Long getTargetReportId() {
        return this.targetReportId;
    }

    public void setTargetReportId(Long targetReportId) {
        this.targetReportId = targetReportId;
    }

    public SunReportSumStatus getSumStatus() {
        return this.sumStatus;
    }

    public void setSumStatus(SunReportSumStatus sumStatus) {
        this.sumStatus = sumStatus;
    }

    public FundPlanSystem getSystem() {
        return this.system;
    }

    public void setSystem(FundPlanSystem system) {
        this.system = system;
    }

    public List<MetricMember> getNeedSumMetrics() {
        return this.needSumMetrics;
    }

    public void setNeedSumMetrics(List<MetricMember> needSumMetrics) {
        this.needSumMetrics = needSumMetrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Report> getWaitMergeReport() {
        return this.waitMergeReport;
    }

    public void setWaitMergeReport(List<Report> waitMergeReport) {
        this.waitMergeReport = waitMergeReport;
    }

    public Report getTargetReport() {
        return this.targetReport;
    }

    public void setTargetReport(Report targetReport) {
        this.targetReport = targetReport;
    }

    public static class Builder {
        private ReportAggregatePrepareBuilder data = new ReportAggregatePrepareBuilder();

        Builder() {
        }

        public Builder setReportId(Long targetReportId) {
            this.data.setTargetReportId(targetReportId);
            return this;
        }

        public Builder setReport(Report targetReport) {
            this.data.setTargetReport(targetReport);
            return this;
        }

        public Builder setMergeReport(Report mergeReport) {
            this.data.setWaitMergeReport(Lists.newArrayList((Object[])new Report[]{mergeReport}));
            return this;
        }

        public Builder setMergeReport(List<Report> mergeReports) {
            this.data.setWaitMergeReport(mergeReports);
            return this;
        }

        public Builder setSumStatus(SunReportSumStatus sumStatus) {
            this.data.setSumStatus(sumStatus);
            return this;
        }

        public Builder setSystem(FundPlanSystem system) {
            this.data.setSystem(system);
            return this;
        }

        public Builder setScopeMetrics(List<MetricMember> needSumMetrics) {
            this.data.setNeedSumMetrics(needSumMetrics);
            return this;
        }

        public ReportAggregatePrepareBuilder build() {
            return this.data;
        }
    }
}

