/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.command.chain;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.spread.command.AbsSpreadCommand;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import kd.tmc.fpm.spread.widget.CellArea;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.AreasStyle;

public class DrawCellStyleCmdChain
extends AbsSpreadCommand {
    private List<Cell> cells;

    public DrawCellStyleCmdChain(SpreadCommandInvoker invoker, List<Cell> cells) {
        super(invoker);
        this.cells = cells;
    }

    @Override
    protected void command(SpreadCommandInvoker invoker) {
        if (this.cells.isEmpty()) {
            return;
        }
        List filterCells = this.cells.stream().filter(Objects::nonNull).filter(o -> Objects.nonNull(o.getStyleInfo())).collect(Collectors.toList());
        List areasStyles = filterCells.stream().filter(Objects::nonNull).map(o -> {
            AreasStyle as = new AreasStyle();
            CellArea ca = new CellArea(ExcelUtils.converCoord((int)o.getCol(), (int)o.getRow(), (int)(o.getRowSpan() - 1), (int)(o.getColSpan() - 1)));
            as.setRange(Collections.singletonList(ca));
            as.setStyle(o.getStyleInfo());
            return as;
        }).collect(Collectors.toList());
        if (!areasStyles.isEmpty()) {
            invoker.setCellStyle(areasStyles);
        }
    }
}

