/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.command.chain;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.business.spread.command.AbsSpreadCommand;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;

public class MultiTypeCellUpdateValCmdChain
extends AbsSpreadCommand {
    private List<Cell> cells;

    public MultiTypeCellUpdateValCmdChain(SpreadCommandInvoker invoker, List<Cell> cells) {
        super(invoker);
        this.cells = cells;
    }

    @Override
    protected void command(SpreadCommandInvoker invoker) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(MultiTypeCellUpdateValCmdChain.class.getSimpleName());){
            if (CollectionUtils.isEmpty(this.cells)) {
                return;
            }
            span.addTag(String.format("Send update cell command:%d", this.cells.size()));
            invoker.updateCellValue2(this.cells);
            Map<CellTypeEnum, List<Cell>> cellTypeEnumListMap = this.cells.stream().filter(Objects::nonNull).filter(o -> o.getCellType() != null).collect(Collectors.groupingBy(Cell::getCellType));
            if (cellTypeEnumListMap.isEmpty()) {
                return;
            }
            if (cellTypeEnumListMap.containsKey(CellTypeEnum.DOWNBOXWIDGET) || cellTypeEnumListMap.containsKey(CellTypeEnum.MUTITYPEWIDGET)) {
                List<Cell> mutiCells;
                ArrayList<Cell> tempCell = new ArrayList<Cell>(this.cells.size());
                List<Cell> downBoxCells = cellTypeEnumListMap.get(CellTypeEnum.DOWNBOXWIDGET);
                if (!CollectionUtils.isEmpty(downBoxCells)) {
                    tempCell.addAll(downBoxCells);
                }
                if (!CollectionUtils.isEmpty(mutiCells = cellTypeEnumListMap.get(CellTypeEnum.MUTITYPEWIDGET))) {
                    tempCell.addAll(mutiCells);
                }
                span.addTag("Set cell to F7 type");
                if (!CollectionUtils.isEmpty(tempCell)) {
                    invoker.setFListCells(tempCell, true, true);
                }
            }
            if (cellTypeEnumListMap.containsKey(CellTypeEnum.F7WIDGET)) {
                List<Cell> f7Cells = cellTypeEnumListMap.get(CellTypeEnum.F7WIDGET);
                span.addTag("Set cell to F7 type");
                if (!CollectionUtils.isEmpty(f7Cells)) {
                    invoker.setFListCells(f7Cells, true, false);
                }
            }
        }
    }
}

