/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.command.chain;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.spread.command.AbsSpreadCommand;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import kd.tmc.fpm.spread.widget.CellArea;
import kd.tmc.fpm.spread.widget.core.Cell;

public class SetCellSpanCmdChain
extends AbsSpreadCommand {
    private List<Cell> cells;

    public SetCellSpanCmdChain(SpreadCommandInvoker invoker, List<Cell> cells) {
        super(invoker);
        this.cells = cells;
    }

    @Override
    protected void command(SpreadCommandInvoker invoker) {
        if (this.cells.isEmpty()) {
            return;
        }
        List spanCells = this.cells.stream().filter(Objects::nonNull).filter(o -> o.getColSpan() != 0 || o.getRowSpan() != 0).collect(Collectors.toList());
        ArrayList<CellArea> spanCellAreas = new ArrayList<CellArea>(spanCells.size());
        for (Cell spanCell : spanCells) {
            String area = ExcelUtils.converCoord((int)spanCell.getCol(), (int)spanCell.getRow(), (int)(spanCell.getRowSpan() - 1), (int)(spanCell.getColSpan() - 1));
            spanCellAreas.add(new CellArea(area));
        }
        invoker.setSpan(spanCellAreas);
    }
}

