/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.command.chain;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.spread.command.AbsSpreadCommand;
import kd.tmc.fpm.business.spread.command.vo.StatusBarAreaVO;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.command.SpreadProperties;

public class ShowStatusBarInfoCmdChain
extends AbsSpreadCommand {
    private List<StatusBarAreaVO> statusBarAreaLst;

    public ShowStatusBarInfoCmdChain(SpreadCommandInvoker invoker, List<StatusBarAreaVO> statusBarAreaLst) {
        super(invoker);
        this.statusBarAreaLst = statusBarAreaLst;
    }

    @Override
    protected void command(SpreadCommandInvoker invoker) {
        List<Map<String, Object>> showStatusBarAreaInfoParams = this.getShowStatusBarAreaInfoParams();
        if (EmptyUtil.isNoEmpty(showStatusBarAreaInfoParams)) {
            invoker.setStatusBarText(showStatusBarAreaInfoParams);
        }
    }

    private List<Map<String, Object>> getShowStatusBarAreaInfoParams() {
        if (this.statusBarAreaLst == null || this.statusBarAreaLst.isEmpty()) {
            return null;
        }
        ArrayList<Map<String, Object>> areaList = new ArrayList<Map<String, Object>>(this.statusBarAreaLst.size());
        for (StatusBarAreaVO statusBarAreaVO : this.statusBarAreaLst) {
            areaList.add(this.generateParam(statusBarAreaVO));
        }
        return areaList;
    }

    private Map<String, Object> generateParam(StatusBarAreaVO statusBarAreaVO) {
        LinkedHashMap<String, Object> area = new LinkedHashMap<String, Object>();
        area.put(SpreadProperties.SetDisplayContentMethod.key.k(), statusBarAreaVO.getK());
        area.put(SpreadProperties.SetDisplayContentMethod.TEXT.k(), statusBarAreaVO.getText());
        LinkedHashMap<String, String> areaStyle = new LinkedHashMap<String, String>();
        areaStyle.put(SpreadProperties.SetDisplayContentMethod.w.k(), statusBarAreaVO.getW());
        areaStyle.put(SpreadProperties.SetDisplayContentMethod.fc.k(), statusBarAreaVO.getFc());
        areaStyle.put(SpreadProperties.SetDisplayContentMethod.gr.k(), statusBarAreaVO.getGr());
        area.put(SpreadProperties.SetDisplayContentMethod.s.k(), areaStyle);
        return area;
    }
}

