/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.command.generator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.spread.command.ISpreadCmdChainGenerator;
import kd.tmc.fpm.business.spread.command.ISpreadCommand;
import kd.tmc.fpm.business.spread.command.chain.CellFormulaCmdChain;
import kd.tmc.fpm.business.spread.command.chain.ClearSheetInfoCmdChain;
import kd.tmc.fpm.business.spread.command.chain.DrawCellStyleCmdChain;
import kd.tmc.fpm.business.spread.command.chain.FrozenSheetRowAndColCmdChain;
import kd.tmc.fpm.business.spread.command.chain.LockSheetCmdChain;
import kd.tmc.fpm.business.spread.command.chain.MultiTypeCellUpdateValCmdChain;
import kd.tmc.fpm.business.spread.command.chain.RowAndColAutoFitCmdChain;
import kd.tmc.fpm.business.spread.command.chain.SetCellSpanCmdChain;
import kd.tmc.fpm.business.spread.command.chain.SetRowOutlineCmdChain;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.common.utils.NumberUtils;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ReportInitializationGenerator
implements ISpreadCmdChainGenerator {
    private static final int AMT_COL_FIXED_WIDTH = 90;
    private List<Integer> maxRows;
    private List<Integer> maxCols;

    public ReportInitializationGenerator(List<Integer> maxRows, List<Integer> maxCols) {
        this.maxCols = maxCols;
        this.maxRows = maxRows;
    }

    @Override
    public ISpreadCommand generatorChain(SpreadCommandInvoker invoker, Book book) {
        ClearSheetInfoCmdChain clearSheetInfoCmdChain = new ClearSheetInfoCmdChain(invoker, this.maxRows, this.maxCols, book);
        Pair<List<Integer>, List<Integer>> pair = this.getAutoFitAndFixedWidthColsPair(book);
        clearSheetInfoCmdChain.setNextCommand(new MultiTypeCellUpdateValCmdChain(invoker, book.getSheet().getCellList())).setNextCommand(new LockSheetCmdChain(invoker, Collections.singletonList("Sheet1"), false)).setNextCommand(new DrawCellStyleCmdChain(invoker, book.getSheet().getCellList())).setNextCommand(new SetCellSpanCmdChain(invoker, book.getSheet().getCellList())).setNextCommand(new CellFormulaCmdChain(invoker, book.getSheet().getCellList(), null)).setNextCommand(new RowAndColAutoFitCmdChain(invoker, book.getSheet().getRows(), (List)pair.getLeft(), 25, 0)).setNextCommand(new RowAndColAutoFitCmdChain(invoker, new ArrayList<Integer>(0), (List)pair.getRight(), 0, 90)).setNextCommand(new FrozenSheetRowAndColCmdChain(invoker, book, "#666666", null)).setNextCommand(new SetRowOutlineCmdChain(invoker, book)).recordTailCommand(clearSheetInfoCmdChain);
        return clearSheetInfoCmdChain;
    }

    private Pair<List<Integer>, List<Integer>> getAutoFitAndFixedWidthColsPair(Book book) {
        Sheet sheet = book.getSheet();
        Set amtColSet = sheet.getCellList().stream().filter(Objects::nonNull).filter(cell -> cell.getCellDimType() == CellDimTypeEnum.DATADIMS).filter(cell -> cell.getCellType() == CellTypeEnum.AMOUNT).filter(cell -> Objects.nonNull(cell.getValue())).map(Cell::getCol).collect(Collectors.toSet());
        LinkedList<Integer> autoFitCols = new LinkedList<Integer>();
        LinkedList<Integer> fixedWidthCols = new LinkedList<Integer>();
        Map<Integer, List<Cell>> colGroupCellMap = sheet.getCellList().stream().filter(Objects::nonNull).collect(Collectors.groupingBy(Cell::getCol));
        for (Map.Entry<Integer, List<Cell>> colGroupEntry : colGroupCellMap.entrySet()) {
            Integer col = colGroupEntry.getKey();
            if (!amtColSet.contains(col)) {
                autoFitCols.add(col);
                continue;
            }
            int colMaxWidth = 0;
            for (Cell cell2 : colGroupEntry.getValue()) {
                colMaxWidth = Math.max(colMaxWidth, this.getAmtColCellWidth(cell2));
            }
            if (colMaxWidth >= 90) {
                autoFitCols.add(col);
                continue;
            }
            fixedWidthCols.add(col);
        }
        return Pair.of(autoFitCols, fixedWidthCols);
    }

    private int getAmtColCellWidth(Cell cell) {
        if (cell == null) {
            return 0;
        }
        Object displayVal = cell.getDisplayValue();
        if (displayVal == null) {
            return 0;
        }
        if (cell.getDisplayValue() instanceof String) {
            return ((String)cell.getDisplayValue()).length();
        }
        if (cell.getDisplayValue() instanceof BigDecimal) {
            boolean isPercentCell = cell.getStyleInfo() != null && StringUtils.isNotEmpty((CharSequence)cell.getStyleInfo().getFm()) && cell.getStyleInfo().getFm().contains("%");
            BigDecimal amt = (BigDecimal)cell.getDisplayValue();
            BigDecimal integerPart = isPercentCell ? NumberUtils.getIntegerPart((BigDecimal)amt.multiply(NumberUtils.ONE_HUNDRED)) : NumberUtils.getIntegerPart((BigDecimal)amt);
            String integerPartStr = integerPart.toPlainString();
            int fractionalPartLength = isPercentCell ? 4 : 3;
            int splitNum = integerPartStr.length() <= 3 ? 0 : integerPartStr.length() / 3;
            return integerPartStr.length() + splitNum + fractionalPartLength;
        }
        return String.valueOf(cell.getDisplayValue()).length();
    }
}

