/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.command.generator;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.spread.command.ISpreadCmdChainGenerator;
import kd.tmc.fpm.business.spread.command.ISpreadCommand;
import kd.tmc.fpm.business.spread.command.chain.DrawCellStyleCmdChain;
import kd.tmc.fpm.business.spread.command.chain.MultiTypeCellUpdateValCmdChain;
import kd.tmc.fpm.business.spread.command.chain.RowAndColAutoFitCmdChain;
import kd.tmc.fpm.spread.command.SpreadCommandInvoker;
import kd.tmc.fpm.spread.widget.core.Cell;

public class UpdateCellInfoGenerator
implements ISpreadCmdChainGenerator {
    private boolean autoRows;
    private boolean autoCols;
    private int rowHit;
    private int colHit;
    private boolean refreshStyle;

    public UpdateCellInfoGenerator(boolean autoRows, boolean autoCols, int rowHit, int colHit, boolean refreshStyle) {
        this.autoRows = autoRows;
        this.autoCols = autoCols;
        this.rowHit = rowHit;
        this.colHit = colHit;
        this.refreshStyle = refreshStyle;
    }

    @Override
    public ISpreadCommand generatorChain(SpreadCommandInvoker invoker, List<Cell> cells) {
        MultiTypeCellUpdateValCmdChain multiTypeCellUpdateValCmdChain = new MultiTypeCellUpdateValCmdChain(invoker, cells);
        List<Integer> cols = cells.stream().filter(Objects::nonNull).map(o -> o.getCol()).collect(Collectors.toList());
        List<Integer> rows = cells.stream().filter(Objects::nonNull).map(o -> o.getRow()).collect(Collectors.toList());
        RowAndColAutoFitCmdChain rowAndColAutoFitCmdChain = new RowAndColAutoFitCmdChain(invoker, this.autoRows ? rows : null, this.autoCols ? cols : null, this.rowHit, this.colHit);
        multiTypeCellUpdateValCmdChain.setNextCommand(rowAndColAutoFitCmdChain);
        if (this.refreshStyle) {
            DrawCellStyleCmdChain drawCellStyleCmdChain = new DrawCellStyleCmdChain(invoker, cells);
            rowAndColAutoFitCmdChain.setNextCommand(drawCellStyleCmdChain).recordTailCommand(multiTypeCellUpdateValCmdChain);
        } else {
            rowAndColAutoFitCmdChain.recordTailCommand(multiTypeCellUpdateValCmdChain);
        }
        return multiTypeCellUpdateValCmdChain;
    }
}

