/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.datamanager;

import java.util.List;
import kd.bos.exception.KDBizException;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.PositionAnalysisReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.service.result.PeriodStartBalance;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManager;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManager;
import kd.tmc.fpm.business.spread.formula.impl.DAGFormulaManager;
import kd.tmc.fpm.business.spread.formula.impl.DAGFormulaManagerV2;
import kd.tmc.fpm.business.spread.formula.impl.ExtDAGFormulaManager;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.business.spread.generator.executor.ReportDataProcessExecutorFactory;

public class ReportDataManagerFactory {
    public static ReportModel createReportModelForTemplatePreview(FundPlanSystem system, Report report) {
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getReportTemplateExecutor(system, report);
        ReportModel reportModel = new ReportModel();
        reportExecutor.executeAction(reportModel);
        return reportModel;
    }

    public static ReportModel createAnalysisPositionReportModel(FundPlanSystem system, Report report, PeriodStartBalance amount) {
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getAnalysisReportPositionExecutor(system, report, amount);
        ReportModel reportModel = reportExecutor.executeAction();
        new ExtDAGFormulaManager(reportModel.getReportCalcModelList().get(0), null);
        return reportModel;
    }

    public static ReportModel createAnalysisMuiReportModel(FundPlanSystem system, Report report) {
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getAnalysisReportMuiExecutor(system, report);
        ReportModel reportModel = reportExecutor.executeAction();
        new DAGFormulaManager(reportModel.getReportCalcModelList().get(0), null);
        return reportModel;
    }

    public static ReportModel createAnalysisSumPlanSubReportModel(FundPlanSystem system, Report report) {
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getAnalysisSumPlanSubReportExecutor(system, report);
        ReportModel reportModel = new ReportModel();
        reportExecutor.executeAction(reportModel);
        new DAGFormulaManager(reportModel.getReportCalcModelList().get(0), null);
        return reportModel;
    }

    public static ReportModel createSynthesisReportModel(FundPlanSystem system, Report report) {
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getSynthesisAnalysisReportExecutor(system, report);
        ReportModel reportModel = reportExecutor.executeAction();
        new DAGFormulaManager(reportModel.getReportCalcModelList().get(0), null);
        return reportModel;
    }

    public static ReportModel createLinkSearchReportModel(FundPlanSystem system, Report report) {
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getReportPlanSearchAnalyseExecutor(system, report);
        ReportModel reportModel = reportExecutor.executeAction();
        new DAGFormulaManager(reportModel.getReportCalcModelList().get(0), null);
        return reportModel;
    }

    public static ReportModel createAnalysPlanExecReportModel(FundPlanSystem system, Report report) {
        ReportModel reportModel = ReportDataProcessExecutorFactory.getAnalysisReportPlanExecExecutor(system, report).executeAction();
        DAGFormulaManagerV2.visitAll(reportModel.getReportCalcModelList().get(0));
        return reportModel;
    }

    public static IReportDataManager createDataManagerForFirstSumPlanReportByPageDim(FundPlanSystem system, SumPlanReport sumPlanReport, List<Long> pageDimS, String pageId) {
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getSumPlanReportExecExecutor(system, sumPlanReport, pageDimS);
        ReportModel reportModel = new ReportModel();
        reportExecutor.executeAction(reportModel);
        ReportDataManager manager = new ReportDataManager(sumPlanReport.getId(), pageId, reportModel, sumPlanReport.getTemplate(), system);
        return manager;
    }

    public static ReportModel createAnalysisReportModel(FundPlanSystem system, Report report) {
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getSumPlanReportExecExecutor(system, report);
        ReportModel reportModel = new ReportModel();
        reportExecutor.executeAction(reportModel);
        new DAGFormulaManager(reportModel.getReportCalcModelList().get(0), null);
        return reportModel;
    }

    public static ReportModel getAnalysisReportModel(AnalysisReport analysisReport, FundPlanSystem fundPlanSystem) {
        switch (analysisReport.getAnalysisReportType()) {
            case MULTI: {
                return ReportDataManagerFactory.createAnalysisMuiReportModel(fundPlanSystem, analysisReport);
            }
            case PLANEXECANALYS: {
                return ReportDataManagerFactory.createAnalysPlanExecReportModel(fundPlanSystem, analysisReport);
            }
            case POSITION: {
                PositionAnalysisReport positionAnalysisReport = (PositionAnalysisReport)analysisReport;
                return ReportDataManagerFactory.createAnalysisPositionReportModel(fundPlanSystem, analysisReport, positionAnalysisReport.getPeriodStartBalance());
            }
            case SYNTHESIS: {
                return ReportDataManagerFactory.createSynthesisReportModel(fundPlanSystem, analysisReport);
            }
            case LINK_SEARCH_ANALYSE: {
                return ReportDataManagerFactory.createLinkSearchReportModel(fundPlanSystem, analysisReport);
            }
        }
        throw new KDBizException("unknown AnalysisReportType:" + (Object)((Object)analysisReport.getAnalysisReportType()));
    }
}

