/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.datamanager.impl;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.mvc.repository.IReportPlanRepositoryV2;
import kd.tmc.fpm.business.mvc.repository.impl.ReportPlanRepositoryV2;
import kd.tmc.fpm.business.provider.ReportBaseDataByCacheCellProvider;
import kd.tmc.fpm.business.spread.datamanager.CellDataUpdateInfo;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.ISpreadDataReceiver;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.formula.IFormulaManagerV2;
import kd.tmc.fpm.business.spread.formula.impl.DAGFormulaManagerV2;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.enums.FlowEnum;
import kd.tmc.fpm.common.utils.NumberUtils;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import org.apache.commons.collections.CollectionUtils;

public class ReportDataManagerV2
implements IReportDataManagerV2 {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(ReportDataManagerV2.class);
    private IReportPlanRepositoryV2 repository;
    private transient Set<Cell> lastUpdatedValList;
    private transient ReportCalcModel currCalcModel;

    public ReportDataManagerV2() {
    }

    public ReportDataManagerV2(IFpmPageCacheService cacheService) {
        this.repository = new ReportPlanRepositoryV2(0L, cacheService);
    }

    public ReportDataManagerV2(Long reportId, IFpmPageCacheService cacheService, ReportCalcModel calcModel, ReportTemplate template, FundPlanSystem system, Boolean visitAllNode) {
        this.repository = new ReportPlanRepositoryV2(reportId, cacheService);
        DAGFormulaManagerV2 dagFormulaManager = new DAGFormulaManagerV2(calcModel, visitAllNode);
        this.repository.saveFormulaManger(dagFormulaManager);
        this.repository.saveReportTemplate(template);
        this.repository.saveSystem(system);
        this.currCalcModel = calcModel;
    }

    @Override
    public void updateCellData(List<CellDataUpdateInfo> updateInfoList, CellDataSource dataSource) {
        if (CollectionUtils.isEmpty(updateInfoList) || dataSource == null) {
            return;
        }
        ReportTemplate template = this.repository.getReportTemplate();
        boolean enableDag = TemplateInfoHelper.isFix(template) || TemplateInfoHelper.enableSum(template);
        this.updateCell(updateInfoList, dataSource, template, enableDag);
    }

    @Override
    public void updateCellDataForceDAG(List<CellDataUpdateInfo> updateInfoList, CellDataSource dataSource) {
        if (CollectionUtils.isEmpty(updateInfoList) || dataSource == null) {
            return;
        }
        ReportTemplate template = this.repository.getReportTemplate();
        this.updateCell(updateInfoList, dataSource, template, true);
    }

    private void updateCell(List<CellDataUpdateInfo> updateInfoList, CellDataSource dataSource, ReportTemplate template, boolean enableDAG) {
        IFormulaManagerV2 formulaManager = this.repository.getFormulaManager();
        CacheCellMeta meta = dataSource.getMeta();
        ReportCalcTree colDimTree = meta.getColDimTree();
        int subjectCol4UpdateFlowCol = ReportHelper.getSubjectColIfNeedUpdateSubjectFlow(template, colDimTree);
        ArrayList<CellDataUpdateInfo> finalUpdateInfoList = new ArrayList<CellDataUpdateInfo>(updateInfoList.size());
        for (CellDataUpdateInfo cellDataUpdateInfo : updateInfoList) {
            int col = cellDataUpdateInfo.getCol();
            int row = cellDataUpdateInfo.getRow();
            Object newVal = cellDataUpdateInfo.getVal();
            CacheCell cell = dataSource.getCell(row, col);
            if (Objects.isNull((Object)cell)) {
                logger.info("row:{},col:{},CacheCell is null", (Object)row, (Object)col);
                continue;
            }
            CellDataUpdateInfo updateInfo = new CellDataUpdateInfo(row, col, newVal, cell.getValue());
            if (Objects.nonNull(cellDataUpdateInfo.getOldVal())) {
                updateInfo.setOldVal(cellDataUpdateInfo.getOldVal());
            }
            finalUpdateInfoList.add(updateInfo);
            CellTypeEnum cellType = cell.getCellType();
            if (cellType == CellTypeEnum.AMOUNT) {
                if (!enableDAG) continue;
                cell.setValue(newVal);
                List<CacheCell> cacheCells = formulaManager.updateData(cell, dataSource);
                if (!CollectionUtils.isNotEmpty(cacheCells)) continue;
                for (CacheCell cacheCell : cacheCells) {
                    if (cacheCell.getRow() == cell.getRow() && cacheCell.getCol() == cell.getCol()) continue;
                    finalUpdateInfoList.add(new CellDataUpdateInfo(cacheCell.getRow(), cacheCell.getCol(), cacheCell.getValue()));
                }
                continue;
            }
            if (CellTypeEnum.MUTITYPEWIDGET != cellType) continue;
            ReportCalcVal currColCalVal = colDimTree.getDimCalcValList(col, 0).get(0);
            Long dimensionId = currColCalVal.getDimensionId();
            List<TemplateDim> list = template.getColDimList();
            TemplateDim templateDim = list.stream().filter(item -> item.getDimensionId().equals(dimensionId)).findFirst().get();
            DetailDimType detailDimType = templateDim.getDetailDimType();
            if (DetailDimType.CONNTERPARTY_TYPE != detailDimType) continue;
            TemplateDim targetDim = list.stream().filter(item -> DetailDimType.COUNTERPARTY_NAME == item.getDetailDimType()).findFirst().get();
            ReportCalcVal targetReportCalVal = colDimTree.getLeafList().stream().map(ReportCalcValTreeNode::getCalcVal).filter(item -> item.getDimensionId().equals(targetDim.getDimensionId())).findFirst().get();
            int targetCol = targetReportCalVal.getCol();
            CacheCell targetCellCalVal = dataSource.getCell(row, targetCol);
            targetCellCalVal.setWidgetValue(newVal);
            finalUpdateInfoList.add(new CellDataUpdateInfo(row, targetCol, null, null));
        }
        for (CellDataUpdateInfo cellDataUpdateInfo : finalUpdateInfoList) {
            this.updateCalcValData(cellDataUpdateInfo, dataSource);
        }
        List<Cell> finalUpdateDataList = this.getNeedUpdateValList();
        ReportBaseDataByCacheCellProvider reportBaseDataProvider = new ReportBaseDataByCacheCellProvider(finalUpdateDataList.stream().map(o -> (CacheCell)((Object)o)).collect(Collectors.toList()));
        for (Cell reportCalcVal : finalUpdateDataList) {
            CacheCell cell = (CacheCell)reportCalcVal;
            Object value = cell.getValue();
            CellTypeEnum cellType = cell.getCellType();
            if (CellTypeEnum.F7WIDGET == cellType) {
                DynamicObject baseData;
                Object widgetValue = cell.getWidgetValue();
                if (widgetValue == null || value == null || (baseData = reportBaseDataProvider.getBaseData(widgetValue.toString(), Long.valueOf(value.toString()))) == null) continue;
                cell.setDisplayValue(baseData.getString("name"));
                this.interactUpdateSubjectFlowColIfNeed(subjectCol4UpdateFlowCol, cell.getRow(), cell.getCol(), dataSource, baseData);
                continue;
            }
            if (CellTypeEnum.MUTITYPEWIDGET != cellType) continue;
            ReportCalcVal currColCalVal = colDimTree.getDimCalcValList(cell.getCol(), 0).get(0);
            Map bdValue = (Map)currColCalVal.getValueType().getValue();
            for (Map.Entry entry : bdValue.entrySet()) {
                if (!((String)entry.getValue()).equals(cell.getValue())) continue;
                cell.setDisplayValue(entry.getKey());
            }
        }
        this.updateTotalRows(dataSource, finalUpdateInfoList);
    }

    @Override
    public void updateTotalRows(List<CellDataUpdateInfo> updateInfoList, CellDataSource dataSource) {
        ArrayList<CellDataUpdateInfo> finalUpdateInfoList = new ArrayList<CellDataUpdateInfo>(updateInfoList.size());
        for (CellDataUpdateInfo cellDataUpdateInfo : updateInfoList) {
            finalUpdateInfoList.add(new CellDataUpdateInfo(cellDataUpdateInfo.getRow(), cellDataUpdateInfo.getCol(), cellDataUpdateInfo.getVal()));
        }
        this.updateTotalRows(dataSource, finalUpdateInfoList);
    }

    @Override
    public void clearTotalRows(CellDataSource dataSource) {
        ReportTemplate reportTemplate = this.getReportTemplate();
        FundPlanSystem fundPlanSystem = this.getSystem();
        boolean hasDetailPeriod = this.hasDetailPeriodByReportTemplate(fundPlanSystem, reportTemplate);
        int totalRow = reportTemplate.getDataStartRow(hasDetailPeriod) + reportTemplate.getTotalRow() - 1;
        List<CacheCell> summaryCells = dataSource.getAllCell().stream().filter(CacheCell::isSummary).filter(item -> item.getCellType() == CellTypeEnum.AMOUNT).filter(item -> NumberUtils.lessEqualsThan((Integer)item.getRow(), (Integer)totalRow)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(summaryCells)) {
            return;
        }
        summaryCells.forEach(item -> {
            item.setValue(BigDecimal.ZERO);
            item.setDisplayValue(BigDecimal.ZERO);
        });
        this.getLastUpdatedValList().addAll(summaryCells);
    }

    private void updateTotalRows(CellDataSource dataSource, List<CellDataUpdateInfo> finalUpdateInfoList) {
        ReportTemplate reportTemplate = this.getReportTemplate();
        Set dimIdSet = reportTemplate.getColDimList().stream().filter(item -> item.isDetailDim() && item.getDetailDimType().isExtraField()).filter(item -> !item.isTotalRow()).map(TemplateDim::getDimensionId).collect(Collectors.toSet());
        List<ReportCalcValTreeNode> leafList = dataSource.getMeta().getColDimTree().getLeafList();
        Set<Integer> extraCustomAmountColumnColSet = leafList.stream().filter(item -> dimIdSet.contains(item.getCalcVal().getDimensionId())).map(ReportCalcValTreeNode::getCol).collect(Collectors.toSet());
        Set<Integer> littleSummaryColSet = leafList.stream().filter(ReportCalcValTreeNode::isLittleSummary).map(ReportCalcValTreeNode::getCol).collect(Collectors.toSet());
        int totalRow = reportTemplate.getTotalRow();
        if (totalRow == 0) {
            return;
        }
        Set<Integer> unDataRowSet = dataSource.getAllCell().stream().filter(CacheCell::isSummary).map(CacheCell::getRow).distinct().limit(totalRow).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(finalUpdateInfoList = this.filterUpdateInfo(finalUpdateInfoList, extraCustomAmountColumnColSet, littleSummaryColSet, unDataRowSet))) {
            return;
        }
        Map<String, Object> oldCellValueMap = finalUpdateInfoList.stream().filter(item -> Objects.nonNull(item.getOldVal())).collect(Collectors.toMap(k -> k.getRow() + "_" + k.getCol(), CellDataUpdateInfo::getOldVal, (a, b) -> a));
        ReportCalcTree colDimTree = dataSource.getMeta().getColDimTree();
        Optional<TemplateDim> currencyOptional = this.getReportTemplate().getColDimList().stream().filter(templateDim -> templateDim.getDimType() == DimensionType.CURRENCY).findFirst();
        Long currencyDimId = currencyOptional.map(TemplateDim::getDimensionId).orElse(null);
        boolean currencyExpend = currencyOptional.map(TemplateDim::isExpand).orElse(false);
        Set updateRowSet = finalUpdateInfoList.stream().map(CellDataUpdateInfo::getRow).collect(Collectors.toSet());
        Set<Integer> virtualCol = colDimTree.getLeafList().stream().filter(item -> item.getCalcVal().isVirtualCell()).map(ReportCalcValTreeNode::getCol).collect(Collectors.toSet());
        Set<Integer> currencyColSet = this.getCurrencyColSet(colDimTree, currencyOptional, currencyDimId, currencyExpend);
        Set<Integer> amountColSet = dataSource.getAllCell().stream().filter(item -> item.getCellType() == CellTypeEnum.AMOUNT).map(CacheCell::getCol).collect(Collectors.toSet());
        Set<Integer> updateAmountColSet = finalUpdateInfoList.stream().map(CellDataUpdateInfo::getCol).filter(amountColSet::contains).collect(Collectors.toSet());
        boolean inUpdateRange = finalUpdateInfoList.stream().map(CellDataUpdateInfo::getCol).anyMatch(item -> amountColSet.contains(item) || currencyColSet.contains(item) || virtualCol.contains(item));
        if (!inUpdateRange) {
            return;
        }
        ArrayList<CellDataUpdateInfo> totalColUpdateList = new ArrayList<CellDataUpdateInfo>(16);
        Map<String, List<CacheCell>> summaryDimCellMap = this.getSummaryCellMap(dataSource, currencyExpend, virtualCol, currencyColSet, amountColSet, totalRow);
        Set<Map.Entry<Integer, List<CacheCell>>> updateRowEntrySet = dataSource.getAllCell().stream().filter(cacheCell -> updateRowSet.contains(cacheCell.getRow())).collect(Collectors.groupingBy(CacheCell::getRow)).entrySet();
        Map<String, CacheCell> amountCellRowMap = updateRowEntrySet.stream().map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toMap(k -> k.getRow() + "_" + k.getCol(), Function.identity(), (a, b) -> a));
        HashSet editFlowTotalRowKeySet = Sets.newHashSetWithExpectedSize((int)8);
        for (Map.Entry<Integer, List<CacheCell>> entry : updateRowEntrySet) {
            List<CellDataUpdateInfo> infos;
            List<CacheCell> totalAmountCol;
            StringBuilder keyBuilder = new StringBuilder();
            StringBuilder oldKeyBuilder = new StringBuilder();
            Integer row = entry.getKey();
            boolean dimDel = this.isDimDel(dataSource, oldCellValueMap, currencyExpend, virtualCol, currencyColSet, amountColSet, keyBuilder, oldKeyBuilder, entry);
            boolean dimChange = StringUtils.equals((CharSequence)oldKeyBuilder.toString(), (CharSequence)keyBuilder.toString());
            if (!dimChange) {
                totalAmountCol = summaryDimCellMap.get(oldKeyBuilder.toString());
                List<CellDataUpdateInfo> infoList = this.dimChangeUpdateAmount(totalAmountCol, oldCellValueMap, amountCellRowMap, row);
                totalColUpdateList.addAll(infoList);
                if (CollectionUtils.isNotEmpty(infoList)) {
                    editFlowTotalRowKeySet.add(oldKeyBuilder.toString());
                }
            }
            if (CollectionUtils.isEmpty(totalAmountCol = summaryDimCellMap.get(keyBuilder.toString()))) continue;
            if (dimDel) {
                infos = this.clearAmount(updateAmountColSet, amountCellRowMap, row, totalAmountCol);
                totalColUpdateList.addAll(infos);
                if (!CollectionUtils.isNotEmpty(infos)) continue;
                editFlowTotalRowKeySet.add(keyBuilder.toString());
                continue;
            }
            infos = this.updateAmount(oldCellValueMap, updateAmountColSet, amountCellRowMap, row, totalAmountCol);
            totalColUpdateList.addAll(infos);
            if (!CollectionUtils.isNotEmpty(infos)) continue;
            editFlowTotalRowKeySet.add(keyBuilder.toString());
        }
        totalColUpdateList.addAll(this.calNetFlowTotalRowUpdateInfoIfNeed(summaryDimCellMap, editFlowTotalRowKeySet));
        List summaryOfLittle = dataSource.getAllCell().stream().filter(item -> unDataRowSet.contains(item.getRow())).filter(item -> littleSummaryColSet.contains(item.getCol())).collect(Collectors.toList());
        IFormulaManagerV2 formulaManager = this.repository.getFormulaManager();
        for (CacheCell cacheCell2 : summaryOfLittle) {
            List<CacheCell> cacheCells = formulaManager.updateData(cacheCell2, dataSource);
            if (!CollectionUtils.isNotEmpty(cacheCells)) continue;
            for (CacheCell calcVal : cacheCells) {
                totalColUpdateList.add(new CellDataUpdateInfo(calcVal.getRow(), calcVal.getCol(), calcVal.getValue()));
            }
        }
        for (CellDataUpdateInfo cellDataUpdateInfo : totalColUpdateList) {
            this.updateCalcValData(cellDataUpdateInfo, dataSource);
        }
    }

    private List<CellDataUpdateInfo> filterUpdateInfo(List<CellDataUpdateInfo> finalUpdateInfoList, Set<Integer> extraCustomAmountColumnColSet, Set<Integer> littleSummaryColSet, Set<Integer> unDataRowSet) {
        finalUpdateInfoList = finalUpdateInfoList.stream().filter(item -> !unDataRowSet.contains(item.getRow())).filter(item -> CollectionUtils.isEmpty((Collection)extraCustomAmountColumnColSet) || !extraCustomAmountColumnColSet.contains(item.getCol())).filter(item -> CollectionUtils.isEmpty((Collection)littleSummaryColSet) || !littleSummaryColSet.contains(item.getCol())).filter(item -> {
            if (Objects.isNull(item.getVal()) && Objects.isNull(item.getOldVal())) {
                return false;
            }
            BigDecimal newVal = NumberUtils.isNumber((Object)item.getVal()) ? new BigDecimal(item.getVal().toString()) : BigDecimal.ZERO;
            BigDecimal oldVal = NumberUtils.isNumber((Object)item.getOldVal()) ? new BigDecimal(item.getOldVal().toString()) : BigDecimal.ZERO;
            return newVal.compareTo(oldVal) != 0;
        }).collect(Collectors.toList());
        return finalUpdateInfoList;
    }

    private boolean isDimDel(CellDataSource dataSource, Map<String, Object> oldCellValueMap, boolean currencyExpend, Set<Integer> virtualCol, Set<Integer> currencyColSet, Set<Integer> amountColSet, StringBuilder keyBuilder, StringBuilder oldKeyBuilder, Map.Entry<Integer, List<CacheCell>> entry) {
        Object oldValue;
        CacheCell cell;
        Object value;
        Integer row = entry.getKey();
        List<CacheCell> rowCell = entry.getValue();
        boolean dimDel = false;
        for (Integer n : virtualCol) {
            value = null;
            cell = dataSource.getCell(row, n);
            if (Objects.isNull((Object)cell)) continue;
            if (Objects.nonNull(cell.getValue())) {
                value = cell.getValue();
                oldValue = oldCellValueMap.get(row + "_" + n);
                if (Objects.nonNull(oldValue) && !Objects.equals(value, oldValue)) {
                    oldKeyBuilder.append(oldValue).append("-");
                } else {
                    oldKeyBuilder.append(value).append("-");
                }
            } else {
                oldValue = oldCellValueMap.get(row + "_" + n);
                oldKeyBuilder.append(oldValue).append("-");
                dimDel = true;
            }
            if (!Objects.nonNull(value)) continue;
            keyBuilder.append(value).append("-");
        }
        if (keyBuilder.length() > 0) {
            keyBuilder.deleteCharAt(keyBuilder.length() - 1);
        }
        if (oldKeyBuilder.length() > 0) {
            oldKeyBuilder.deleteCharAt(oldKeyBuilder.length() - 1);
        }
        if (currencyExpend || CollectionUtils.isEmpty(currencyColSet)) {
            List currencyCell = rowCell.stream().filter(i -> amountColSet.contains(i.getCol())).collect(Collectors.toList());
            for (CacheCell cacheCell : currencyCell) {
                keyBuilder.append("-").append(cacheCell.getCol());
                oldKeyBuilder.append("-").append(cacheCell.getCol());
            }
        } else {
            for (Integer n : currencyColSet) {
                value = null;
                cell = dataSource.getCell(row, n);
                if (Objects.isNull((Object)cell)) continue;
                if (Objects.nonNull(cell.getValue())) {
                    value = cell.getValue();
                    oldValue = oldCellValueMap.get(row + "_" + n);
                    if (Objects.nonNull(oldValue) && value != oldValue) {
                        oldKeyBuilder.append("-").append(oldValue);
                    } else {
                        oldKeyBuilder.append("-").append(value);
                    }
                } else {
                    oldValue = oldCellValueMap.get(row + "_" + n);
                    oldKeyBuilder.append("-").append(oldValue);
                    dimDel = true;
                }
                if (!Objects.nonNull(value)) continue;
                keyBuilder.append("-").append(value);
            }
        }
        return dimDel;
    }

    private List<CellDataUpdateInfo> dimChangeUpdateAmount(List<CacheCell> totalAmountCol, Map<String, Object> oldCellValueMap, Map<String, CacheCell> amountCellRowMap, Integer row) {
        ArrayList<CellDataUpdateInfo> totalColUpdateList = new ArrayList<CellDataUpdateInfo>(0);
        if (!CollectionUtils.isEmpty(totalAmountCol)) {
            totalColUpdateList = new ArrayList(totalAmountCol.size());
            for (CacheCell cacheCell : totalAmountCol) {
                CacheCell amountCell = amountCellRowMap.get(row + "_" + cacheCell.getCol());
                Object totalAmount = amountCell.getValue();
                BigDecimal currVal = CommonUtils.getBigDecimalValue(cacheCell.getValue());
                if (Objects.isNull(totalAmount)) {
                    totalAmount = oldCellValueMap.getOrDefault(row + "_" + cacheCell.getCol(), BigDecimal.ZERO);
                }
                BigDecimal newValue = currVal.subtract(new BigDecimal(totalAmount.toString()));
                cacheCell.setValue(newValue);
                totalColUpdateList.add(new CellDataUpdateInfo(cacheCell.getRow(), cacheCell.getCol(), cacheCell.getValue()));
            }
        }
        return totalColUpdateList;
    }

    private List<CellDataUpdateInfo> clearAmount(Set<Integer> updateAmountColSet, Map<String, CacheCell> amountCellRowMap, Integer row, List<CacheCell> totalAmountCol) {
        ArrayList<CellDataUpdateInfo> totalColUpdateList = new ArrayList<CellDataUpdateInfo>(totalAmountCol.size());
        for (CacheCell cacheCell : totalAmountCol) {
            if (CollectionUtils.isNotEmpty(updateAmountColSet) && !updateAmountColSet.contains(cacheCell.getCol())) continue;
            CacheCell amountCell = amountCellRowMap.get(row + "_" + cacheCell.getCol());
            Object currVal = Optional.ofNullable(cacheCell.getValue()).orElse(BigDecimal.ZERO);
            Object totalAmount = Optional.ofNullable(amountCell.getValue()).orElse(BigDecimal.ZERO);
            if (EmptyUtil.isEmpty((Object)currVal) && EmptyUtil.isEmpty((Object)totalAmount)) continue;
            BigDecimal subtract = new BigDecimal(currVal.toString()).subtract(new BigDecimal(totalAmount.toString()));
            cacheCell.setValue(subtract);
            totalColUpdateList.add(new CellDataUpdateInfo(cacheCell.getRow(), cacheCell.getCol(), cacheCell.getValue()));
        }
        return totalColUpdateList;
    }

    private List<CellDataUpdateInfo> updateAmount(Map<String, Object> oldCellValueMap, Set<Integer> updateAmountColSet, Map<String, CacheCell> amountCellRowMap, Integer row, List<CacheCell> totalAmountCol) {
        ArrayList<CellDataUpdateInfo> totalColUpdateList = new ArrayList<CellDataUpdateInfo>(totalAmountCol.size());
        for (CacheCell cacheCell : totalAmountCol) {
            if (CollectionUtils.isNotEmpty(updateAmountColSet) && !updateAmountColSet.contains(cacheCell.getCol())) continue;
            CacheCell amountCell = amountCellRowMap.get(row + "_" + cacheCell.getCol());
            Object currVal = Optional.ofNullable(cacheCell.getValue()).orElse(BigDecimal.ZERO);
            Object totalAmount = Optional.ofNullable(amountCell.getValue()).orElse(BigDecimal.ZERO);
            Object oldValue = oldCellValueMap.get(amountCell.getRow() + "_" + amountCell.getCol());
            if (EmptyUtil.isEmpty((Object)currVal) && EmptyUtil.isEmpty((Object)totalAmount) && EmptyUtil.isEmpty((Object)oldValue)) continue;
            if (EmptyUtil.isEmpty((Object)currVal) && EmptyUtil.isNoEmpty((Object)totalAmount)) {
                cacheCell.setValue(totalAmount);
            } else {
                BigDecimal newValue = new BigDecimal(cacheCell.getValue().toString());
                newValue = Objects.nonNull(oldValue) && NumberUtils.notEquals((BigDecimal)new BigDecimal(totalAmount.toString()), (BigDecimal)new BigDecimal(oldValue.toString())) ? newValue.subtract(new BigDecimal(oldValue.toString())).add(new BigDecimal(totalAmount.toString())) : newValue.add(new BigDecimal(totalAmount.toString()));
                cacheCell.setValue(newValue);
            }
            totalColUpdateList.add(new CellDataUpdateInfo(cacheCell.getRow(), cacheCell.getCol(), cacheCell.getValue()));
        }
        return totalColUpdateList;
    }

    private Map<String, List<CacheCell>> getSummaryCellMap(CellDataSource dataSource, boolean currencyExpend, Set<Integer> virtualCol, Set<Integer> currencyColSet, Set<Integer> amountColSet, int totalRow) {
        HashMap<String, List<CacheCell>> summaryDimCellMap = new HashMap<String, List<CacheCell>>(16);
        Set summaryRowSet = dataSource.getAllCell().stream().filter(CacheCell::isSummary).map(CacheCell::getRow).distinct().limit(totalRow).collect(Collectors.toSet());
        Map<Integer, List<CacheCell>> summaryCellMap = dataSource.getAllCell().stream().filter(item -> summaryRowSet.contains(item.getRow())).collect(Collectors.groupingBy(CacheCell::getRow));
        for (Map.Entry<Integer, List<CacheCell>> cellEntry : summaryCellMap.entrySet()) {
            List currencyCell;
            List<CacheCell> cellList = cellEntry.getValue();
            String virtualColStr = cellList.stream().filter(i -> virtualCol.contains(i.getCol())).map(CacheCell::getValue).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining("-"));
            StringBuilder keyBuilder = new StringBuilder(virtualColStr);
            if (currencyExpend || CollectionUtils.isEmpty(currencyColSet)) {
                currencyCell = cellList.stream().filter(i -> amountColSet.contains(i.getCol())).collect(Collectors.toList());
                for (CacheCell cacheCell : currencyCell) {
                    keyBuilder.append("-").append(cacheCell.getCol());
                }
                summaryDimCellMap.put(keyBuilder.toString(), currencyCell);
                continue;
            }
            currencyCell = cellList.stream().filter(i -> currencyColSet.contains(i.getCol())).collect(Collectors.toList());
            CacheCell cacheCell = (CacheCell)((Object)currencyCell.get(0));
            keyBuilder.append("-").append(cacheCell.getValue());
            List amountCells = cellList.stream().filter(item -> amountColSet.contains(item.getCol())).collect(Collectors.toList());
            summaryDimCellMap.put(keyBuilder.toString(), amountCells);
        }
        return summaryDimCellMap;
    }

    private Set<Integer> getCurrencyColSet(ReportCalcTree colDimTree, Optional<TemplateDim> currencyOptional, Long currencyDimId, boolean currencyExpend) {
        Set<Integer> currencyColSet;
        if (currencyExpend) {
            Set currencyMemberScopeList = currencyOptional.map(item -> new HashSet<Long>(item.getMemberScope())).orElseGet(Sets::newHashSet);
            currencyColSet = colDimTree.getLeafList().stream().filter(item -> {
                Object value = item.getCalcVal().getValue();
                return value instanceof Long && currencyMemberScopeList.contains(value);
            }).map(ReportCalcValTreeNode::getCol).collect(Collectors.toSet());
        } else {
            currencyColSet = colDimTree.getLeafList().stream().filter(item -> Objects.nonNull(currencyDimId) && Objects.equals(item.getCalcVal().getDimensionId(), currencyDimId)).map(ReportCalcValTreeNode::getCol).collect(Collectors.toSet());
        }
        return currencyColSet;
    }

    private List<CellDataUpdateInfo> calNetFlowTotalRowUpdateInfoIfNeed(Map<String, List<CacheCell>> summaryDimCellMap, Set<String> editFlowTotalRowKeySet) {
        boolean nonExistNetFlowTotalRow = summaryDimCellMap.keySet().stream().map(key -> {
            String[] keyElementArray = key.split("-");
            return keyElementArray[0];
        }).noneMatch(virtualId -> Objects.equals(String.valueOf(FlowType.NETINFLOW.getVirtualId()), virtualId));
        if (nonExistNetFlowTotalRow) {
            return new ArrayList<CellDataUpdateInfo>(0);
        }
        HashSet waitEditNetInFlowKeySet = Sets.newHashSetWithExpectedSize((int)(editFlowTotalRowKeySet.size() / 2));
        editFlowTotalRowKeySet.stream().map(key -> key.split("-")).filter(keyElementArray -> Objects.equals(keyElementArray[0], String.valueOf(FlowType.IN.getVirtualId())) || Objects.equals(keyElementArray[0], String.valueOf(FlowType.OUT.getVirtualId()))).forEach(keyElementArray -> {
            keyElementArray[0] = String.valueOf(FlowType.NETINFLOW.getVirtualId());
            String netInFlowKey = String.join((CharSequence)"-", keyElementArray);
            waitEditNetInFlowKeySet.add(netInFlowKey);
        });
        LinkedList<CellDataUpdateInfo> netFlowTotalRowUpdateInfoList = new LinkedList<CellDataUpdateInfo>();
        List<FlowType> inOutFlowTypeList = Arrays.asList(FlowType.IN, FlowType.OUT);
        Predicate<CacheCell> summaryAmtCacheCellPredicate = cacheCell -> Objects.nonNull(cacheCell) && cacheCell.isSummary() && cacheCell.getCellType() == CellTypeEnum.AMOUNT;
        for (String netInFlowKey : waitEditNetInFlowKeySet) {
            List<CacheCell> netFlowRowCacheCellList = summaryDimCellMap.get(netInFlowKey);
            netFlowRowCacheCellList = netFlowRowCacheCellList.stream().filter(summaryAmtCacheCellPredicate).collect(Collectors.toList());
            CharSequence[] keyElementArray2 = netInFlowKey.split("-");
            for (CacheCell netFlowRowCacheCell : netFlowRowCacheCellList) {
                BigDecimal netFlowTotalAmt = BigDecimal.ZERO;
                for (FlowType flowType : inOutFlowTypeList) {
                    keyElementArray2[0] = String.valueOf(flowType.getVirtualId());
                    String inOutFlowKey = String.join((CharSequence)"-", keyElementArray2);
                    List<CacheCell> inOutFlowRowCacheCellList = summaryDimCellMap.get(inOutFlowKey);
                    List sameColInOutFlowRowCacheCellList = inOutFlowRowCacheCellList.stream().filter(item -> item.getCol() == netFlowRowCacheCell.getCol()).filter(summaryAmtCacheCellPredicate).collect(Collectors.toList());
                    BigDecimal currFlowTotalAmt = BigDecimal.ZERO;
                    for (CacheCell cacheCell2 : sameColInOutFlowRowCacheCellList) {
                        BigDecimal val = new BigDecimal(cacheCell2.getValue().toString());
                        currFlowTotalAmt = currFlowTotalAmt.add(val);
                    }
                    currFlowTotalAmt = flowType == FlowType.OUT ? currFlowTotalAmt.negate() : currFlowTotalAmt;
                    netFlowTotalAmt = netFlowTotalAmt.add(currFlowTotalAmt);
                }
                netFlowRowCacheCell.setValue(netFlowTotalAmt);
                netFlowRowCacheCell.setDisplayValue(netFlowTotalAmt.toPlainString());
                netFlowTotalRowUpdateInfoList.add(new CellDataUpdateInfo(netFlowRowCacheCell.getRow(), netFlowRowCacheCell.getCol(), netFlowTotalAmt));
            }
        }
        return netFlowTotalRowUpdateInfoList;
    }

    @Override
    public ReportTemplate getReportTemplate() {
        return this.repository.getReportTemplate();
    }

    @Override
    public FundPlanSystem getSystem() {
        return this.repository.getSystem();
    }

    @Override
    public Long getReportId() {
        return ((ReportPlanRepositoryV2)this.repository).getReportId();
    }

    @Override
    public String getPageId() {
        return ((ReportPlanRepositoryV2)this.repository).getPageId();
    }

    @Override
    public void updateSingleCellData(CellDataUpdateInfo updateInfo, CellDataSource dataSource) {
        List<CellDataUpdateInfo> updateInfoList = Collections.singletonList(updateInfo);
        this.updateCellData(updateInfoList, dataSource);
    }

    @Override
    public List<Cell> getNeedUpdateValList() {
        return new ArrayList<Cell>(this.getLastUpdatedValList());
    }

    @Override
    public void reverseDataToReportDataReceiver(CellDataSource cellDataSource, ISpreadDataReceiver receiver) {
        FundPlanSystem system = this.repository.getSystem();
        receiver.receiveReportData(system, cellDataSource);
    }

    @Override
    public void setCacheService(IFpmPageCacheService cacheService) {
        this.repository.setCacheService(cacheService);
    }

    @Override
    public ReportCalcModel getCurrCalcModel() {
        return this.currCalcModel;
    }

    @Override
    public void setCurrCalcModel(ReportCalcModel calcModel) {
        this.currCalcModel = calcModel;
    }

    @Override
    public void updateFormulaManager() {
        DAGFormulaManagerV2 dagFormulaManager = new DAGFormulaManagerV2(this.getCurrCalcModel());
        this.repository.saveFormulaManger(dagFormulaManager);
    }

    private void updateCalcValData(CellDataUpdateInfo updateInfo, CellDataSource dataSource) {
        CacheCell cell = dataSource.getCell(updateInfo.getRow(), updateInfo.getCol());
        if (cell == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u8f91\u7684\u5355\u5143\u683c\u4e0d\u5b58\u5728\uff0crow:%1$s,col:%2$s", (String)"ReportDataManagerV2_0", (String)"tmc-fpm-business", (Object[])new Object[0]), updateInfo.getRow(), updateInfo.getCol()));
        }
        Object displayVal = updateInfo.getVal() == null ? null : updateInfo.getVal().toString();
        CellTypeEnum cellType = cell.getCellType();
        if (cellType == CellTypeEnum.AMOUNT) {
            BigDecimal data = updateInfo.getVal() == null ? null : new BigDecimal(updateInfo.getVal().toString());
            displayVal = data;
            cell.setPropValue("value", data);
        } else {
            if (updateInfo.getVal() != null && updateInfo.getVal() instanceof Date) {
                Date date = (Date)updateInfo.getVal();
                displayVal = DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
                cell.setValue(updateInfo.getVal());
            }
            cell.setValue(updateInfo.getVal());
        }
        if (cellType == CellTypeEnum.F7WIDGET && (EmptyUtil.isEmpty((Object)displayVal) || "0".equals(displayVal))) {
            cell.setDisplayValue("");
            cell.setValue(null);
        } else {
            cell.setDisplayValue(displayVal);
        }
        this.getLastUpdatedValList().add(cell);
    }

    public IReportPlanRepositoryV2 getRepository() {
        return this.repository;
    }

    public void setRepository(IReportPlanRepositoryV2 repository) {
        this.repository = repository;
    }

    public Set<Cell> getLastUpdatedValList() {
        this.lastUpdatedValList = this.lastUpdatedValList == null ? new HashSet() : this.lastUpdatedValList;
        return this.lastUpdatedValList;
    }

    private void interactUpdateSubjectFlowColIfNeed(int subjectCol4UpdateFlowCol, int currSubjectRow, int currSubjectCol, CellDataSource dataSource, DynamicObject subjectBaseData) {
        if (subjectCol4UpdateFlowCol >= 0 && currSubjectCol == subjectCol4UpdateFlowCol && Objects.nonNull(subjectBaseData)) {
            CacheCell cell = dataSource.getCell(currSubjectRow, currSubjectCol + 1);
            String newFlowTypeVal = subjectBaseData.getString("flow");
            Optional<String> displayValOpt = Arrays.stream(FlowEnum.values()).filter(flowEnum -> Objects.equals(flowEnum.getValue(), newFlowTypeVal)).map(FlowEnum::getName).findAny();
            Long flowNewVal = Objects.isNull(newFlowTypeVal) ? null : Arrays.stream(FlowType.values()).filter(flowType -> Objects.equals(flowType.getNumber(), newFlowTypeVal)).map(FlowType::getVirtualId).findAny().get();
            cell.setValue(flowNewVal);
            cell.setDisplayValue(displayValOpt.orElse(""));
        }
    }

    private boolean hasDetailPeriodByReportTemplate(FundPlanSystem fundPlanSystem, ReportTemplate reportTemplate) {
        Map reportPeriodTypeMap = fundPlanSystem.getReportTypeList().stream().collect(Collectors.toMap(ReportPeriodType::getReportPeriodId, Function.identity(), (a, b) -> a));
        Dimension periodDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
        Set periodIdSet = reportTemplate.getAllTemplateDim().stream().filter(tpl -> Objects.equals(tpl.getDimensionId(), periodDim.getId())).map(TemplateDim::getMemberScope).flatMap(Collection::stream).collect(Collectors.toSet());
        return periodDim.getAllDimMemberList(PeriodMember.class).stream().filter(member -> periodIdSet.contains(member.getId())).map(PeriodMember::getPeriodTypeId).map(reportPeriodTypeMap::get).map(ReportPeriodType::getDetailPeriodType).anyMatch(Objects::nonNull);
    }
}

