/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.datamanager.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportChangeData;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.enums.PlanChangeReferIndex;
import kd.tmc.fpm.business.spread.datamanager.ISpreadDataReceiver;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.helper.LoggerPrintHelper;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SpreadPlanChangeDataReceiver
implements ISpreadDataReceiver {
    private static final Log logger = LogFactory.getLog(SpreadPlanChangeDataReceiver.class);
    private PlanChangeReport planChangeReport;

    public SpreadPlanChangeDataReceiver(PlanChangeReport planChangeReport) {
        this.planChangeReport = planChangeReport;
    }

    @Override
    public void receiveReportData(FundPlanSystem system, CellDataSource cellDS) {
        CacheCellMeta meta = cellDS.getMeta();
        List<CacheCell> allCell = cellDS.getAllCell();
        ReportCalcTree colDimTree = meta.getColDimTree();
        List<DimMember> virtualMemberLst = system.getDimList().stream().filter(o -> o.getDimType() == DimensionType.ADJUSTDATATYPE).findFirst().get().getMemberList();
        Set<Long> virtualMemberIds = virtualMemberLst.stream().filter(Objects::nonNull).map(o -> o.getId()).collect(Collectors.toSet());
        Set adjustReferSigns = Arrays.stream(PlanChangeReferIndex.values()).map(o -> o.getValue()).collect(Collectors.toSet());
        List adjustReferIds = virtualMemberLst.stream().filter(o -> adjustReferSigns.contains(o.getNumber())).map(o -> o.getId()).collect(Collectors.toList());
        Optional<DimMember> adjustAmtDimMemberOp = virtualMemberLst.stream().filter(o -> o.getNumber().equals(PlanChangeReferIndex.ADJUSTAMT.getValue())).findFirst();
        if (!adjustAmtDimMemberOp.isPresent()) {
            String errorMessage = ResManager.loadKDString((String)"\u65e0\u6cd5\u5728\u8ba1\u5212\u8c03\u6574\u5355\u627e\u5230\u5bf9\u5e94\u7684\u201c\u672c\u6b21\u8c03\u6574\u91d1\u989d\u201d\u53c2\u8003\u6307\u6807\u865a\u62df\u7ef4\u5ea6\u6210\u5458\u3002", (String)"SpreadPlanChangeDataReceiver_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
            logger.error(errorMessage);
            throw new KDBizException(errorMessage);
        }
        DimMember adjustAmtDimMember = adjustAmtDimMemberOp.get();
        adjustReferIds.remove(adjustAmtDimMember.getId());
        List<ReportData> reportDataList = this.planChangeReport.getReportDataList();
        StringBuilder sb = new StringBuilder("=> ");
        List<Object> reports = new ArrayList(10);
        HashSet<Long> idSet = new HashSet<Long>(10);
        for (ReportData reportData : reportDataList) {
            if (idSet.add(reportData.getId())) continue;
            sb.append(reportData.getId()).append(",");
            reports = reportDataList.stream().filter(o -> o.getId().compareTo(reportData.getId()) == 0).collect(Collectors.toList());
        }
        logger.info(String.format("\u91cd\u590did\uff1a%s, %s", sb.toString(), LoggerPrintHelper.printObjectLoggerByJSON(reports)));
        Map reportDataMap = reportDataList.stream().collect(Collectors.toMap(o -> o.getId(), Function.identity()));
        List colDimCalcVal = colDimTree.getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
        Optional<ReportCalcVal> remarkCalcValOp = colDimCalcVal.stream().filter(o -> o.isRemarkCell()).findFirst();
        if (!remarkCalcValOp.isPresent() && this.planChangeReport.getTemplate().getTemplateType() != TemplateType.DETAIL) {
            String errorMessage = ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f\uff1a\u672a\u627e\u5230\u8c03\u6574\u5355\u5bf9\u5e94\u7684\u5907\u6ce8\u865a\u62df\u7ef4\u5ea6\u3002", (String)"SpreadPlanChangeDataReceiver_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
            logger.error(errorMessage);
            throw new KDBizException(errorMessage);
        }
        HashSet<Integer> adjustColSet = new HashSet<Integer>(8);
        List<ReportCalcVal> adjustAmtCalcValList = colDimCalcVal.stream().filter(o -> !o.isRemarkCell()).filter(o -> Long.valueOf(o.getValue().toString()).compareTo(adjustAmtDimMember.getId()) == 0).collect(Collectors.toList());
        adjustAmtCalcValList.forEach(calcVal -> IntStream.rangeClosed(calcVal.getStartCol(), calcVal.getEndCol()).mapToObj(Integer::valueOf).forEach(col -> adjustColSet.add((Integer)col)));
        List nonCheckCols = colDimCalcVal.stream().filter(o -> !o.isRemarkCell()).filter(o -> adjustReferIds.contains(Long.valueOf(o.getValue().toString()))).map(o -> o.getCol()).collect(Collectors.toList());
        int remarkCol = -1;
        Long remarkDimId = 0L;
        if (remarkCalcValOp.isPresent()) {
            remarkCol = remarkCalcValOp.get().getStartCol();
            adjustColSet.add(remarkCol);
            remarkDimId = remarkCalcValOp.get().getDimensionId();
        }
        int count = (int)allCell.stream().filter(o -> o.getDataId() == null && (o.getCellType() == CellTypeEnum.AMOUNT || o.getCellType() == CellTypeEnum.TEXT)).count();
        LinkedList<Long> idQueue = new LinkedList<Long>();
        if (count > 0) {
            Object ids = DB.genLongIds((String)"t_fpm_reportdatamain", (int)count);
            Arrays.stream((long[])ids).forEach(o -> idQueue.offer(o));
        }
        for (CacheCell cacheCell : allCell) {
            boolean isAdjustRemark;
            Long dataId = (Long)cacheCell.getDataId();
            if (!adjustColSet.contains(cacheCell.getCol())) continue;
            DimensionInfoBean dimensionInfo = cellDS.getDimensionInfo(cacheCell.getCol(), cacheCell.getRow());
            boolean bl = isAdjustRemark = cacheCell.getCol() == remarkCol;
            if (dataId == null || !reportDataMap.containsKey(dataId)) {
                ReportChangeData reportData;
                if (!cellDS.isDirty(cacheCell) || !Objects.nonNull(reportData = this.buildNewReportData(null, dimensionInfo, cacheCell, isAdjustRemark, virtualMemberIds, idQueue, remarkDimId)) || !reportData.isAuxiliaryInfo() && this.isEmptyDimData(this.planChangeReport.getTemplate(), reportData)) continue;
                this.planChangeReport.getReportDataList().add(reportData);
                continue;
            }
            ReportData oldReportData = (ReportData)reportDataMap.get(dataId);
            oldReportData.setDirty(false);
            if (this.planChangeReport.getTemplate().getTemplateType() == TemplateType.DETAIL) {
                for (ReportCalcVal reportCalcVal : colDimCalcVal) {
                    CacheCell cell;
                    if (nonCheckCols.contains(reportCalcVal.getCol()) || reportCalcVal.isRemarkCell() || !cellDS.isDirty(cell = cellDS.getCell(cacheCell.getRow(), reportCalcVal.getCol()))) continue;
                    oldReportData.setDirty(true);
                    break;
                }
                if (isAdjustRemark) {
                    oldReportData.setDirty(true);
                }
                if (!oldReportData.isDirty().booleanValue()) {
                    continue;
                }
            } else {
                if (!cellDS.isDirty(cacheCell)) continue;
                oldReportData.setDirty(true);
            }
            if (oldReportData instanceof ReportChangeData) {
                ReportChangeData reportChangeData = (ReportChangeData)reportDataMap.get(dataId);
                reportChangeData.setDirty(true);
                this.dealAdjustData(this.planChangeReport.getTemplate(), reportChangeData, cacheCell, dimensionInfo, isAdjustRemark, virtualMemberIds, remarkDimId);
                continue;
            }
            ReportChangeData newReportData = this.buildNewReportData(oldReportData, dimensionInfo, cacheCell, isAdjustRemark, virtualMemberIds, idQueue, remarkDimId);
            this.planChangeReport.getReportDataList().add(newReportData);
            if (!Objects.nonNull(newReportData) || !this.isEmptyDimData(this.planChangeReport.getTemplate(), newReportData)) continue;
            newReportData.setDelete(true);
        }
        List<Long> deletedDataIdList = cellDS.getDeletedDataIdList();
        if (CollectionUtils.isNotEmpty(deletedDataIdList)) {
            this.planChangeReport.getReportDataList().removeIf(item -> deletedDataIdList.contains(item.getId()));
        }
    }

    private void dealAdjustData(ReportTemplate template, ReportChangeData reportChangeData, CacheCell cacheCell, DimensionInfoBean dimInfoBean, boolean isRemark, Set<Long> virtualMemberIds, Long adjustRemarkDimId) {
        BigDecimal newAmt;
        Object value = cacheCell.getValue();
        if (isRemark) {
            String remarkDesc = Objects.nonNull(value) ? value.toString() : "";
            reportChangeData.putAuxiliaryVal(adjustRemarkDimId, remarkDesc);
            return;
        }
        BigDecimal bigDecimal = newAmt = Objects.isNull(value) ? BigDecimal.ZERO : new BigDecimal(value.toString());
        if (template.getTemplateType() == TemplateType.DETAIL) {
            BigDecimal oldCurrentAdjustAmt = reportChangeData.getCurrentAdjustAmt();
            BigDecimal oldAdjustedPlanAmt = reportChangeData.getAdjustedPlanAmt();
            reportChangeData.setCurrentAdjustAmt(newAmt);
            reportChangeData.setAdjustedPlanAmt(oldAdjustedPlanAmt.subtract(oldCurrentAdjustAmt).add(newAmt));
            Tuple<List<TemplateDim>, List<Object>> realDimesionInfo = this.getRealDimesionInfo(template, dimInfoBean, virtualMemberIds);
            reportChangeData.setDimList((List)realDimesionInfo.item1);
            reportChangeData.setDimValList((List)realDimesionInfo.item2);
        } else {
            BigDecimal oldCurrentAdjustAmt = reportChangeData.getCurrentAdjustAmt();
            BigDecimal oldAdjustedPlanAmt = reportChangeData.getAdjustedPlanAmt();
            reportChangeData.setCurrentAdjustAmt(newAmt);
            reportChangeData.setAdjustedPlanAmt(oldAdjustedPlanAmt.subtract(oldCurrentAdjustAmt).add(newAmt));
        }
        if (Objects.nonNull(reportChangeData) && this.isEmptyDimData(template, reportChangeData)) {
            reportChangeData.setDelete(true);
        }
    }

    private boolean isEmptyDimData(ReportTemplate template, ReportChangeData reportChangeData) {
        if (template.getTemplateType() == TemplateType.DETAIL) {
            boolean removeFlag = true;
            List<TemplateDim> dimList = reportChangeData.getDimList();
            List noPageDimList = dimList.stream().filter(item -> Objects.nonNull(item) && item.getLocation() != DimLocation.PAGE).collect(Collectors.toList());
            for (TemplateDim templateDim : noPageDimList) {
                Object dimVal = reportChangeData.getDimValByDimensionId(templateDim.getDimensionId());
                if (dimVal instanceof Long && !dimVal.equals(0L) && !templateDim.isExpand()) {
                    removeFlag = false;
                    break;
                }
                if (dimVal instanceof String && StringUtils.isNotEmpty((CharSequence)dimVal.toString()) && !templateDim.isExpand()) {
                    removeFlag = false;
                    break;
                }
                if (!(dimVal instanceof Date) || templateDim.isExpand()) continue;
                removeFlag = false;
                break;
            }
            if (removeFlag && (reportChangeData.getCurrentAdjustAmt() == null || reportChangeData.getCurrentAdjustAmt().compareTo(BigDecimal.ZERO) == 0)) {
                return true;
            }
        }
        return false;
    }

    private void initReportChangeData(ReportChangeData reportChangeData, ReportData reportData) {
        Long reportId;
        Long originalReportId = reportId = this.planChangeReport.getReportId();
        Long originalReportDataId = 0L;
        boolean effectFlag = true;
        BigDecimal actAmt = BigDecimal.ZERO;
        BigDecimal lockAmt = BigDecimal.ZERO;
        BigDecimal planAmt = BigDecimal.ZERO;
        BigDecimal originalPlanAmt = BigDecimal.ZERO;
        if (Objects.nonNull(reportData)) {
            originalReportDataId = reportData.getId();
            effectFlag = reportData.isEffectFlag();
            actAmt = reportData.getActAmt();
            lockAmt = reportData.getLockAmt();
            planAmt = reportData.getPlanAmt();
            originalPlanAmt = reportData.getOriginalPlanAmt();
        }
        reportChangeData.setReportId(reportId);
        reportChangeData.setOriginalReportId(originalReportId);
        reportChangeData.setOriginalReportDataId(originalReportDataId);
        reportChangeData.setEffectFlag(effectFlag);
        reportChangeData.setActAmt(actAmt);
        reportChangeData.setLockAmt(lockAmt);
        reportChangeData.setPlanAmt(planAmt);
        reportChangeData.setOriginalPlanAmt(originalPlanAmt);
    }

    private ReportChangeData buildNewReportData(ReportData oldReportData, DimensionInfoBean dimInfoBean, CacheCell cell, boolean isAdjustReason, Set<Long> virtualMemberIds, Deque<Long> idQueue, Long remarkDimId) {
        ReportChangeData reportChangeData = new ReportChangeData();
        Long pkId = idQueue.poll();
        ReportTemplate template = this.planChangeReport.getTemplate();
        reportChangeData.setId(pkId);
        cell.setDataId(pkId);
        reportChangeData.setVersion(1);
        reportChangeData.setLinkedReportId(this.planChangeReport.getReportId());
        reportChangeData.setRow(cell.getRow());
        reportChangeData.setCol(cell.getCol());
        reportChangeData.setDirty(true);
        Tuple<List<TemplateDim>, List<Object>> realDimesionInfo = this.getRealDimesionInfo(template, dimInfoBean, virtualMemberIds);
        reportChangeData.setDimList((List)realDimesionInfo.item1);
        reportChangeData.setDimValList((List)realDimesionInfo.item2);
        reportChangeData.setReportPeriodId(this.planChangeReport.getReportPeriodId());
        reportChangeData.setMainTable(template.isMainTable());
        reportChangeData.setAmountUnit(template.getAmountUnit());
        if (isAdjustReason) {
            String adjustReason = Objects.nonNull(cell.getValue()) ? cell.getValue().toString() : "";
            reportChangeData.putAuxiliaryVal(remarkDimId, adjustReason);
        } else {
            BigDecimal currentAdjustAmt = Objects.nonNull(cell.getValue()) ? new BigDecimal(cell.getValue().toString()) : BigDecimal.ZERO;
            reportChangeData.setCurrentAdjustAmt(currentAdjustAmt);
            BigDecimal adjustedAmt = null;
            adjustedAmt = oldReportData != null ? oldReportData.getPlanAmt().add(currentAdjustAmt) : BigDecimal.ZERO.add(currentAdjustAmt);
            reportChangeData.setAdjustedPlanAmt(adjustedAmt);
        }
        this.initReportChangeData(reportChangeData, oldReportData);
        List templateDims = template.getAllTemplateDim().stream().filter(o -> o.getDetailDimType() != DetailDimType.PLAN_AMOUNT).filter(o -> !o.isDetailDim() || o.isVisible() && o.isDetailDim()).collect(Collectors.toList());
        if (((List)realDimesionInfo.item1).size() < templateDims.size()) {
            reportChangeData.setAuxiliaryInfo(true);
        }
        return reportChangeData;
    }

    private Tuple<List<TemplateDim>, List<Object>> getRealDimesionInfo(ReportTemplate template, DimensionInfoBean dimInfoBean, Set<Long> virtualMemberIds) {
        ArrayList<TemplateDim> targetTplDimLst = new ArrayList<TemplateDim>(5);
        ArrayList targetTplDimValLst = new ArrayList(5);
        List<TemplateDim> allTemplateDims = template.getAllTemplateDim();
        Map<Long, TemplateDim> templateDimMappingRelation = allTemplateDims.stream().filter(Objects::nonNull).collect(Collectors.toMap(o -> o.getDimensionId(), o -> o));
        for (int index = 0; index < dimInfoBean.getMemberIdList().size(); ++index) {
            Long dimId;
            TemplateDim templateDim;
            Object memberId = dimInfoBean.getMemberIdList().get(index);
            if (virtualMemberIds.contains(memberId) || Objects.isNull(templateDim = templateDimMappingRelation.get(dimId = (Long)dimInfoBean.getDimensionIdList().get(index)))) continue;
            targetTplDimValLst.add(memberId);
            targetTplDimLst.add(templateDim);
        }
        return Tuple.create(targetTplDimLst, targetTplDimValLst);
    }
}

