/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.datamanager.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.index.generate.DimensionIndexMapGenerator;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.spread.datamanager.ISpreadDataReceiver;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;

public class SpreadReferenceDataReceiver
implements ISpreadDataReceiver {
    private static final Log logger = LogFactory.getLog(SpreadReferenceDataReceiver.class);
    private Report report;
    private List<ReportData> referenceReportDataList;

    public SpreadReferenceDataReceiver(Report report, List<ReportData> referenceReportDataList) {
        this.report = report;
        this.referenceReportDataList = referenceReportDataList;
    }

    @Override
    public void receiveReportData(FundPlanSystem system, CellDataSource cellDS) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(SpreadReferenceDataReceiver.class.getSimpleName());){
            logger.info("\u53c2\u8003\u671f\u95f4cell\u6570\u636e\u8f6c\u6210report\u6570\u636e,reportId:{},\u62a5\u8868\u6570\u636e\u6570\u91cf{}", (Object)this.report.getId(), (Object)this.referenceReportDataList.size());
            span.addTag("Pre-work");
            ReportDataIndexQueryMap<Long> bmpMap = DimensionIndexMapGenerator.build(this.referenceReportDataList);
            CacheCellMeta meta = cellDS.getMeta();
            ReportCalcTree colDimTree = meta.getColDimTree();
            List<ReportCalcVal> colDimList = colDimTree.getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
            HashSet remarkInRefColIndex = new HashSet(16);
            colDimList.forEach(item -> {
                if (item.isReferenceCell() && item.isRemarkCell()) {
                    for (int col = item.getCol(); col <= item.getEndCol(); ++col) {
                        remarkInRefColIndex.add(col);
                    }
                }
            });
            Map<Integer, Long> colAndAuxiliaryMap = colDimList.stream().filter(ReportCalcVal::isRemarkCell).filter(ReportCalcVal::isReferenceCell).collect(Collectors.toMap(ReportCalcVal::getCol, ReportCalcVal::getDimensionId));
            Map reportDataMap = this.referenceReportDataList.stream().filter(reportData -> reportData.getId() != null).collect(Collectors.toMap(ReportData::getId, Function.identity()));
            span.addTag("data processing");
            List<CacheCell> allCells = cellDS.getAllCell();
            int count = (int)allCells.stream().filter(o -> o.getDataId() == null && remarkInRefColIndex.contains(o.getCol())).count();
            LinkedList<Long> idQueue = new LinkedList<Long>();
            if (count > 0) {
                long[] idArr;
                for (long id : idArr = DB.genGlobalLongIds((int)count)) {
                    idQueue.offer(id);
                }
            }
            for (CacheCell cell : allCells) {
                int row = cell.getRow();
                int col = cell.getCol();
                Object value = cell.getValue();
                boolean isRemarkAndRef = remarkInRefColIndex.contains(col);
                if (!isRemarkAndRef) continue;
                DimensionInfoBean currDimInfoBean = cellDS.getDimensionInfo(col, row);
                ReportData reportData2 = null;
                Long dataId = (Long)cell.getDataId();
                if (dataId == null || !reportDataMap.containsKey(dataId)) {
                    boolean needCreate = true;
                    Long reportDataId = bmpMap.find(currDimInfoBean);
                    if (reportDataMap.containsKey(reportDataId)) {
                        reportData2 = (ReportData)reportDataMap.get(reportDataId);
                        needCreate = false;
                    }
                    if (needCreate) {
                        reportData2 = this.buildNewReportData(currDimInfoBean, row, col);
                        this.referenceReportDataList.add(reportData2);
                        if (dataId != null) {
                            reportData2.setDirty(cellDS.isDirty(cell));
                        }
                    }
                } else {
                    reportData2 = (ReportData)reportDataMap.get(dataId);
                    if (reportData2.isDirty() == null) {
                        reportData2.setDirty(cellDS.isDirty(cell));
                    }
                }
                if (reportData2 == null) continue;
                if (dataId == null) {
                    dataId = (Long)idQueue.poll();
                    cell.setDataId(dataId);
                }
                reportData2.setId(dataId);
                if (!reportDataMap.containsKey(dataId)) {
                    reportDataMap.put(dataId, reportData2);
                }
                Long dimensionId = colAndAuxiliaryMap.get(col);
                String remark = value == null ? "" : value.toString();
                reportData2.setRemark(remark);
                reportData2.putAuxiliaryVal(dimensionId, remark);
            }
            logger.info("\u6570\u636e\u8f6c\u6362\u7ed3\u675f\u62a5\u8868\u6570\u636e\u6570\u91cf{}", (Object)this.referenceReportDataList.size());
        }
    }

    private ReportData buildNewReportData(DimensionInfoBean currDimInfoBean, int row, int col) {
        ReportData reportData = new ReportData();
        reportData.setVersion(1);
        reportData.setLinkedReportId(this.report.getId());
        reportData.setDirty(true);
        reportData.setRow(row);
        reportData.setCol(col);
        ArrayList<TemplateDim> allTemplateDim = new ArrayList<TemplateDim>(this.report.getTemplate().getAllTemplateDim());
        Map templateDimMap = allTemplateDim.stream().filter(item -> item.getDetailDimType() != DetailDimType.PLAN_AMOUNT && item.isVisible()).collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
        ArrayList<TemplateDim> targetTplDimList = new ArrayList<TemplateDim>(allTemplateDim.size());
        for (Long dimId : currDimInfoBean.getDimensionIdList()) {
            targetTplDimList.add((TemplateDim)templateDimMap.remove(dimId));
        }
        reportData.setDimList(targetTplDimList);
        reportData.setDimValList(currDimInfoBean.getMemberIdList());
        reportData.setReportPeriodId(this.report.getPeriodMemberList().get(0).getId());
        reportData.setMainTable(this.report.getTemplate().isMainTable());
        reportData.setAmountUnit(this.report.getTemplate().getAmountUnit());
        reportData.setPlanAmt(BigDecimal.ZERO);
        reportData.setActAmt(BigDecimal.ZERO);
        reportData.setLockAmt(BigDecimal.ZERO);
        reportData.setOffsetAmt(BigDecimal.ZERO);
        reportData.setReportPlanAmt(BigDecimal.ZERO);
        reportData.setOriginalPlanAmt(BigDecimal.ZERO);
        reportData.setValue(BigDecimal.ZERO);
        if (templateDimMap.size() > 0) {
            reportData.setAuxiliaryInfo(true);
        }
        return reportData;
    }
}

