/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.datamanager.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.index.generate.DimensionIndexMapGenerator;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.spread.datamanager.ISpreadDataReceiver;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SpreadReportDataReceiver
implements ISpreadDataReceiver {
    private static final Log logger = LogFactory.getLog(SpreadReportDataReceiver.class);
    private Report report;

    public SpreadReportDataReceiver(Report report) {
        this.report = report;
    }

    @Override
    public void receiveReportData(FundPlanSystem system, CellDataSource cellDS) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(SpreadReportDataReceiver.class.getSimpleName());){
            logger.info("cell\u6570\u636e\u8f6c\u6210report\u6570\u636e,reportId:{},\u62a5\u8868\u6570\u636e\u6570\u91cf{}", (Object)this.report.getId(), (Object)this.report.getReportDataList().size());
            span.addTag("Pre-work");
            DimensionIndexTree indexTree = this.report.getIndexTree(system);
            ReportDataIndexQueryMap<Long> bmpMap = DimensionIndexMapGenerator.build(this.report.getReportDataList());
            CacheCellMeta meta = cellDS.getMeta();
            ReportCalcTree colDimTree = meta.getColDimTree();
            ReportCalcTree rowDimTree = meta.getRowDimTree();
            List<ReportCalcVal> colDimList = colDimTree.getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
            HashSet summaryColIndexS = new HashSet(16);
            HashSet refColIndexS = new HashSet(16);
            HashSet remarkColIndexS = new HashSet(16);
            colDimList.stream().forEach(item -> {
                int col;
                if (item.isSummary()) {
                    for (col = item.getCol(); col <= item.getEndCol(); ++col) {
                        summaryColIndexS.add(col);
                    }
                }
                if (item.isReferenceCell()) {
                    for (col = item.getCol(); col <= item.getEndCol(); ++col) {
                        refColIndexS.add(col);
                    }
                }
                if (item.isRemarkCell()) {
                    for (col = item.getCol(); col <= item.getEndCol(); ++col) {
                        remarkColIndexS.add(col);
                    }
                }
            });
            span.addTag("Subtotal line");
            HashSet summaryRowIndexS = new HashSet(16);
            if (rowDimTree != null) {
                List rowDimList = rowDimTree.getRoot().getAllChildren().stream().map(ReportCalcValTreeNode::getCalcVal).collect(Collectors.toList());
                rowDimList.stream().forEach(item -> {
                    if (item.isSummary()) {
                        for (int row = item.getRow(); row <= item.getEndRow(); ++row) {
                            summaryRowIndexS.add(row);
                        }
                    }
                });
            }
            Map<Integer, Long> colAndAuxiliaryMap = colDimList.stream().filter(ReportCalcVal::isRemarkCell).collect(Collectors.toMap(ReportCalcVal::getCol, ReportCalcVal::getDimensionId));
            Set<Integer> dataCellColSet = this.getDataCellColSet(colDimList);
            Map reportDataMap = this.report.getReportDataList().stream().filter(reportData -> reportData.getId() != null).collect(Collectors.toMap(ReportData::getId, Function.identity()));
            List<TemplateDim> allTemplateDim = this.report.getTemplate().getAllTemplateDim();
            Map templateDimMap = allTemplateDim.stream().collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
            span.addTag("data processing");
            List<CacheCell> allCells = cellDS.getAllCell();
            int count = (int)allCells.stream().filter(o -> o.getDataId() == null && (o.getCellType() == CellTypeEnum.AMOUNT || o.getCellType() == CellTypeEnum.TEXT)).count();
            LinkedList<Long> idQueue = new LinkedList<Long>();
            if (count > 0) {
                long[] idArr;
                for (long id : idArr = DB.genGlobalLongIds((int)count)) {
                    idQueue.offer(id);
                }
            }
            int colRow = colDimList.stream().max(Comparator.comparing(ReportCalcVal::getRow)).map(ReportCalcVal::getRow).orElse(0);
            int totalRow = colRow + this.report.getTemplate().getTotalRow();
            for (CacheCell cell : allCells) {
                int row = cell.getRow();
                int col = cell.getCol();
                Object value = cell.getValue();
                if (row <= totalRow || !dataCellColSet.contains(col)) continue;
                boolean isSummary = summaryColIndexS.contains(col) || summaryRowIndexS.contains(row);
                boolean isRemark = remarkColIndexS.contains(col);
                boolean isReferenceCell = refColIndexS.contains(col);
                if (isSummary || isReferenceCell) continue;
                DimensionInfoBean currDimInfoBean = cellDS.getDimensionInfo(col, row);
                ReportData reportData2 = null;
                Long dataId = (Long)cell.getDataId();
                if (dataId == null || !reportDataMap.containsKey(dataId)) {
                    Object treeNode;
                    boolean needCreate = true;
                    if (this.report.getTemplate().getTemplateType() == TemplateType.FIXED) {
                        if (!isRemark) {
                            treeNode = indexTree.find(currDimInfoBean);
                            if (treeNode != null && CollectionUtils.isNotEmpty(((TreeNode)treeNode).getDataList())) {
                                reportData2 = (ReportData)((TreeNode)treeNode).getDataList().get(0);
                                dataId = reportData2.getId();
                                cell.setDataId(dataId);
                                needCreate = false;
                            }
                        } else {
                            Long reportDataId = bmpMap.find(currDimInfoBean);
                            if (reportDataMap.containsKey(reportDataId)) {
                                reportData2 = (ReportData)reportDataMap.get(reportDataId);
                                needCreate = false;
                            }
                        }
                    }
                    if (needCreate) {
                        reportData2 = this.buildNewReportData(currDimInfoBean, row, col);
                        this.report.getReportDataList().add(reportData2);
                        if (dataId != null) {
                            reportData2.setDirty(cellDS.isDirty(cell));
                        }
                        if (this.report.getTemplate().getTemplateType() == TemplateType.FIXED) {
                            if (!isRemark) {
                                treeNode = indexTree.find(currDimInfoBean);
                                if (treeNode != null) {
                                    ((TreeNode)treeNode).addData(reportData2);
                                }
                            } else {
                                dataId = this.initDataId(dataId, idQueue, cell, reportData2);
                                bmpMap.addData(reportData2.getDimList(), reportData2.getDimValList(), dataId);
                            }
                        }
                    }
                } else {
                    reportData2 = (ReportData)reportDataMap.get(dataId);
                    if (reportData2.isDirty() == null) {
                        reportData2.setDirty(cellDS.isDirty(cell));
                    }
                    if (this.report.getTemplate().getTemplateType() == TemplateType.DETAIL) {
                        ArrayList<TemplateDim> targetTplDimList = new ArrayList<TemplateDim>(allTemplateDim.size());
                        for (Long dimId : currDimInfoBean.getDimensionIdList()) {
                            targetTplDimList.add((TemplateDim)templateDimMap.get(dimId));
                        }
                        reportData2.setDimList(targetTplDimList);
                        reportData2.setDimValList(currDimInfoBean.getMemberIdList());
                    }
                }
                if (reportData2 == null) continue;
                if (!(this.report.getTemplate().getTemplateType() != TemplateType.DETAIL || reportData2.isDirty() != null && reportData2.isDirty().booleanValue())) {
                    for (ReportCalcVal reportCalcVal : colDimList) {
                        if (!cellDS.isDirty(cellDS.getCell(row, reportCalcVal.getCol()))) continue;
                        reportData2.setDirty(true);
                        break;
                    }
                }
                if (!reportDataMap.containsKey(dataId = this.initDataId(dataId, idQueue, cell, reportData2))) {
                    reportDataMap.put(dataId, reportData2);
                }
                if (CollectionUtils.isNotEmpty(cell.getSourceIdList())) {
                    reportData2.setSourceIdList(cell.getSourceIdList());
                }
                this.handleSetVal(col, reportData2, value, isRemark, colAndAuxiliaryMap, cell);
            }
            List<Long> deletedDataIdList = cellDS.getDeletedDataIdList();
            if (CollectionUtils.isNotEmpty(deletedDataIdList)) {
                this.report.getReportDataList().removeIf(item -> deletedDataIdList.contains(item.getId()));
            }
            if (this.report.getTemplate().getTemplateType() == TemplateType.DETAIL) {
                this.report.clearIndexTree();
                ReportHelper.resetDetailReportRow(this.report, system);
            }
            logger.info("\u6570\u636e\u8f6c\u6362\u7ed3\u675f\u62a5\u8868\u6570\u636e\u6570\u91cf{}", (Object)this.report.getReportDataList().size());
        }
    }

    private ReportData buildNewReportData(DimensionInfoBean currDimInfoBean, int row, int col) {
        ReportData reportData = new ReportData();
        reportData.setVersion(1);
        reportData.setLinkedReportId(this.report.getId());
        reportData.setDirty(true);
        reportData.setRow(row);
        reportData.setCol(col);
        ArrayList<TemplateDim> allTemplateDim = new ArrayList<TemplateDim>(this.report.getTemplate().getAllTemplateDim());
        Map templateDimMap = allTemplateDim.stream().filter(item -> !item.isViDim()).filter(item -> item.getDetailDimType() != DetailDimType.PLAN_AMOUNT && item.isVisible()).collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
        ArrayList<TemplateDim> targetTplDimList = new ArrayList<TemplateDim>(allTemplateDim.size());
        for (Long dimId : currDimInfoBean.getDimensionIdList()) {
            targetTplDimList.add((TemplateDim)templateDimMap.remove(dimId));
        }
        reportData.setDimList(targetTplDimList);
        reportData.setDimValList(currDimInfoBean.getMemberIdList());
        reportData.setReportPeriodId(this.report.getPeriodMemberList().get(0).getId());
        reportData.setMainTable(this.report.getTemplate().isMainTable());
        reportData.setAmountUnit(this.report.getTemplate().getAmountUnit());
        reportData.setPlanAmt(BigDecimal.ZERO);
        reportData.setActAmt(BigDecimal.ZERO);
        reportData.setLockAmt(BigDecimal.ZERO);
        reportData.setOffsetAmt(BigDecimal.ZERO);
        reportData.setReportPlanAmt(BigDecimal.ZERO);
        reportData.setOriginalPlanAmt(BigDecimal.ZERO);
        reportData.setValue(BigDecimal.ZERO);
        if (templateDimMap.size() > 0) {
            reportData.setAuxiliaryInfo(true);
        }
        return reportData;
    }

    private void handleSetVal(int col, ReportData reportData, Object value, boolean isRemark, Map<Integer, Long> colAndAuxiliaryMap, CacheCell cell) {
        ReportTemplate template = this.report.getTemplate();
        TemplateType templateType = template.getTemplateType();
        if (isRemark) {
            Long dimensionId = colAndAuxiliaryMap.get(col);
            String remark = value == null ? "" : value.toString();
            reportData.setRemark(remark);
            reportData.putAuxiliaryVal(dimensionId, remark);
        } else {
            BigDecimal decimal = value == null ? BigDecimal.ZERO : new BigDecimal(value.toString());
            reportData.setBigDecimalValueOrDefault(decimal);
            if (templateType == TemplateType.DETAIL) {
                reportData.setPlanAmt(decimal);
                reportData.setRow(cell.getRow());
                reportData.setCol(cell.getCol());
            }
        }
        if (templateType == TemplateType.DETAIL) {
            boolean removeFlag = true;
            List<TemplateDim> dimList = reportData.getDimList();
            List noPageDimList = dimList.stream().filter(item -> item.getLocation() != DimLocation.PAGE).collect(Collectors.toList());
            for (TemplateDim templateDim : noPageDimList) {
                Object dimVal = reportData.getDimValByDimensionId(templateDim.getDimensionId());
                if (dimVal instanceof Long && !dimVal.equals(0L) && !templateDim.isExpand()) {
                    removeFlag = false;
                    break;
                }
                if (dimVal instanceof String && StringUtils.isNotEmpty((CharSequence)dimVal.toString()) && !templateDim.isExpand()) {
                    removeFlag = false;
                    break;
                }
                if (!(dimVal instanceof Date) || templateDim.isExpand()) continue;
                removeFlag = false;
                break;
            }
            if (removeFlag && (reportData.getPlanAmt() == null || reportData.getPlanAmt().compareTo(BigDecimal.ZERO) == 0)) {
                this.report.getReportDataList().remove(reportData);
                cell.setDataId(null);
                cell.setSourceIdList(null);
            }
        }
    }

    private Set<Integer> getDataCellColSet(List<ReportCalcVal> colDimValList) {
        ReportTemplate template = this.report.getTemplate();
        TemplateType templateType = template.getTemplateType();
        List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
        HashSet<Integer> dataColSet = new HashSet<Integer>(16);
        if (templateType == TemplateType.DETAIL) {
            Optional<TemplateDim> expandTplDimList = allTemplateDim.stream().filter(TemplateDim::isExpand).findFirst();
            TemplateDim dataTplDim = null;
            dataTplDim = expandTplDimList.isPresent() ? expandTplDimList.get() : allTemplateDim.stream().filter(item -> item.getDetailDimType() != null && item.getDetailDimType() == DetailDimType.PLAN_AMOUNT).findFirst().get();
            TemplateDim finalDataTplDim = dataTplDim;
            colDimValList.stream().filter(item -> item.getDimensionId() != null && item.getDimensionId().equals(finalDataTplDim.getDimensionId())).forEach(item -> {
                for (int col = item.getCol(); col <= item.getEndCol(); ++col) {
                    dataColSet.add(col);
                }
            });
        } else {
            colDimValList.forEach(item -> {
                for (int col = item.getCol(); col <= item.getEndCol(); ++col) {
                    dataColSet.add(col);
                }
            });
        }
        return dataColSet;
    }

    private Long initDataId(Long dataId, Deque<Long> idQueue, CacheCell cell, ReportData reportData) {
        if (dataId == null) {
            dataId = idQueue.poll();
            cell.setDataId(dataId);
        }
        reportData.setId(dataId);
        return dataId;
    }
}

