/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.excel;

import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public interface IExcelExportBasicOp {
    public static final Integer MIN_COL_WIDTH = 2474;
    public static final Integer MAX_COL_WIDTH = 6570;
    public static final String ILLEGAL_CHARACTER_REGEX = "[/|\"|'|\\\\|*|?|\\[|\\]]";

    default public XSSFSheet createSheet(XSSFWorkbook wb, String name) {
        name = name.replaceAll(ILLEGAL_CHARACTER_REGEX, " ");
        int index = wb.getNumberOfSheets() + 1;
        XSSFSheet sheet = EmptyUtil.isNotEmpty((CharSequence)name) ? wb.createSheet(String.format("%s_%s", index, name)) : wb.createSheet(String.format("sheet_%s", index));
        return sheet;
    }

    default public void mergeCellRegion(XSSFSheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress region = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        sheet.addMergedRegion(region);
    }

    default public void freezeRegion(XSSFSheet sheet, int fzColInx, int fzRowInx) {
        sheet.createFreezePane(fzColInx, fzRowInx);
    }

    default public void customStyles(XSSFCellStyle xssfCellStyle, Cell cell, XSSFWorkbook xssfWB) {
        if (cell.getCellType() == CellTypeEnum.PERCENT) {
            XSSFCreationHelper creationHelper = xssfWB.getCreationHelper();
            xssfCellStyle.setDataFormat(creationHelper.createDataFormat().getFormat("#,##0.00%"));
        }
    }

    default public void adaptiveWidth(XSSFSheet sheet, int col) {
        sheet.autoSizeColumn(col, true);
        int cellWidth = sheet.getColumnWidth(col);
        if (cellWidth < MIN_COL_WIDTH) {
            sheet.setColumnWidth(col, MIN_COL_WIDTH.intValue());
        } else if (cellWidth > MAX_COL_WIDTH) {
            sheet.setColumnWidth(col, MAX_COL_WIDTH.intValue());
        } else {
            sheet.setColumnWidth(col, cellWidth + 256);
        }
    }
}

