/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.excel.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.spread.export.IReportFormsExport;
import kd.tmc.fpm.business.spread.export.excel.IExcelExportBasicOp;
import kd.tmc.fpm.business.spread.export.excel.unit.CellStyleUnit;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class AbsReportFormsExportExcel
implements IReportFormsExport,
IExcelExportBasicOp {
    private static Log logger = LogFactory.getLog(AbsReportFormsExportExcel.class);

    protected abstract void getOriginalData();

    protected abstract String exportParamsPrepare(Map<String, Sheet> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tuple<Boolean, String> export() {
        String url = null;
        this.getOriginalData();
        LinkedHashMap<String, Sheet> sheetMap = new LinkedHashMap<String, Sheet>(16);
        String excelName = this.exportParamsPrepare(sheetMap);
        if (EmptyUtil.isEmpty(sheetMap)) {
            return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u6ca1\u6709\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"AbsReportFormsExportExcel_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        XSSFWorkbook xssfWB = this.generateWorkBook(sheetMap, excelName);
        if (EmptyUtil.isEmpty((Object)xssfWB)) {
            return Tuple.create((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u5f53\u524d %1$s \u6ca1\u6709\u4efb\u4f55\u5185\u5bb9\u5bfc\u51fa\u3002", (String)"AbsReportFormsExportExcel_1", (String)"tmc-fpm-business", (Object[])new Object[0]), excelName));
        }
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            xssfWB.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            url = this.createTmpfile(inStream, excelName);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            Tuple tuple = Tuple.create((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25: %1$s", (String)"AbsReportFormsExportExcel_2", (String)"tmc-fpm-business", (Object[])new Object[0]), e.getMessage()));
            return tuple;
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (xssfWB != null) {
                try {
                    xssfWB.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)url);
    }

    private XSSFWorkbook generateWorkBook(Map<String, Sheet> sheetMap, String name) {
        logger.info(String.format("\u5f00\u59cb\u5bfc\u51fa %s \u62a5\u8868: \u5171 %s Sheet\u9875\u3002", name, sheetMap.size()));
        if (EmptyUtil.isEmpty(sheetMap)) {
            logger.info(String.format("\u5f53\u524d %s \u6ca1\u6709\u4efb\u4f55\u5185\u5bb9\u5bfc\u51fa\u3002", name));
            return null;
        }
        XSSFWorkbook xssfWB = new XSSFWorkbook();
        CellStyleUnit cellStyleUnit = new CellStyleUnit(xssfWB);
        Set<Map.Entry<String, Sheet>> entries = sheetMap.entrySet();
        for (Map.Entry<String, Sheet> entry : entries) {
            String sheetName = entry.getKey();
            List dataSource = entry.getValue().getCellList();
            XSSFSheet sheet = this.createSheet(xssfWB, sheetName);
            this.hook(dataSource, sheet, xssfWB);
            Map<Integer, List<Cell>> cellsByRowMap = dataSource.stream().filter(Objects::nonNull).sorted(Comparator.comparingInt(Cell::getRow)).collect(Collectors.groupingBy(Cell::getRow));
            Set<Map.Entry<Integer, List<Cell>>> rowEntrys = cellsByRowMap.entrySet();
            ArrayList needMergeCells = new ArrayList(10);
            HashSet<Integer> cols = new HashSet<Integer>(10);
            for (Map.Entry<Integer, List<Cell>> rowEntry : rowEntrys) {
                XSSFRow row = sheet.createRow(rowEntry.getKey().intValue());
                row.setHeightInPoints(22.0f);
                List<Cell> cells = rowEntry.getValue();
                this.afterCreateRow(sheetName, row, cells);
                for (Cell cell : cells) {
                    cols.add(cell.getCol());
                    XSSFCell xssfCell = row.createCell(cell.getCol());
                    Object value = cell.getDisplayValue();
                    String displayVal = Optional.ofNullable(value).map(Object::toString).orElse("");
                    if (cell.getCellType() == CellTypeEnum.AMOUNT) {
                        if (EmptyUtil.isNoEmpty((String)value.toString())) {
                            xssfCell.setCellValue(new BigDecimal(value.toString()).doubleValue());
                        } else {
                            xssfCell.setCellValue("");
                        }
                    } else if (cell.getCellType() == CellTypeEnum.PERCENT) {
                        BigDecimal bigDecimalValue = CommonUtils.getBigDecimalValue(value);
                        xssfCell.setCellValue(bigDecimalValue.doubleValue());
                    } else {
                        xssfCell.setCellValue(displayVal.trim());
                    }
                    if (EmptyUtil.isNoEmpty((String)cell.getFormula())) {
                        xssfCell.setCellFormula(cell.getFormula().substring(1));
                    }
                    XSSFCellStyle xssfCellStyle = (XSSFCellStyle)cellStyleUnit.obtainEntityUnit(cell);
                    this.customStyles(xssfCellStyle, cell, xssfWB);
                    xssfCell.setCellStyle((CellStyle)xssfCellStyle);
                }
                List spanCells = cells.stream().filter(Objects::nonNull).filter(o -> o.getColSpan() != 1 || o.getRowSpan() != 1).collect(Collectors.toList());
                needMergeCells.addAll(spanCells);
            }
            for (Cell mergeCell : needMergeCells) {
                int firstRow = mergeCell.getRow();
                int lastRow = firstRow + mergeCell.getRowSpan() - 1;
                int firstCol = mergeCell.getCol();
                int lastCol = firstCol + mergeCell.getColSpan() - 1;
                this.mergeCellRegion(sheet, firstRow, lastRow, firstCol, lastCol);
                this.setMergeCellStyle(sheet, firstRow, lastRow, firstCol, lastCol);
            }
            for (Integer col : cols) {
                this.adaptiveWidth(sheet, col);
            }
        }
        return xssfWB;
    }

    protected void setMergeCellStyle(XSSFSheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        XSSFRow row = sheet.getRow(firstRow);
        XSSFCell mergeCell = row.getCell(firstCol);
        XSSFCellStyle cellStyle = mergeCell.getCellStyle();
        for (int rowIndex = firstRow; rowIndex <= lastRow; ++rowIndex) {
            XSSFRow xssfRow = sheet.getRow(rowIndex);
            if (xssfRow == null) {
                xssfRow = sheet.createRow(rowIndex);
            }
            for (int colIndex = firstCol; colIndex <= lastCol; ++colIndex) {
                XSSFCell xssfCell = xssfRow.getCell(colIndex);
                if (xssfCell != null) continue;
                xssfCell = xssfRow.createCell(colIndex);
                xssfCell.setCellStyle((CellStyle)cellStyle);
            }
        }
    }

    protected void hook(List<Cell> dataSource, XSSFSheet sheet, XSSFWorkbook xssfWB) {
    }

    protected void afterCreateRow(String sheetName, XSSFRow row, List<Cell> cells) {
    }
}

