/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.excel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.service.IReportBizService;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.spread.export.excel.impl.AbsReportFormsExportExcel;
import kd.tmc.fpm.business.spread.export.utils.ReportPlanHeaderHelper;
import kd.tmc.fpm.business.spread.formula.impl.DAGFormulaManager;
import kd.tmc.fpm.business.spread.generator.SpreadDataGeneratorFactory;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.business.spread.generator.executor.ReportDataProcessExecutorFactory;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.xssf.usermodel.XSSFRow;

public class ReportPlanFormsExportImpl
extends AbsReportFormsExportExcel {
    private static Log logger = LogFactory.getLog(ReportPlanFormsExportImpl.class);
    private IReportBizService reportBizService = new ReportBizService();
    private IDimensionRepository dimRepo = new DimensionRepository();
    private List<PlanReportExportModel> planReportExportModels;
    private Set<Long> reportIds;
    private Report report;
    private FundPlanSystem system;
    private Map<String, Set<Integer>> hideRowMap;

    public ReportPlanFormsExportImpl(Set<Long> reportIds) {
        this.reportIds = reportIds;
    }

    @Override
    protected void getOriginalData() {
        ArrayList<PlanReportExportModel> planReportExportModels = new ArrayList<PlanReportExportModel>(this.reportIds.size());
        this.hideRowMap = new HashMap<String, Set<Integer>>(this.reportIds.size());
        for (Long reportId : this.reportIds) {
            IReportDataProcessExecutor reportExecutor;
            ReportModel reportModel;
            FpmOperateResult<Report> reportFpmOperateResult = this.reportBizService.loadReport(reportId);
            if (!reportFpmOperateResult.isSuccess()) {
                List<String> messageList = reportFpmOperateResult.getMessageList();
                String errMsg = messageList.stream().filter(Objects::nonNull).collect(Collectors.joining("\u3001"));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8ba1\u5212\u7f16\u5236\u62a5\u8868\u6570\u636e\u5f02\u5e38: %1$s", (String)"ReportPlanFormsExportImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), errMsg));
            }
            Report report = reportFpmOperateResult.getData();
            if (this.system == null) {
                this.system = this.dimRepo.loadSystem(report.getSystemId());
            }
            if (EmptyUtil.isNoEmpty((Object)(reportModel = (reportExecutor = ReportDataProcessExecutorFactory.getReportPlanExecutorOfExport(this.system, report)).executeAction()))) {
                List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList().stream().filter(Objects::nonNull).collect(Collectors.toList());
                if (EmptyUtil.isNoEmpty(reportCalcModelList)) {
                    PlanReportExportModel model = new PlanReportExportModel(reportCalcModelList, report);
                    planReportExportModels.add(model);
                }
                Set hideRows = reportCalcModelList.stream().map(ReportCalcModel::getRowDimValList).flatMap(Collection::stream).filter(ReportCalcVal::isHide).map(item -> item.getRow() + ReportPlanHeaderHelper.HEADER_OFFSET_NUM).collect(Collectors.toSet());
                this.hideRowMap.put(report.getNumber(), hideRows);
            }
            this.report = report;
        }
        this.planReportExportModels = planReportExportModels;
    }

    @Override
    protected String exportParamsPrepare(Map<String, Sheet> sheetMap) {
        if (EmptyUtil.isEmpty(this.planReportExportModels)) {
            return String.format(ResManager.loadKDString((String)"\u7a7a\u62a5\u8868_%1$s.xlsx", (String)"ReportPlanFormsExportImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd"));
        }
        String excelName = String.format("%s_%s_%s.xlsx", this.report.getPeriodMemberList().get(0).getName(), this.system.getName(), DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd"));
        List sortedReportExportModelList = this.planReportExportModels.stream().sorted(Comparator.comparing(o -> o.getReport().getCompanyMemberList().get(0).getName())).collect(Collectors.toList());
        for (PlanReportExportModel planReportExportModel : sortedReportExportModelList) {
            Report currentReport = planReportExportModel.getReport();
            String orgName = currentReport.getCompanyMemberList().get(0).getName();
            for (int i = 0; i < planReportExportModel.getReportCalcModels().size(); ++i) {
                ReportCalcModel currReportCalcModel = planReportExportModel.getReportCalcModels().get(i);
                String pageDimStr = currReportCalcModel.getPageDimValList().stream().map(ReportCalcVal::getDisplayVal).collect(Collectors.joining("_"));
                String sheetName = String.format("%s)%s_%s_%s", i + 1, orgName, currentReport.getNumber(), pageDimStr);
                new DAGFormulaManager(currReportCalcModel, null);
                ReportPlanHeaderHelper.addExcelReportHeader(currentReport, this.system, currReportCalcModel);
                Book book = SpreadDataGeneratorFactory.createReportDataGenerator().generate(currReportCalcModel);
                sheetMap.put(sheetName, book.getSheet());
            }
        }
        return excelName;
    }

    @Override
    protected void afterCreateRow(String sheetName, XSSFRow row, List<Cell> cells) {
        super.afterCreateRow(sheetName, row, cells);
        if (MapUtils.isEmpty(this.hideRowMap)) {
            return;
        }
        for (Map.Entry<String, Set<Integer>> entry : this.hideRowMap.entrySet()) {
            Set<Integer> hideRows;
            String number = entry.getKey();
            if (!sheetName.contains(number) || !(hideRows = entry.getValue()).contains(row.getRowNum())) continue;
            row.setZeroHeight(true);
            break;
        }
    }

    private static class PlanReportExportModel {
        private List<ReportCalcModel> reportCalcModels;
        private Report report;

        public PlanReportExportModel(List<ReportCalcModel> reportCalcModels, Report report) {
            this.reportCalcModels = reportCalcModels;
            this.report = report;
        }

        public List<ReportCalcModel> getReportCalcModels() {
            return this.reportCalcModels;
        }

        public Report getReport() {
            return this.report;
        }
    }
}

