/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.excel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.service.IReportBizService;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.spread.export.excel.IExcelExportBasicOp;
import kd.tmc.fpm.business.spread.export.excel.impl.AbsReportFormsExportExcel;
import kd.tmc.fpm.business.spread.formula.impl.DAGFormulaManager;
import kd.tmc.fpm.business.spread.generator.SpreadDataGeneratorFactory;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.business.spread.generator.executor.ReportDataProcessExecutorFactory;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReportTemplateExportImpl
extends AbsReportFormsExportExcel
implements IExcelExportBasicOp {
    private IReportBizService reportBizService = new ReportBizService();
    private IDimensionRepository dimRepo = new DimensionRepository();
    private List<PlanReportExportModel> planReportExportModels;
    private Set<String> reportIds;
    private Report report;
    private FundPlanSystem system;
    private Map<String, Set<Integer>> hideRowMap;
    private String reportNumber;

    public ReportTemplateExportImpl(Set<String> reportIds) {
        this.reportIds = reportIds;
        this.reportNumber = "";
    }

    @Override
    protected void getOriginalData() {
        ArrayList<PlanReportExportModel> planReportExportModels = new ArrayList<PlanReportExportModel>(this.reportIds.size());
        this.hideRowMap = new HashMap<String, Set<Integer>>(this.reportIds.size());
        for (String reportId : this.reportIds) {
            FpmOperateResult<Report> reportFpmOperateResult = this.reportBizService.loadReport(Long.valueOf(reportId));
            if (!reportFpmOperateResult.isSuccess()) {
                List<String> messageList = reportFpmOperateResult.getMessageList();
                String errMsg = messageList.stream().filter(Objects::nonNull).collect(Collectors.joining("\u3001"));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8ba1\u5212\u7f16\u5236\u6a21\u677f\u6570\u636e\u5f02\u5e38: %1$s", (String)"ReportTemplateExportImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), errMsg));
            }
            Report report = reportFpmOperateResult.getData();
            FundPlanSystem system = this.dimRepo.loadSystem(report.getSystemId());
            IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getReportTemplExecutorOfExport(system, report);
            ReportModel reportModel = new ReportModel();
            reportExecutor.executeAction(reportModel);
            if (EmptyUtil.isNoEmpty((Object)reportModel)) {
                List<ReportCalcModel> reportCalcModelList = reportModel.getReportCalcModelList().stream().filter(Objects::nonNull).collect(Collectors.toList());
                if (EmptyUtil.isNoEmpty(reportCalcModelList)) {
                    PlanReportExportModel model = new PlanReportExportModel(reportCalcModelList, report);
                    planReportExportModels.add(model);
                }
                Set hideRows = reportCalcModelList.stream().map(ReportCalcModel::getRowDimValList).flatMap(Collection::stream).filter(ReportCalcVal::isHide).map(ReportCalcVal::getRow).collect(Collectors.toSet());
                this.hideRowMap.put(report.getNumber(), hideRows);
            }
            this.report = report;
            this.system = system;
        }
        this.planReportExportModels = planReportExportModels;
    }

    @Override
    protected String exportParamsPrepare(Map<String, Sheet> sheetMap) {
        if (EmptyUtil.isEmpty(this.planReportExportModels)) {
            return String.format(ResManager.loadKDString((String)"\u7a7a\u6570\u636e\u6a21\u677f_%1$s.xlsx", (String)"ReportTemplateExportImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd"));
        }
        int sheetIdx = 1;
        String excelName = String.format(ResManager.loadKDString((String)"%1$s_%2$s_\u5bfc\u5165\u6a21\u677f.xlsx", (String)"ReportTemplateExportImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]), this.report.getPeriodMemberList().get(0).getName(), this.system.getName());
        Dimension orgDim = this.system.getDimList().stream().filter(dim -> dim.getDimType() == DimensionType.ORG).findFirst().get();
        for (PlanReportExportModel planReportExportModel : this.planReportExportModels) {
            Report report = planReportExportModel.getReport();
            List<ReportCalcModel> reportCalcModels = planReportExportModel.getReportCalcModels();
            for (ReportCalcModel calcModel : reportCalcModels) {
                String pageDimStr = calcModel.getPageDimValList().stream().filter(val -> !Objects.equals(val.getDimensionId(), orgDim.getId())).map(ReportCalcVal::getDisplayVal).collect(Collectors.joining("_"));
                String sheetName = String.format("%s)%s", sheetIdx++, report.getName());
                if (StringUtils.isNotEmpty((CharSequence)pageDimStr)) {
                    sheetName = sheetName + "_" + pageDimStr;
                }
                DAGFormulaManager formulaManager = new DAGFormulaManager(calcModel, null);
                Book book = SpreadDataGeneratorFactory.createReportDataGenerator().generate(calcModel);
                sheetMap.put(sheetName, book.getSheet());
            }
        }
        return excelName;
    }

    @Override
    public XSSFSheet createSheet(XSSFWorkbook wb, String name) {
        return wb.createSheet(name);
    }

    @Override
    protected void hook(List<Cell> dataSource, XSSFSheet sheet, XSSFWorkbook xssfWB) {
        this.setSelectBox(dataSource, sheet, xssfWB);
    }

    @Override
    public void customStyles(XSSFCellStyle xssfCellStyle, Cell cell, XSSFWorkbook xssfWB) {
        IExcelExportBasicOp.super.customStyles(xssfCellStyle, cell, xssfWB);
        if (cell.getCellType() == CellTypeEnum.DATE) {
            XSSFCreationHelper creationHelper = xssfWB.getCreationHelper();
            xssfCellStyle.setDataFormat(creationHelper.createDataFormat().getFormat("yyyy/MM/dd"));
        }
    }

    @Override
    protected void afterCreateRow(String sheetName, XSSFRow row, List<Cell> cells) {
        String number;
        Cell reportNumberCell;
        super.afterCreateRow(sheetName, row, cells);
        if (MapUtils.isEmpty(this.hideRowMap)) {
            return;
        }
        if (row.getRowNum() == 1 && Objects.nonNull(reportNumberCell = (Cell)cells.stream().filter(item -> item.getCol() == 2).findFirst().orElse(null)) && Objects.nonNull(reportNumberCell.getValue()) && !StringUtils.equals((CharSequence)(number = reportNumberCell.getValue().toString()), (CharSequence)this.reportNumber)) {
            this.reportNumber = number;
        }
        for (Map.Entry<String, Set<Integer>> entry : this.hideRowMap.entrySet()) {
            Set<Integer> hideRows;
            String number2 = entry.getKey();
            if (!sheetName.contains(number2) && !this.reportNumber.contains(number2) || !(hideRows = entry.getValue()).contains(row.getRowNum())) continue;
            row.setZeroHeight(true);
            break;
        }
    }

    private void setSelectBox(List<Cell> dataSource, XSSFSheet sheet, XSSFWorkbook workbook) {
        List selectBoxList = dataSource.stream().filter(cell -> cell.getCellType() == CellTypeEnum.DOWNBOXWIDGET).filter(cell -> cell.isLock() == false).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(selectBoxList)) {
            return;
        }
        int maxRow = selectBoxList.stream().max(Comparator.comparing(Cell::getRow)).map(Cell::getRow).orElse(0);
        int minRow = selectBoxList.stream().min(Comparator.comparing(Cell::getRow)).map(Cell::getRow).orElse(0);
        DataValidationHelper dataValidationHelper = sheet.getDataValidationHelper();
        String tips = ResManager.loadKDString((String)"\u63d0\u793a", (String)"ReportTemplateExportImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]);
        String warnMsg1 = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u81ea\u5df1\u8f93\u5165\uff0c\u8bf7\u9009\u62e9\u4e0b\u62c9\u6846\u91cc\u7684\u6570\u636e", (String)"ReportTemplateExportImpl_4", (String)"tmc-fpm-business", (Object[])new Object[0]);
        String warnMsg2 = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0b\u62c9\u6846\u91cc\u7684\u6570\u636e", (String)"ReportTemplateExportImpl_5", (String)"tmc-fpm-business", (Object[])new Object[0]);
        List minSelectBoxList = selectBoxList.stream().filter(cell -> cell.getRow() == minRow).collect(Collectors.toList());
        int largeCelIdx = 0;
        for (Cell cell2 : minSelectBoxList) {
            CharSequence[] selectData = (String[])cell2.getWidgetValue();
            int length = String.join((CharSequence)",", selectData).length();
            CellRangeAddressList addressList = new CellRangeAddressList(minRow, maxRow, cell2.getCol(), cell2.getCol());
            if (length > 255) {
                String hiddenSheetName = "Hidden" + this.report.getId() + largeCelIdx++;
                String rangeName = hiddenSheetName + "range";
                if (workbook.getSheetIndex(hiddenSheetName) == -1) {
                    XSSFSheet hiddenSheet = workbook.createSheet(hiddenSheetName);
                    for (int i = 0; i < selectData.length; ++i) {
                        XSSFRow row = hiddenSheet.createRow(i);
                        XSSFCell _cell = row.createCell(0);
                        _cell.setCellValue((String)selectData[i]);
                    }
                    workbook.setSheetHidden(workbook.getSheetIndex((org.apache.poi.ss.usermodel.Sheet)hiddenSheet), true);
                    XSSFName namedRange = workbook.createName();
                    namedRange.setNameName(rangeName);
                    namedRange.setRefersToFormula(hiddenSheetName + "!$A$1:$A$" + selectData.length);
                }
                DataValidationHelper validationHelper = sheet.getDataValidationHelper();
                DataValidationConstraint constraint = validationHelper.createFormulaListConstraint(rangeName);
                DataValidation dataValidation = validationHelper.createValidation(constraint, addressList);
                dataValidation.setSuppressDropDownArrow(true);
                dataValidation.setShowErrorBox(true);
                dataValidation.setErrorStyle(0);
                dataValidation.createErrorBox(tips, warnMsg1);
                dataValidation.createPromptBox(tips, warnMsg2);
                dataValidation.setShowPromptBox(true);
                sheet.addValidationData(dataValidation);
                continue;
            }
            DataValidationConstraint constraint = dataValidationHelper.createExplicitListConstraint((String[])selectData);
            DataValidation dataValidation = dataValidationHelper.createValidation(constraint, addressList);
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
            dataValidation.setErrorStyle(0);
            dataValidation.createErrorBox(tips, warnMsg1);
            dataValidation.createPromptBox(tips, warnMsg2);
            dataValidation.setShowPromptBox(true);
            sheet.addValidationData(dataValidation);
        }
    }

    private static class PlanReportExportModel {
        private List<ReportCalcModel> reportCalcModels;
        private Report report;

        public PlanReportExportModel(List<ReportCalcModel> reportCalcModels, Report report) {
            this.reportCalcModels = reportCalcModels;
            this.report = report;
        }

        public List<ReportCalcModel> getReportCalcModels() {
            return this.reportCalcModels;
        }

        public Report getReport() {
            return this.report;
        }
    }
}

