/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.excel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.SumPlanHeader;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IAnalysisReportBizService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisReportBizService;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.mvc.service.IAnalysisReportManageService;
import kd.tmc.fpm.business.mvc.service.ISumPlanBizService;
import kd.tmc.fpm.business.mvc.service.impl.AnalysisReportManagerService;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanBizServiceImpl;
import kd.tmc.fpm.business.spread.export.excel.impl.AbsReportFormsExportExcel;
import kd.tmc.fpm.business.spread.export.utils.SumPlanAnalysisReportHeaderHelper;
import kd.tmc.fpm.business.spread.export.utils.SumPlanHeaderHelper;
import kd.tmc.fpm.business.spread.formula.impl.DAGFormulaManager;
import kd.tmc.fpm.business.spread.generator.SpreadDataGeneratorFactory;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.business.spread.generator.executor.ReportDataProcessExecutorFactory;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Sheet;
import org.apache.commons.collections4.MapUtils;

public class SumPlanFormsExportImpl
extends AbsReportFormsExportExcel {
    private static Log logger = LogFactory.getLog(SumPlanFormsExportImpl.class);
    private ISumPlanBizService sumPlanBizService = new SumPlanBizServiceImpl();
    private IAnalysisReportBizService analysisReportBizService;
    private IDimensionRepository dimRepo = new DimensionRepository();
    private ITemplateRepository templateRepository = new TemplateRepository();
    private IAnalysisReportManageService analysisReportManageService = new AnalysisReportManagerService();
    private Set<Long> reportIds;
    private Report report;
    private FundPlanSystem system;
    private Map<Long, Map<Long, AnalysisHeader>> headerMap;
    private Map<Long, SumPlanHeader> reportHeaderMap;
    private Map<Long, List<SumPlanReportExportModel>> sumPlanReportExportMap;
    private Map<Long, List<Long>> pageDimMemberIdMap;
    private Map<Long, String> reportOrgMap;

    public SumPlanFormsExportImpl(Set<Long> reportIds, Map<Long, SumPlanHeader> reportHeaderMap, Map<Long, Map<Long, AnalysisHeader>> headerMap, Map<Long, List<Long>> pageDimMemberIdMap) {
        this.reportIds = reportIds;
        this.analysisReportBizService = new AnalysisReportBizService();
        this.headerMap = headerMap;
        this.reportHeaderMap = reportHeaderMap;
        this.pageDimMemberIdMap = pageDimMemberIdMap;
    }

    @Override
    protected void getOriginalData() {
        HashMap<Long, List<SumPlanReportExportModel>> sumPlanReportExportMap = new HashMap<Long, List<SumPlanReportExportModel>>(this.reportIds.size());
        HashMap<Long, String> reportOrgNameMap = new HashMap<Long, String>(this.reportIds.size());
        for (Long reportId : this.reportIds) {
            List<ReportCalcModel> reportCalcModelList;
            FpmOperateResult<SumPlanRecord> reportFpmOperateResult;
            ArrayList<SumPlanReportExportModel> sumPlanReportExportModels = new ArrayList<SumPlanReportExportModel>(this.reportIds.size());
            SumPlanRecord sumPlanRecord = this.sumPlanBizService.load(reportId);
            if (this.system == null) {
                this.system = this.dimRepo.loadSystem(sumPlanRecord.getSystemId());
            }
            if (!(reportFpmOperateResult = this.sumPlanBizService.load(reportId, this.system, this.reportHeaderMap.get(reportId))).isSuccess()) {
                List<String> messageList = reportFpmOperateResult.getMessageList();
                String errMsg = messageList.stream().filter(Objects::nonNull).collect(Collectors.joining("\u3001"));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6c47\u603b\u7f16\u5236\u62a5\u8868\u6570\u636e\u5f02\u5e38: %1$s", (String)"SumPlanFormsExportImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), errMsg));
            }
            SumPlanReport sumPlanReport = reportFpmOperateResult.getData().getSumPlanReportList().get(0);
            IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getSumPlanReportExecutorOfExport(this.system, sumPlanReport, null);
            ReportModel reportModel = new ReportModel();
            reportExecutor.executeAction(reportModel);
            if (EmptyUtil.isNoEmpty((Object)reportModel) && EmptyUtil.isNoEmpty(reportCalcModelList = reportModel.getReportCalcModelList().stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
                SumPlanReportExportModel model = new SumPlanReportExportModel(reportCalcModelList, sumPlanReport);
                sumPlanReportExportModels.add(model);
            }
            reportOrgNameMap.put(reportId, sumPlanReport.getCompanyMemberList().get(0).getName());
            List<Long> attachtplIdList = sumPlanRecord.getAttachtplIdList();
            Map<Long, AnalysisHeader> headerInfo = this.headerMap.get(reportId);
            if (MapUtils.isNotEmpty(headerInfo)) {
                for (Long templateId : attachtplIdList) {
                    List<ReportCalcModel> reportCalcModelList2;
                    AnalysisHeader header = headerInfo.get(templateId);
                    ReportTemplate analysisTemplate = this.templateRepository.loadTemplateBak(templateId);
                    if (analysisTemplate.getTemplateType() == TemplateType.FIXED) {
                        ReportTemplate reportTemplate = sumPlanReport.getTemplate();
                        List<TemplateReportType> reportTypeList = reportTemplate.getReportTypeList();
                        for (TemplateReportType templateReportType : reportTypeList) {
                            templateReportType.setAuxiliaryFieldList(Collections.emptyList());
                        }
                        analysisTemplate.setReportTypeList(reportTemplate.getReportTypeList());
                    }
                    FpmOperateResult<Tuple<ReportModel, Report>> reportModelFpmOperateResult = this.analysisReportManageService.loadAnalysisReportModelForExport(analysisTemplate, header);
                    Tuple<ReportModel, Report> resultData = reportModelFpmOperateResult.getData();
                    reportModel = (ReportModel)resultData.item1;
                    if (!EmptyUtil.isNoEmpty((Object)reportModel) || !EmptyUtil.isNoEmpty(reportCalcModelList2 = reportModel.getReportCalcModelList().stream().filter(Objects::nonNull).collect(Collectors.toList()))) continue;
                    SumPlanReportExportModel model = new SumPlanReportExportModel(reportCalcModelList2, (Report)resultData.item2);
                    sumPlanReportExportModels.add(model);
                }
            }
            this.report = sumPlanReport;
            sumPlanReportExportMap.put(reportId, sumPlanReportExportModels);
        }
        this.sumPlanReportExportMap = sumPlanReportExportMap;
        this.reportOrgMap = reportOrgNameMap;
    }

    @Override
    protected String exportParamsPrepare(Map<String, Sheet> sheetMap) {
        Optional<List> sumPlanReportExportOptional = this.sumPlanReportExportMap.values().stream().filter(EmptyUtil::isNoEmpty).findFirst();
        if (!sumPlanReportExportOptional.isPresent()) {
            return String.format(ResManager.loadKDString((String)"\u7a7a\u62a5\u8868_%1$s.xlsx", (String)"SumPlanFormsExportImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), DateUtils.formatString((Date)new Date(), (String)"yyyyMMdd"));
        }
        String excelName = String.format("%s_%s.xlsx", this.report.getCompanyMemberList().get(0).getName(), this.report.getPeriodMemberList().get(0).getName());
        for (Map.Entry<Long, List<SumPlanReportExportModel>> entry : this.sumPlanReportExportMap.entrySet()) {
            Long reportId = entry.getKey();
            List<SumPlanReportExportModel> sumPlanReportExportModels = entry.getValue();
            int j = 1;
            int k = 1;
            for (SumPlanReportExportModel sumPlanReportExportModel : sumPlanReportExportModels) {
                Report report = sumPlanReportExportModel.getReport();
                List<ReportCalcModel> reportCalcModels = sumPlanReportExportModel.getReportCalcModels();
                ReportTemplate template = report.getTemplate();
                for (ReportCalcModel calcModel : reportCalcModels) {
                    String pageDimStr = calcModel.getPageDimValList().stream().map(ReportCalcVal::getDisplayVal).collect(Collectors.joining("_"));
                    String sheetName = EmptyUtil.isEmpty((String)pageDimStr) ? String.format("%s)%s_%s_%s", j++, this.reportOrgMap.get(reportId), template.getName(), k++) : String.format("%s)%s_%s_%s", j++, report.getCompanyMemberList().get(0).getName(), template.getName(), pageDimStr);
                    new DAGFormulaManager(calcModel, null);
                    if (template.getTemplateUse() == TemplateUseType.SUMMARY) {
                        SumPlanHeaderHelper.addExcelReportHeader(report, this.system, calcModel);
                    } else if (template.getTemplateUse() == TemplateUseType.ANALYSIS) {
                        Map<Long, AnalysisHeader> headerInfo = this.headerMap.get(reportId);
                        AnalysisHeader analysisHeader = headerInfo.get(template.getId());
                        SumPlanAnalysisReportHeaderHelper.addExcelReportHeader(report, calcModel, this.system, analysisHeader);
                    }
                    Book book = SpreadDataGeneratorFactory.createReportDataGenerator().generate(calcModel);
                    sheetMap.put(sheetName, book.getSheet());
                }
            }
        }
        return excelName;
    }

    private static class SumPlanReportExportModel {
        private List<ReportCalcModel> reportCalcModels;
        private Report report;

        public SumPlanReportExportModel(List<ReportCalcModel> reportCalcModels, Report report) {
            this.reportCalcModels = reportCalcModels;
            this.report = report;
        }

        public List<ReportCalcModel> getReportCalcModels() {
            return this.reportCalcModels;
        }

        public Report getReport() {
            return this.report;
        }
    }
}

