/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.spread.export.utils.HeaderCreateHelper;

public class ExecBiasPlanHeaderHelper
extends HeaderCreateHelper {
    public static void addExcelReportHeader(Report report, SumPlanRecord record, FundPlanSystem system, ReportCalcModel currReportCalcModel) {
        String[] headers = ExecBiasPlanHeaderHelper.getHeaders(report.getReportPlanType());
        if (report.getReportPlanType() == ReportPlanType.REPORTPLAN) {
            ReportTemplate template = report.getTemplate();
            ReportValueType valType = ExecBiasPlanHeaderHelper.getValType(ReportCellType.TEXT, null);
            ArrayList<ReportCalcVal> headerDescCalcVals = new ArrayList<ReportCalcVal>(headers.length);
            for (int i = 0; i < headers.length; ++i) {
                headerDescCalcVals.add(ExecBiasPlanHeaderHelper.createCalcVal(headers[i], valType, 0, i, false));
            }
            int row = 1;
            int col = 0;
            ArrayList<ReportCalcVal> headerValCalcVals = new ArrayList<ReportCalcVal>(headers.length);
            col = ExecBiasPlanHeaderHelper.baseHeaderCreate(report, template, valType, row, col, headerValCalcVals);
            col = ExecBiasPlanHeaderHelper.createMetricHeader(system, template, valType, row, col, headerValCalcVals);
            ExecBiasPlanHeaderHelper.fillData(report, null, system, currReportCalcModel, valType, headerDescCalcVals, row, col, headerValCalcVals);
        } else {
            SumPlanReport rep = (SumPlanReport)report;
            ReportTemplate template = rep.getTemplate();
            ReportValueType valType = ExecBiasPlanHeaderHelper.getValType(ReportCellType.TEXT, null);
            ArrayList<ReportCalcVal> headerDescCalcVals = new ArrayList<ReportCalcVal>(headers.length);
            for (int i = 0; i < headers.length; ++i) {
                headerDescCalcVals.add(ExecBiasPlanHeaderHelper.createCalcVal(headers[i], valType, 0, i, false));
            }
            int row = 1;
            int col = 0;
            ArrayList<ReportCalcVal> headerValCalcVals = new ArrayList<ReportCalcVal>(headers.length);
            col = ExecBiasPlanHeaderHelper.baseHeaderCreate(report, template, valType, row, col, headerValCalcVals);
            boolean innerOffset = rep.isInnerOffset();
            String innerOffsetName = innerOffset ? ResManager.loadKDString((String)"\u62b5\u6d88\u540e", (String)"SumPlanReportFormsExportAction_11", (String)"tmc-fpm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u62b5\u6d88\u524d", (String)"SumPlanReportFormsExportAction_12", (String)"tmc-fpm-business", (Object[])new Object[0]);
            ReportCalcVal innerOffsetCalcVal = ExecBiasPlanHeaderHelper.createCalcVal(innerOffsetName, valType, row, col++, true);
            headerValCalcVals.add(innerOffsetCalcVal);
            col = ExecBiasPlanHeaderHelper.createMetricHeader(system, template, valType, row, col, headerValCalcVals);
            ExecBiasPlanHeaderHelper.fillData(report, record, system, currReportCalcModel, valType, headerDescCalcVals, row, col, headerValCalcVals);
        }
    }

    private static int createMetricHeader(FundPlanSystem system, ReportTemplate template, ReportValueType valType, int row, int col, List<ReportCalcVal> headerValCalcVals) {
        List<Long> metricMemberIds = template.getMetricTplDim().getMemberScope();
        Dimension metricDim = system.getMainDimensionByDimType(DimensionType.METRIC);
        HashSet<Long> idSet = new HashSet<Long>(metricMemberIds);
        String metricNames = metricDim.getAllDimMemberList().stream().filter(i -> idSet.contains(i.getId())).map(DimMember::getName).collect(Collectors.joining(","));
        ReportCalcVal metricMemberVal = ExecBiasPlanHeaderHelper.createCalcVal(metricNames, valType, row, col++, true);
        headerValCalcVals.add(metricMemberVal);
        return col;
    }

    private static int baseHeaderCreate(Report report, ReportTemplate template, ReportValueType valType, int row, int col, List<ReportCalcVal> headerValCalcVals) {
        ReportCalcVal reportNameCalcVal = ExecBiasPlanHeaderHelper.createCalcVal(report.getName(), valType, row, col++, true);
        headerValCalcVals.add(reportNameCalcVal);
        boolean mainTable = template.isMainTable();
        String reportTypeStr = mainTable ? ResManager.loadKDString((String)"\u4e3b\u8868", (String)"PlanReportFormsExportAction_8", (String)"tmc-fpm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b50\u8868", (String)"PlanReportFormsExportAction_9", (String)"tmc-fpm-business", (Object[])new Object[0]);
        ReportCalcVal reportTypeCalcVal = ExecBiasPlanHeaderHelper.createCalcVal(reportTypeStr, valType, row, col++, true);
        headerValCalcVals.add(reportTypeCalcVal);
        List<OrgMember> companyMemberLst = report.getCompanyMemberList();
        String mainBody = "-";
        if (EmptyUtil.isNoEmpty(companyMemberLst)) {
            mainBody = companyMemberLst.get(0).getName();
        }
        ReportCalcVal mainBodyCalcVal = ExecBiasPlanHeaderHelper.createCalcVal(mainBody, valType, row, col++, true);
        headerValCalcVals.add(mainBodyCalcVal);
        List<PeriodMember> periodMemberLst = report.getPeriodMemberList();
        String periodStr = "-";
        if (EmptyUtil.isNoEmpty(periodMemberLst)) {
            periodStr = periodMemberLst.get(0).getName();
        }
        ReportCalcVal periodCalcVal = ExecBiasPlanHeaderHelper.createCalcVal(periodStr, valType, row, col++, true);
        headerValCalcVals.add(periodCalcVal);
        String informant = report.getInformanStr();
        ReportCalcVal informantCalcVal = ExecBiasPlanHeaderHelper.createCalcVal(informant, valType, row, col++, true);
        headerValCalcVals.add(informantCalcVal);
        String amountUnit = template.getAmountUnit().getName();
        ReportCalcVal amountUnitCalcVal = ExecBiasPlanHeaderHelper.createCalcVal(amountUnit, valType, row, col++, true);
        headerValCalcVals.add(amountUnitCalcVal);
        String status = String.format("%s/%s", report.getProcessStatus().getName(), report.getReportStatus().getName());
        ReportCalcVal statusCalcVal = ExecBiasPlanHeaderHelper.createCalcVal(status, valType, row, col++, true);
        headerValCalcVals.add(statusCalcVal);
        return col;
    }

    private static void fillData(Report report, SumPlanRecord record, FundPlanSystem system, ReportCalcModel currReportCalcModel, ReportValueType valType, List<ReportCalcVal> headerDescCalcVals, int row, int col, List<ReportCalcVal> headerValCalcVals) {
        ArrayList<ReportCalcVal> tempHeaderDescCalcValLst = new ArrayList<ReportCalcVal>(headerDescCalcVals);
        ArrayList<ReportCalcVal> tempHeaderValCalcValLst = new ArrayList<ReportCalcVal>(headerValCalcVals);
        Optional<Dimension> orgOP = ExecBiasPlanHeaderHelper.seekDim(DimensionType.ORG, system);
        List<ReportCalcVal> pageDims = currReportCalcModel.getPageDimValList();
        if (EmptyUtil.isNoEmpty(pageDims)) {
            for (ReportCalcVal pageDim : pageDims) {
                if (orgOP.isPresent() && record == null && orgOP.get().getId().equals(pageDim.getDimensionId())) continue;
                tempHeaderDescCalcValLst.add(ExecBiasPlanHeaderHelper.createCalcVal(pageDim.getDimensionName(), valType, 0, col, false));
                tempHeaderValCalcValLst.add(ExecBiasPlanHeaderHelper.createCalcVal(pageDim.getDisplayVal(), valType, 1, col, true));
                ++col;
            }
        }
        tempHeaderDescCalcValLst.add(ExecBiasPlanHeaderHelper.createCalcVal(ResManager.loadKDString((String)"\u6298\u7b97\u5e01", (String)"PlanReportFormsExportAction_10", (String)"tmc-fpm-business", (Object[])new Object[0]), valType, 0, col, false));
        String currencyName = system.getCurrencyName();
        ReportCalcVal currencyNameVal = ExecBiasPlanHeaderHelper.createCalcVal(currencyName, valType, row, col, true);
        tempHeaderValCalcValLst.add(currencyNameVal);
        tempHeaderDescCalcValLst.add(ExecBiasPlanHeaderHelper.createCalcVal(ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u7801", (String)"ExecBiasPlanHeaderHelper_0", (String)"tmc-fpm-business", (Object[])new Object[0]), valType, 0, ++col, false));
        if (Objects.nonNull(record)) {
            tempHeaderValCalcValLst.add(ExecBiasPlanHeaderHelper.createCalcVal(record.getNumber(), valType, row, col, true));
        } else {
            tempHeaderValCalcValLst.add(ExecBiasPlanHeaderHelper.createCalcVal(report.getNumber(), valType, row, col, true));
        }
        List<ReportCalcVal> extValList = currReportCalcModel.getExtValList();
        if (EmptyUtil.isEmpty(extValList)) {
            extValList = new ArrayList<ReportCalcVal>(10);
        }
        extValList.forEach(o -> o.setRow(o.getRow() + 3));
        extValList.addAll(tempHeaderDescCalcValLst);
        currReportCalcModel.setExtValList(extValList);
        List<ReportCalcVal> dataValList = currReportCalcModel.getDataValList();
        dataValList.forEach(o -> o.setRow(o.getRow() + 3));
        dataValList.addAll(tempHeaderValCalcValLst);
        List<ReportCalcVal> rowDimValList = currReportCalcModel.getRowDimValList();
        rowDimValList.forEach(o -> o.setRow(o.getRow() + 3));
        List<ReportCalcVal> colDimValList = currReportCalcModel.getColDimValList();
        colDimValList.forEach(o -> o.setRow(o.getRow() + 3));
    }

    private static String[] getHeaders(ReportPlanType type) {
        if (type == ReportPlanType.REPORTPLAN) {
            return new String[]{ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"PlanReportFormsExportAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b", (String)"PlanReportFormsExportAction_1", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7f16\u62a5\u4e3b\u4f53", (String)"PlanReportFormsExportAction_2", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7f16\u62a5\u671f\u95f4", (String)"PlanReportFormsExportAction_3", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u586b\u62a5\u4eba", (String)"PlanReportFormsExportAction_4", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91d1\u989d\u5355\u4f4d", (String)"PlanReportFormsExportAction_5", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u72b6\u6001", (String)"PlanReportFormsExportAction_6", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u6790\u6307\u6807", (String)"PlanReportFormsExportAction_7", (String)"tmc-fpm-business", (Object[])new Object[0])};
        }
        return new String[]{ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"SumPlanReportFormsExportAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b", (String)"SumPlanReportFormsExportAction_1", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53", (String)"SumPlanReportFormsExportAction_2", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7f16\u62a5\u671f\u95f4", (String)"SumPlanReportFormsExportAction_3", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u586b\u62a5\u4eba", (String)"SumPlanReportFormsExportAction_4", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91d1\u989d\u5355\u4f4d", (String)"SumPlanReportFormsExportAction_5", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u72b6\u6001", (String)"SumPlanReportFormsExportAction_6", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u62b5\u6d88\u72b6\u6001", (String)"SumPlanReportFormsExportAction_7", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u6790\u6307\u6807", (String)"SumPlanReportFormsExportAction_8", (String)"tmc-fpm-business", (Object[])new Object[0])};
    }
}

