/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.spread.widget.DisplayTypeEnum;

public class HeaderCreateHelper {
    public static final Integer HEADER_OFFSET_NUM = 3;

    protected static ReportCalcVal createCalcVal(Object value, ReportValueType type, int row, int col, boolean isEnable) {
        ReportCalcVal calcVal = new ReportCalcVal();
        calcVal.setRow(row);
        calcVal.setCol(col);
        calcVal.setValue(value);
        calcVal.setEnable(isEnable);
        calcVal.setSummary(false);
        calcVal.setRemarkCell(false);
        calcVal.setDataCell(false);
        calcVal.setValueType(type);
        calcVal.setDisplayVal(Optional.ofNullable(value).map(Object::toString).orElse("-"));
        calcVal.setRowSpan(1);
        calcVal.setColSpan(1);
        calcVal.setDisplayType(DisplayTypeEnum.NORMAR);
        return calcVal;
    }

    protected static ReportValueType getValType(ReportCellType cellType, Object val) {
        ReportValueType valType = new ReportValueType();
        valType.setValue(val);
        valType.setReportCellType(cellType);
        return valType;
    }

    protected static Optional<Dimension> seekDim(DimensionType dimType, FundPlanSystem system) {
        return system.getDimList().stream().filter(Objects::nonNull).filter(dim -> dim.getDimType() == dimType).findAny();
    }

    protected static Optional<Dimension> seekCustomDim(String customNumber, FundPlanSystem system) {
        return system.getDimList().stream().filter(Objects::nonNull).filter(dim -> dim.getNumber().equals(customNumber)).findAny();
    }

    protected static String getMemberStr(List<Long> memberIds, Map<Long, DimMember> dimMemberMap) {
        return memberIds.stream().filter(Objects::nonNull).map(dimMemberMap::get).map(DimMember::getName).collect(Collectors.joining(","));
    }

    protected static void addCustomCalcVals(List<ReportCalcVal> headerDescCalcVals, List<ReportCalcVal> headerValCalcVals, Integer row, Integer col, FundPlanSystem system, AnalysisHeader headerInfo, Map<Long, DimMember> dimMemberMap) {
        List customDimensions = system.getDimList().stream().filter(Objects::nonNull).filter(dim -> dim.getDimType() == DimensionType.CUSTOM).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(customDimensions)) {
            return;
        }
        ReportValueType textType = HeaderCreateHelper.getValType(ReportCellType.TEXT, null);
        for (Dimension customDimension : customDimensions) {
            String number = customDimension.getNumber();
            List<Long> memberIdList = HeaderCreateHelper.getCustomMemberList(headerInfo.getCustomDimension(), number);
            headerDescCalcVals.add(HeaderCreateHelper.createCalcVal(customDimension.getName(), textType, 0, headerDescCalcVals.size(), false));
            String memberStr = "-";
            if (EmptyUtil.isNoEmpty(memberIdList)) {
                memberStr = HeaderCreateHelper.getMemberStr(memberIdList, dimMemberMap);
            }
            Integer n = col;
            Integer n2 = col = Integer.valueOf(col + 1);
            ReportCalcVal settlementCalcVal = HeaderCreateHelper.createCalcVal(memberStr, textType, row, n, true);
            headerValCalcVals.add(settlementCalcVal);
        }
    }

    protected static List<Long> getCustomMemberList(Map<String, List<Long>> customDimension, String number) {
        if (EmptyUtil.isEmpty(customDimension)) {
            return Collections.emptyList();
        }
        if (!customDimension.containsKey(number)) {
            return Collections.emptyList();
        }
        return customDimension.get(number);
    }
}

