/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.spread.export.utils.HeaderCreateHelper;

public class ReportPlanHeaderHelper
extends HeaderCreateHelper {
    private static final String[] REPORT_PLAN_HEADER = new String[]{ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"PlanReportFormsExportAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b", (String)"PlanReportFormsExportAction_1", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7f16\u62a5\u4e3b\u4f53", (String)"PlanReportFormsExportAction_2", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7f16\u62a5\u671f\u95f4", (String)"PlanReportFormsExportAction_3", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u586b\u62a5\u4eba", (String)"PlanReportFormsExportAction_4", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91d1\u989d\u5355\u4f4d", (String)"PlanReportFormsExportAction_5", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u72b6\u6001", (String)"PlanReportFormsExportAction_6", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u6790\u6307\u6807", (String)"PlanReportFormsExportAction_7", (String)"tmc-fpm-business", (Object[])new Object[0])};

    public static void addExcelReportHeader(Report report, FundPlanSystem system, ReportCalcModel currReportCalcModel) {
        ReportTemplate template = report.getTemplate();
        ReportValueType valType = ReportPlanHeaderHelper.getValType(ReportCellType.TEXT, null);
        ArrayList<ReportCalcVal> headerDescCalcVals = new ArrayList<ReportCalcVal>(REPORT_PLAN_HEADER.length);
        for (int i = 0; i < REPORT_PLAN_HEADER.length; ++i) {
            headerDescCalcVals.add(ReportPlanHeaderHelper.createCalcVal(REPORT_PLAN_HEADER[i], valType, 0, i, false));
        }
        int row = 1;
        int col = 0;
        ArrayList<ReportCalcVal> headerValCalcVals = new ArrayList<ReportCalcVal>(REPORT_PLAN_HEADER.length);
        ReportCalcVal reportNameCalcVal = ReportPlanHeaderHelper.createCalcVal(report.getName(), valType, row, col++, true);
        headerValCalcVals.add(reportNameCalcVal);
        boolean mainTable = template.isMainTable();
        String reportTypeStr = mainTable ? ResManager.loadKDString((String)"\u4e3b\u8868", (String)"PlanReportFormsExportAction_8", (String)"tmc-fpm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b50\u8868", (String)"PlanReportFormsExportAction_9", (String)"tmc-fpm-business", (Object[])new Object[0]);
        ReportCalcVal reportTypeCalcVal = ReportPlanHeaderHelper.createCalcVal(reportTypeStr, valType, row, col++, true);
        headerValCalcVals.add(reportTypeCalcVal);
        List<OrgMember> companyMemberLst = report.getCompanyMemberList();
        String mainBody = "-";
        if (EmptyUtil.isNoEmpty(companyMemberLst)) {
            mainBody = companyMemberLst.get(0).getName();
        }
        ReportCalcVal mainBodyCalcVal = ReportPlanHeaderHelper.createCalcVal(mainBody, valType, row, col++, true);
        headerValCalcVals.add(mainBodyCalcVal);
        List<PeriodMember> periodMemberLst = report.getPeriodMemberList();
        String periodStr = "-";
        if (EmptyUtil.isNoEmpty(periodMemberLst)) {
            periodStr = periodMemberLst.get(0).getName();
        }
        ReportCalcVal periodCalcVal = ReportPlanHeaderHelper.createCalcVal(periodStr, valType, row, col++, true);
        headerValCalcVals.add(periodCalcVal);
        String informant = report.getInformanStr();
        ReportCalcVal informantCalcVal = ReportPlanHeaderHelper.createCalcVal(informant, valType, row, col++, true);
        headerValCalcVals.add(informantCalcVal);
        String amountUnit = template.getAmountUnit().getName();
        ReportCalcVal amountUnitCalcVal = ReportPlanHeaderHelper.createCalcVal(amountUnit, valType, row, col++, true);
        headerValCalcVals.add(amountUnitCalcVal);
        String status = String.format("%s/%s", report.getProcessStatus().getName(), report.getReportStatus().getName());
        ReportCalcVal statusCalcVal = ReportPlanHeaderHelper.createCalcVal(status, valType, row, col++, true);
        headerValCalcVals.add(statusCalcVal);
        List<Long> metricMemberIds = template.getMetricTplDim().getMemberScope();
        DynamicObject[] metricMembers = TmcDataServiceHelper.load((String)"fpm_member", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", metricMemberIds)});
        List metricMemberNames = Arrays.stream(metricMembers).map(c -> c.getString("name")).collect(Collectors.toList());
        ReportCalcVal metricMemberVal = ReportPlanHeaderHelper.createCalcVal(String.join((CharSequence)",", metricMemberNames), valType, row, col++, true);
        headerValCalcVals.add(metricMemberVal);
        ArrayList<ReportCalcVal> tempHeaderDescCalcValLst = new ArrayList<ReportCalcVal>(headerDescCalcVals);
        ArrayList<ReportCalcVal> tempHeaderValCalcValLst = new ArrayList<ReportCalcVal>(headerValCalcVals);
        Optional<Dimension> orgOP = ReportPlanHeaderHelper.seekDim(DimensionType.ORG, system);
        List<ReportCalcVal> pageDims = currReportCalcModel.getPageDimValList();
        if (EmptyUtil.isNoEmpty(pageDims)) {
            for (ReportCalcVal pageDim : pageDims) {
                if (orgOP.isPresent() && orgOP.get().getId().equals(pageDim.getDimensionId())) continue;
                tempHeaderDescCalcValLst.add(ReportPlanHeaderHelper.createCalcVal(pageDim.getDimensionName(), valType, 0, col, false));
                tempHeaderValCalcValLst.add(ReportPlanHeaderHelper.createCalcVal(pageDim.getDisplayVal(), valType, 1, col, true));
                ++col;
            }
        }
        tempHeaderDescCalcValLst.add(ReportPlanHeaderHelper.createCalcVal(ResManager.loadKDString((String)"\u6298\u7b97\u5e01", (String)"PlanReportFormsExportAction_10", (String)"tmc-fpm-business", (Object[])new Object[0]), valType, 0, col, false));
        String currencyName = system.getCurrencyName();
        ReportCalcVal currencyNameVal = ReportPlanHeaderHelper.createCalcVal(currencyName, valType, row, col, true);
        tempHeaderValCalcValLst.add(currencyNameVal);
        List<ReportCalcVal> extValList = currReportCalcModel.getExtValList();
        if (EmptyUtil.isEmpty(extValList)) {
            extValList = new ArrayList<ReportCalcVal>(10);
        }
        extValList.forEach(o -> o.setRow(o.getRow() + HEADER_OFFSET_NUM));
        extValList.addAll(tempHeaderDescCalcValLst);
        currReportCalcModel.setExtValList(extValList);
        List<ReportCalcVal> dataValList = currReportCalcModel.getDataValList();
        dataValList.forEach(o -> o.setRow(o.getRow() + HEADER_OFFSET_NUM));
        dataValList.addAll(tempHeaderValCalcValLst);
        List<ReportCalcVal> rowDimValList = currReportCalcModel.getRowDimValList();
        rowDimValList.forEach(o -> o.setRow(o.getRow() + HEADER_OFFSET_NUM));
        List<ReportCalcVal> colDimValList = currReportCalcModel.getColDimValList();
        colDimValList.forEach(o -> o.setRow(o.getRow() + HEADER_OFFSET_NUM));
    }
}

