/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.InternalOffsetStateType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.spread.export.utils.HeaderCreateHelper;
import kd.tmc.fpm.common.enums.BillStatusEnum;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;

public class ReportPlanSearchHeaderHelper
extends HeaderCreateHelper {
    /*
     * WARNING - void declaration
     */
    public static void addExcelReportHeader(AnalysisHeader headerInfo, FundPlanSystem system, ReportCalcModel currReportCalcModel, FormShowParameter viewParameter) {
        void var40_51;
        ReportValueType textType = ReportPlanSearchHeaderHelper.getValType(ReportCellType.TEXT, null);
        Map<Long, DimMember> dimMemberMap = system.getDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        ArrayList<String> HEADER = new ArrayList<String>(){
            {
                this.add(ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"ReportPlanSearchHeaderHelper_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
                this.add(ResManager.loadKDString((String)"\u671f\u95f4", (String)"ReportPlanSearchHeaderHelper_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
                this.add(ResManager.loadKDString((String)"\u7f16\u62a5\u4e3b\u4f53", (String)"ReportPlanSearchHeaderHelper_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
                this.add(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"ReportPlanSearchHeaderHelper_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
                this.add(ResManager.loadKDString((String)"\u62a5\u544a\u5e01", (String)"ReportPlanSearchHeaderHelper_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
                this.add(ResManager.loadKDString((String)"\u8ba1\u5212\u79d1\u76ee", (String)"ReportPlanSearchHeaderHelper_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
                this.add(ResManager.loadKDString((String)"\u6c47\u7387\u8868", (String)"ReportPlanSearchHeaderHelper_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
                this.add(ResManager.loadKDString((String)"\u6c47\u7387\u65e5\u671f", (String)"ReportPlanSearchHeaderHelper_7", (String)"tmc-fpm-business", (Object[])new Object[0]));
                this.add(ResManager.loadKDString((String)"\u91d1\u989d\u5355\u4f4d", (String)"ReportPlanSearchHeaderHelper_8", (String)"tmc-fpm-business", (Object[])new Object[0]));
                this.add(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"ReportPlanSearchHeaderHelper_9", (String)"tmc-fpm-business", (Object[])new Object[0]));
                this.add(ResManager.loadKDString((String)"\u8ba1\u5212\u72b6\u6001", (String)"ReportPlanSearchHeaderHelper_10", (String)"tmc-fpm-business", (Object[])new Object[0]));
                this.add(ResManager.loadKDString((String)"\u62b5\u6d88\u72b6\u6001", (String)"ReportPlanSearchHeaderHelper_11", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
        };
        ArrayList<ReportCalcVal> headerDescCalcVals = new ArrayList<ReportCalcVal>(HEADER.size());
        for (int i = 0; i < HEADER.size(); ++i) {
            headerDescCalcVals.add(ReportPlanSearchHeaderHelper.createCalcVal(HEADER.get(i), textType, 0, i, false));
        }
        int row = 1;
        int col = 0;
        ArrayList<ReportCalcVal> headerValCalcVals = new ArrayList<ReportCalcVal>(HEADER.size());
        ReportCalcVal systemCalcVal = ReportPlanSearchHeaderHelper.createCalcVal(system.getName(), textType, row, col++, true);
        headerValCalcVals.add(systemCalcVal);
        List<Long> periodId = headerInfo.getPeriodId();
        String periodStr = "-";
        if (EmptyUtil.isNoEmpty(periodId)) {
            periodStr = ReportPlanSearchHeaderHelper.getMemberStr(periodId, dimMemberMap);
        }
        ReportCalcVal periodCalcVal = ReportPlanSearchHeaderHelper.createCalcVal(periodStr, textType, row, col++, true);
        headerValCalcVals.add(periodCalcVal);
        List<Long> org = headerInfo.getOrg();
        String mainBody = "-";
        if (EmptyUtil.isNoEmpty(org)) {
            mainBody = ReportPlanSearchHeaderHelper.getMemberStr(org, dimMemberMap);
        }
        ReportCalcVal mainBodyCalcVal = ReportPlanSearchHeaderHelper.createCalcVal(mainBody, textType, row, col++, true);
        headerValCalcVals.add(mainBodyCalcVal);
        List<Long> currencyIds = headerInfo.getCurrency();
        String currencyStr = "-";
        if (EmptyUtil.isNoEmpty(currencyIds)) {
            currencyStr = ReportPlanSearchHeaderHelper.getMemberStr(currencyIds, dimMemberMap);
        }
        ReportCalcVal currencyCalcVal = ReportPlanSearchHeaderHelper.createCalcVal(currencyStr, textType, row, col++, true);
        headerValCalcVals.add(currencyCalcVal);
        String currencyName = system.getCurrencyName();
        ReportCalcVal currencyNameVal = ReportPlanSearchHeaderHelper.createCalcVal(currencyName, textType, row, col++, true);
        headerValCalcVals.add(currencyNameVal);
        List<Long> acctIds = headerInfo.getSubjects();
        String acctInfoStr = "-";
        if (EmptyUtil.isNoEmpty(acctIds)) {
            acctInfoStr = ReportPlanSearchHeaderHelper.getMemberStr(acctIds, dimMemberMap);
        }
        ReportCalcVal acctInfoCalcVal = ReportPlanSearchHeaderHelper.createCalcVal(acctInfoStr, textType, row, col++, true);
        headerValCalcVals.add(acctInfoCalcVal);
        Long exchangeRateTableId = headerInfo.getExchangeRateTableId();
        String exchangeRateTableStr = "-";
        if (EmptyUtil.isNoEmpty((Long)exchangeRateTableId)) {
            DynamicObject exchangeRateTable = QueryServiceHelper.queryOne((String)"bd_exratetable", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)exchangeRateTableId)});
            exchangeRateTableStr = Optional.ofNullable(exchangeRateTable).map(o -> o.getString("name")).orElseGet(() -> "-");
        }
        ReportCalcVal exchangeRateTableCalcVal = ReportPlanSearchHeaderHelper.createCalcVal(exchangeRateTableStr, textType, row, col++, true);
        headerValCalcVals.add(exchangeRateTableCalcVal);
        Date exchangeRateDate = headerInfo.getExchangeRateDate();
        String exchangeRateDateStr = Optional.ofNullable(exchangeRateDate).map(o -> DateUtils.formatString((Date)o, (String)"yyyy-MM-dd")).orElseGet(() -> "-");
        ReportCalcVal exchangeRateDateCalcVal = ReportPlanSearchHeaderHelper.createCalcVal(exchangeRateDateStr, textType, row, col++, true);
        headerValCalcVals.add(exchangeRateDateCalcVal);
        AmountUnit amountUnit = headerInfo.getAmountUnit();
        ReportCalcVal amountUnitCalcVal = ReportPlanSearchHeaderHelper.createCalcVal(amountUnit.getName(), textType, row, col++, true);
        headerValCalcVals.add(amountUnitCalcVal);
        StringBuilder exportBillStr = new StringBuilder();
        String billStatusStr = (String)viewParameter.getCustomParam("billstatus");
        if (!StringUtils.isEmpty((String)billStatusStr)) {
            String[] split;
            for (String string : split = billStatusStr.split(",")) {
                BillStatusEnum byCode = BillStatusEnum.getByCode((String)string);
                if (byCode == null) continue;
                exportBillStr.append(byCode.getName().loadKDString()).append(",");
            }
            if (exportBillStr.length() > 0) {
                exportBillStr.deleteCharAt(exportBillStr.length() - 1);
            }
        } else {
            exportBillStr = new StringBuilder("-");
        }
        ReportCalcVal billStatus = ReportPlanSearchHeaderHelper.createCalcVal(exportBillStr.toString(), textType, row, col++, true);
        headerValCalcVals.add(billStatus);
        StringBuilder exportPlanStatusStr = new StringBuilder();
        String planStatusStr = (String)viewParameter.getCustomParam("planstatus");
        if (!StringUtils.isEmpty((String)planStatusStr)) {
            String[] split;
            for (String planStatus : split = planStatusStr.split(",")) {
                String name = ReportPlanStatusEnum.getName((String)planStatus);
                if (StringUtils.isEmpty((String)name)) continue;
                exportPlanStatusStr.append(name).append(",");
            }
            if (exportPlanStatusStr.length() > 0) {
                exportPlanStatusStr.deleteCharAt(exportPlanStatusStr.length() - 1);
            }
        } else {
            exportPlanStatusStr = new StringBuilder("-");
        }
        ReportCalcVal planStatus = ReportPlanSearchHeaderHelper.createCalcVal(exportPlanStatusStr, textType, row, col++, true);
        headerValCalcVals.add(planStatus);
        String string = (String)viewParameter.getCustomParam("internaloffsetstate");
        if (!StringUtils.isEmpty((String)string)) {
            InternalOffsetStateType offsetStateType = InternalOffsetStateType.getByNumber(string.replaceAll(",", ""));
            if (offsetStateType != null) {
                String string2 = offsetStateType.getName();
            } else {
                String string3 = "-";
            }
        } else {
            String string4 = "-";
        }
        ReportCalcVal offsetStatus = ReportPlanSearchHeaderHelper.createCalcVal(var40_51, textType, row, col++, true);
        headerValCalcVals.add(offsetStatus);
        List<ReportCalcVal> extValList = currReportCalcModel.getExtValList();
        if (EmptyUtil.isEmpty(extValList)) {
            extValList = new ArrayList<ReportCalcVal>(10);
        }
        extValList.forEach(o -> o.setRow(o.getRow() + 3));
        extValList.addAll(headerDescCalcVals);
        extValList.addAll(headerValCalcVals);
        currReportCalcModel.setExtValList(extValList);
        List<ReportCalcVal> dataValList = currReportCalcModel.getDataValList();
        dataValList.forEach(o -> o.setRow(o.getRow() + 3));
        List<ReportCalcVal> rowDimValList = currReportCalcModel.getRowDimValList();
        rowDimValList.forEach(o -> o.setRow(o.getRow() + 3));
        List<ReportCalcVal> colDimValList = currReportCalcModel.getColDimValList();
        colDimValList.forEach(o -> o.setRow(o.getRow() + 3));
    }
}

