/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.spread.export.utils.HeaderCreateHelper;

public class SumPlanAnalysisReportHeaderHelper
extends HeaderCreateHelper {
    private static final String[] HEADER = new String[]{ResManager.loadKDString((String)"\u62a5\u8868\u540d\u79f0", (String)"AnalysisReportFormsExportAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b", (String)"AnalysisReportFormsExportAction_1", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"AnalysisReportFormsExportAction_2", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7f16\u62a5\u4e3b\u4f53", (String)"AnalysisReportFormsExportAction_3", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e01\u79cd", (String)"AnalysisReportFormsExportAction_4", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u671f\u95f4", (String)"AnalysisReportFormsExportAction_5", (String)"tmc-fpm-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u79d1\u76ee", (String)"AnalysisReportFormsExportAction_6", (String)"tmc-fpm-business", (Object[])new Object[0])};

    public static void addExcelReportHeader(Report report, ReportCalcModel currReportCalcModel, FundPlanSystem system, AnalysisHeader header) {
        List customDimensionList;
        Dimension settlementDimension;
        Optional<Dimension> settlementOP;
        Dimension companyDimension;
        Map<Long, DimMember> dimMemberMap = system.getDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        String isFilterDimProp = String.join((CharSequence)".", "dimsettingentry", "dimfilterdim");
        String selectedProp = String.join((CharSequence)",", "dimsettingentry.dimbd.number", isFilterDimProp);
        DynamicObjectCollection templateBakSettingColl = QueryServiceHelper.query((String)"fpm_template_bak", (String)selectedProp, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)report.getTemplate().getId())});
        Map<String, Boolean> filterDimMap = templateBakSettingColl.stream().filter(dy -> EmptyUtil.isNotEmpty((CharSequence)dy.getString("dimsettingentry.dimbd.number"))).collect(Collectors.toMap(dy -> dy.getString("dimsettingentry.dimbd.number"), dy -> dy.getBoolean(isFilterDimProp)));
        ReportValueType valType = SumPlanAnalysisReportHeaderHelper.getValType(ReportCellType.TEXT, null);
        ArrayList<ReportCalcVal> headerDescCalcVals = new ArrayList<ReportCalcVal>(HEADER.length);
        for (int i = 0; i < HEADER.length; ++i) {
            headerDescCalcVals.add(SumPlanAnalysisReportHeaderHelper.createCalcVal(HEADER[i], valType, 0, i, false));
        }
        int row = 1;
        int col = 0;
        ArrayList<ReportCalcVal> headerValCalcVals = new ArrayList<ReportCalcVal>(HEADER.length);
        ReportCalcVal reportNameCalcVal = SumPlanAnalysisReportHeaderHelper.createCalcVal(report.getTemplate().getName(), valType, row, col++, true);
        headerValCalcVals.add(reportNameCalcVal);
        ReportCalcVal reportTypeCalcVal = SumPlanAnalysisReportHeaderHelper.createCalcVal(ResManager.loadKDString((String)"\u7edf\u8ba1\u8868", (String)"AnalysisReportFormsExportAction_12", (String)"tmc-fpm-business", (Object[])new Object[0]), valType, row, col++, true);
        headerValCalcVals.add(reportTypeCalcVal);
        ReportCalcVal systemCalcVal = SumPlanAnalysisReportHeaderHelper.createCalcVal(system.getName(), valType, row, col++, true);
        headerValCalcVals.add(systemCalcVal);
        List<Long> orgList = header.getOrg();
        String orgStr = "-";
        if (EmptyUtil.isNoEmpty(orgList) && filterDimMap.get(DimensionType.ORG.getNumber()).booleanValue()) {
            orgStr = SumPlanAnalysisReportHeaderHelper.getMemberStr(orgList, dimMemberMap);
        }
        ReportCalcVal orgCalcVal = SumPlanAnalysisReportHeaderHelper.createCalcVal(orgStr, valType, row, col++, true);
        headerValCalcVals.add(orgCalcVal);
        List<Long> currencyIds = header.getCurrency();
        String currencyStr = "-";
        if (EmptyUtil.isNoEmpty(currencyIds)) {
            currencyStr = SumPlanAnalysisReportHeaderHelper.getMemberStr(currencyIds, dimMemberMap);
        }
        ReportCalcVal currencyCalcVal = SumPlanAnalysisReportHeaderHelper.createCalcVal(currencyStr, valType, row, col++, true);
        headerValCalcVals.add(currencyCalcVal);
        List<Long> periodIds = header.getPeriodId();
        String periodStr = "-";
        if (EmptyUtil.isNoEmpty(periodIds)) {
            periodStr = SumPlanAnalysisReportHeaderHelper.getMemberStr(periodIds.stream().distinct().collect(Collectors.toList()), dimMemberMap);
        }
        ReportCalcVal periodCalcVal = SumPlanAnalysisReportHeaderHelper.createCalcVal(periodStr, valType, row, col++, true);
        headerValCalcVals.add(periodCalcVal);
        List<Long> subjects = header.getSubjects();
        String subjectsStr = "-";
        if (EmptyUtil.isNoEmpty(subjects)) {
            subjectsStr = SumPlanAnalysisReportHeaderHelper.getMemberStr(subjects, dimMemberMap);
        }
        ReportCalcVal subjectsCalcVal = SumPlanAnalysisReportHeaderHelper.createCalcVal(subjectsStr, valType, row, col++, true);
        headerValCalcVals.add(subjectsCalcVal);
        Optional<Dimension> companyOP = SumPlanAnalysisReportHeaderHelper.seekDim(DimensionType.COMPANY, system);
        if (companyOP.isPresent() && filterDimMap.get((companyDimension = companyOP.get()).getNumber()).booleanValue()) {
            headerDescCalcVals.add(SumPlanAnalysisReportHeaderHelper.createCalcVal(companyDimension.getName(), valType, col, headerDescCalcVals.size(), false));
            String memberStr = "-";
            if (!EmptyUtil.isEmpty(header.getCompany())) {
                memberStr = SumPlanAnalysisReportHeaderHelper.getMemberStr(header.getCompany(), dimMemberMap);
            }
            ReportCalcVal companyCalcVal = SumPlanAnalysisReportHeaderHelper.createCalcVal(memberStr, valType, row, col++, true);
            headerValCalcVals.add(companyCalcVal);
        }
        if ((settlementOP = SumPlanAnalysisReportHeaderHelper.seekDim(DimensionType.SETTLEMENT_TYPE, system)).isPresent() && filterDimMap.get((settlementDimension = settlementOP.get()).getNumber()).booleanValue()) {
            headerDescCalcVals.add(SumPlanAnalysisReportHeaderHelper.createCalcVal(settlementDimension.getName(), valType, 0, col, false));
            Object memberStr = "-";
            if (!EmptyUtil.isEmpty(header.getSettlementMethod())) {
                memberStr = SumPlanAnalysisReportHeaderHelper.getMemberStr(header.getSettlementMethod(), dimMemberMap);
            }
            ReportCalcVal settlementCalcVal = SumPlanAnalysisReportHeaderHelper.createCalcVal(memberStr, valType, row, col++, true);
            headerValCalcVals.add(settlementCalcVal);
        }
        if (EmptyUtil.isNoEmpty(customDimensionList = system.getDimList().stream().filter(Objects::nonNull).filter(dimension -> dimension.getDimType() == DimensionType.CUSTOM).collect(Collectors.toList()))) {
            for (Dimension dimension2 : customDimensionList) {
                if (!filterDimMap.get(dimension2.getNumber()).booleanValue()) continue;
                List<Long> members = header.getCustomDimension().get(dimension2.getId().toString());
                headerDescCalcVals.add(SumPlanAnalysisReportHeaderHelper.createCalcVal(dimension2.getName(), valType, 0, col, false));
                String memberStr = "-";
                if (!EmptyUtil.isEmpty(members)) {
                    memberStr = SumPlanAnalysisReportHeaderHelper.getMemberStr(members, dimMemberMap);
                }
                ReportCalcVal customCalcVal = SumPlanAnalysisReportHeaderHelper.createCalcVal(memberStr, valType, row, col++, true);
                headerValCalcVals.add(customCalcVal);
            }
        }
        headerDescCalcVals.add(SumPlanAnalysisReportHeaderHelper.createCalcVal(ResManager.loadKDString((String)"\u62b5\u6d88\u72b6\u6001", (String)"AnalysisReportFormsExportAction_7", (String)"tmc-fpm-business", (Object[])new Object[0]), valType, 0, col, false));
        String innerOffset = header.getInternalOffsetState();
        String innerOffsetName = "2".equals(innerOffset) ? ResManager.loadKDString((String)"\u62b5\u6d88\u540e", (String)"AnalysisReportFormsExportAction_13", (String)"tmc-fpm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u62b5\u6d88\u524d", (String)"AnalysisReportFormsExportAction_14", (String)"tmc-fpm-business", (Object[])new Object[0]);
        ReportCalcVal innerOffsetCalcVal = SumPlanAnalysisReportHeaderHelper.createCalcVal(innerOffsetName, valType, row, col++, true);
        headerValCalcVals.add(innerOffsetCalcVal);
        headerDescCalcVals.add(SumPlanAnalysisReportHeaderHelper.createCalcVal(ResManager.loadKDString((String)"\u6298\u7b97\u5e01", (String)"AnalysisReportFormsExportAction_17", (String)"tmc-fpm-business", (Object[])new Object[0]), valType, 0, col, false));
        String currencyName = system.getCurrencyName();
        ReportCalcVal currencyNameVal = SumPlanAnalysisReportHeaderHelper.createCalcVal(currencyName, valType, row, col, true);
        headerValCalcVals.add(currencyNameVal);
        SumPlanAnalysisReportHeaderHelper.addToExtraValueList(currReportCalcModel, headerDescCalcVals, headerValCalcVals);
    }

    private static void addToExtraValueList(ReportCalcModel currReportCalcModel, List<ReportCalcVal> headerDescCalcVals, List<ReportCalcVal> headerValCalcVals) {
        List<ReportCalcVal> extValList = currReportCalcModel.getExtValList();
        if (EmptyUtil.isEmpty(extValList)) {
            extValList = new ArrayList<ReportCalcVal>(10);
        }
        extValList.forEach(o -> o.setRow(o.getRow() + 3));
        extValList.addAll(headerDescCalcVals);
        extValList.addAll(headerValCalcVals);
        currReportCalcModel.setExtValList(extValList);
        List<ReportCalcVal> dataValList = currReportCalcModel.getDataValList();
        dataValList.forEach(o -> o.setRow(o.getRow() + 3));
        List<ReportCalcVal> rowDimValList = currReportCalcModel.getRowDimValList();
        rowDimValList.forEach(o -> o.setRow(o.getRow() + 3));
        List<ReportCalcVal> colDimValList = currReportCalcModel.getColDimValList();
        colDimValList.forEach(o -> o.setRow(o.getRow() + 3));
    }
}

