/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.export.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportCellType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportValueType;
import kd.tmc.fpm.business.spread.export.utils.HeaderCreateHelper;

public class SynthesisReportHeaderHelper
extends HeaderCreateHelper {
    private static final List<String> HEADER = new ArrayList<String>(){
        {
            this.add(ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"SynthesisReportFormsExportAction_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u7edf\u8ba1\u5206\u6790\u6a21\u677f", (String)"SynthesisReportFormsExportAction_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"SynthesisReportFormsExportAction_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u6c47\u7387\u8868", (String)"SynthesisReportFormsExportAction_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u6c47\u7387\u65e5\u671f", (String)"SynthesisReportFormsExportAction_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
            this.add(ResManager.loadKDString((String)"\u91d1\u989d\u5355\u4f4d", (String)"SynthesisReportFormsExportAction_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    };

    public static void addExcelReportHeader(AnalysisHeader headerInfo, FundPlanSystem system, ReportCalcModel currReportCalcModel) {
        Optional<Dimension> settlementOP;
        ReportValueType textType = SynthesisReportHeaderHelper.getValType(ReportCellType.TEXT, null);
        Map<Long, DimMember> dimMemberMap = system.getDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        ArrayList<ReportCalcVal> headerDescCalcVals = new ArrayList<ReportCalcVal>(HEADER.size());
        for (int i = 0; i < HEADER.size(); ++i) {
            headerDescCalcVals.add(SynthesisReportHeaderHelper.createCalcVal(HEADER.get(i), textType, 0, i, false));
        }
        int row = 1;
        int col = 0;
        ArrayList<ReportCalcVal> headerValCalcVals = new ArrayList<ReportCalcVal>(HEADER.size());
        ReportCalcVal systemCalcVal = SynthesisReportHeaderHelper.createCalcVal(system.getName(), textType, row, col++, true);
        headerValCalcVals.add(systemCalcVal);
        Long analysisTemplateId = headerInfo.getAnalysisTemplateId();
        DynamicObject template = QueryServiceHelper.queryOne((String)"fpm_template", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)analysisTemplateId)});
        ReportCalcVal planVerCalcVal = SynthesisReportHeaderHelper.createCalcVal(template.getString("number"), textType, row, col++, true);
        headerValCalcVals.add(planVerCalcVal);
        List<Long> currencyIds = headerInfo.getCurrency();
        String currencyStr = "-";
        if (EmptyUtil.isNoEmpty(currencyIds)) {
            currencyStr = SynthesisReportHeaderHelper.getMemberStr(currencyIds, dimMemberMap);
        }
        ReportCalcVal currencyCalcVal = SynthesisReportHeaderHelper.createCalcVal(currencyStr, textType, row, col++, true);
        headerValCalcVals.add(currencyCalcVal);
        Long exchangeRateTableId = headerInfo.getExchangeRateTableId();
        String exchangeRateTableStr = "-";
        if (EmptyUtil.isNoEmpty((Long)exchangeRateTableId)) {
            DynamicObject exchangeRateTable = QueryServiceHelper.queryOne((String)"bd_exratetable", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)exchangeRateTableId)});
            exchangeRateTableStr = Optional.ofNullable(exchangeRateTable).map(o -> o.getString("name")).orElseGet(() -> "-");
        }
        ReportCalcVal exchangeRateTableCalcVal = SynthesisReportHeaderHelper.createCalcVal(exchangeRateTableStr, textType, row, col++, true);
        headerValCalcVals.add(exchangeRateTableCalcVal);
        Date exchangeRateDate = headerInfo.getExchangeRateDate();
        String exchangeRateDateStr = Optional.ofNullable(exchangeRateDate).map(o -> DateUtils.formatString((Date)o, (String)"yyyy-MM-dd")).orElseGet(() -> "-");
        ReportCalcVal exchangeRateDateCalcVal = SynthesisReportHeaderHelper.createCalcVal(exchangeRateDateStr, textType, row, col++, true);
        headerValCalcVals.add(exchangeRateDateCalcVal);
        AmountUnit amountUnit = headerInfo.getAmountUnit();
        ReportCalcVal amountUnitCalcVal = SynthesisReportHeaderHelper.createCalcVal(amountUnit.getName(), textType, row, col++, true);
        headerValCalcVals.add(amountUnitCalcVal);
        Optional<Dimension> companyDimOP = SynthesisReportHeaderHelper.seekDim(DimensionType.COMPANY, system);
        if (companyDimOP.isPresent()) {
            String companyStr = "-";
            Dimension companyDimension = companyDimOP.get();
            headerDescCalcVals.add(SynthesisReportHeaderHelper.createCalcVal(companyDimension.getName(), textType, 0, headerDescCalcVals.size(), false));
            if (EmptyUtil.isNoEmpty(headerInfo.getCompany())) {
                companyStr = SynthesisReportHeaderHelper.getMemberStr(headerInfo.getCompany(), dimMemberMap);
            }
            ReportCalcVal companyCalcVal = SynthesisReportHeaderHelper.createCalcVal(companyStr, textType, row, col++, true);
            headerValCalcVals.add(companyCalcVal);
        }
        if ((settlementOP = SynthesisReportHeaderHelper.seekDim(DimensionType.SETTLEMENT_TYPE, system)).isPresent()) {
            Dimension settlementDimension = settlementOP.get();
            headerDescCalcVals.add(SynthesisReportHeaderHelper.createCalcVal(settlementDimension.getName(), textType, 0, headerDescCalcVals.size(), false));
            String settlementStr = "-";
            if (EmptyUtil.isNoEmpty(headerInfo.getSettlementMethod())) {
                settlementStr = SynthesisReportHeaderHelper.getMemberStr(headerInfo.getSettlementMethod(), dimMemberMap);
            }
            ReportCalcVal settlementCalcVal = SynthesisReportHeaderHelper.createCalcVal(settlementStr, textType, row, col++, true);
            headerValCalcVals.add(settlementCalcVal);
        }
        SynthesisReportHeaderHelper.addCustomCalcValsIfFilter(headerDescCalcVals, headerValCalcVals, row, col, system, headerInfo, dimMemberMap);
        List<ReportCalcVal> extValList = currReportCalcModel.getExtValList();
        if (EmptyUtil.isEmpty(extValList)) {
            extValList = new ArrayList<ReportCalcVal>(10);
        }
        extValList.forEach(o -> o.setRow(o.getRow() + 3));
        extValList.addAll(headerDescCalcVals);
        extValList.addAll(headerValCalcVals);
        currReportCalcModel.setExtValList(extValList);
        List<ReportCalcVal> dataValList = currReportCalcModel.getDataValList();
        dataValList.forEach(o -> o.setRow(o.getRow() + 3));
        List<ReportCalcVal> rowDimValList = currReportCalcModel.getRowDimValList();
        rowDimValList.forEach(o -> o.setRow(o.getRow() + 3));
        List<ReportCalcVal> colDimValList = currReportCalcModel.getColDimValList();
        colDimValList.forEach(o -> o.setRow(o.getRow() + 3));
    }

    public static void addCustomCalcValsIfFilter(List<ReportCalcVal> headerDescCalcVals, List<ReportCalcVal> headerValCalcVals, Integer row, Integer col, FundPlanSystem system, AnalysisHeader headerInfo, Map<Long, DimMember> dimMemberMap) {
        List customDimensions = system.getDimList().stream().filter(Objects::nonNull).filter(dim -> dim.getDimType() == DimensionType.CUSTOM).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(customDimensions)) {
            return;
        }
        String isFilterDimProp = String.join((CharSequence)".", "dimsettingentry", "dimfilterdim");
        String selectedProp = String.join((CharSequence)",", "dimsettingentry.dimbd.number", isFilterDimProp);
        DynamicObjectCollection templateBakSettingColl = QueryServiceHelper.query((String)"fpm_template", (String)selectedProp, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)headerInfo.getAnalysisTemplateId())});
        Map<String, Boolean> filterDimMap = templateBakSettingColl.stream().filter(dy -> EmptyUtil.isNotEmpty((CharSequence)dy.getString("dimsettingentry.dimbd.number"))).collect(Collectors.toMap(dy -> dy.getString("dimsettingentry.dimbd.number"), dy -> dy.getBoolean(isFilterDimProp)));
        ReportValueType textType = SynthesisReportHeaderHelper.getValType(ReportCellType.TEXT, null);
        for (Dimension customDimension : customDimensions) {
            String number = customDimension.getNumber();
            Optional<Dimension> dimensionOp = SynthesisReportHeaderHelper.seekCustomDim(number, system);
            if (!dimensionOp.isPresent()) continue;
            Dimension dimension = dimensionOp.get();
            if (!filterDimMap.get(customDimension.getNumber()).booleanValue()) continue;
            List<Long> memberIdList = SynthesisReportHeaderHelper.getCustomMemberList(headerInfo.getCustomDimension(), number);
            headerDescCalcVals.add(SynthesisReportHeaderHelper.createCalcVal(dimension.getName(), textType, 0, headerDescCalcVals.size(), false));
            String memberStr = "-";
            if (EmptyUtil.isNoEmpty(memberIdList)) {
                memberStr = SynthesisReportHeaderHelper.getMemberStr(memberIdList, dimMemberMap);
            }
            Integer n = col;
            Integer n2 = col = Integer.valueOf(col + 1);
            ReportCalcVal settlementCalcVal = SynthesisReportHeaderHelper.createCalcVal(memberStr, textType, row, n, true);
            headerValCalcVals.add(settlementCalcVal);
        }
    }
}

