/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.formula;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaCalculatorFactory;
import kd.tmc.fpm.business.spread.formula.IFormulaCalculatorV2;
import kd.tmc.fpm.business.spread.formula.impl.DAGEdge;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;
import kd.tmc.fpm.business.spread.formula.impl.DAGNodeVisitListener;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;

public class CalculateCellDataVisitListener
implements DAGNodeVisitListener<String> {
    private static final Log logger = LogFactory.getLog(CalculateCellDataVisitListener.class);
    private Set<CacheCell> reCalcValSet;
    public IFormulaCalculatorV2 calculator = FormulaCalculatorFactory.createFormulaCalculatorV2();
    private CellDataSource dataSource;

    public CalculateCellDataVisitListener(CellDataSource dataSource) {
        this.reCalcValSet = new HashSet<CacheCell>(10);
        this.dataSource = dataSource;
    }

    @Override
    public void visit(DAGNode<String> node) {
        String positionStr = node.getVal();
        if (NumberUtils.isNumber((String)positionStr)) {
            return;
        }
        int col = ExcelUtils.pos2X((String)positionStr);
        int row = ExcelUtils.pos2Y((String)positionStr);
        CacheCell cell = this.dataSource.getCell(row, col);
        Formula formula = node.getFormula();
        if (!CollectionUtils.isEmpty(node.getEdges())) {
            BigDecimal val = BigDecimal.ZERO;
            if (formula != null) {
                val = this.calculator.calculate(formula, this.dataSource);
            } else if (!CollectionUtils.isEmpty(node.getEdges())) {
                Set<DAGEdge<String>> edges = node.getEdges();
                for (DAGEdge<String> edge : edges) {
                    DAGNode<String> destNode = edge.getDestNode();
                    try {
                        CacheCell edgeCell = this.dataSource.getCell(ExcelUtils.pos2Y((String)destNode.getVal()), ExcelUtils.pos2X((String)destNode.getVal()));
                        edgeCell.setValue(edgeCell.getValue());
                        val = val.add(new BigDecimal(edgeCell.getValue().toString()));
                    }
                    catch (Exception e) {
                        logger.warn((Throwable)e);
                    }
                }
            }
            cell.setValue(val);
        } else if (cell.isSummary()) {
            cell.setValue(0);
        }
        this.reCalcValSet.add(cell);
    }

    public Set<CacheCell> getReCacheCellSet() {
        return this.reCalcValSet;
    }
}

