/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.formula;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaCalculatorFactory;
import kd.tmc.fpm.business.spread.formula.IFormulaCalculatorV2;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;
import kd.tmc.fpm.business.spread.formula.impl.DAGNodeVisitListener;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ReCalculateNodeVisitListenerV2
implements DAGNodeVisitListener<String> {
    private static final Log logger = LogFactory.getLog(ReCalculateNodeVisitListenerV2.class);
    private Set<ReportCalcVal> reCalcValSet;
    public IFormulaCalculatorV2 calculator = FormulaCalculatorFactory.createFormulaCalculatorV2();
    private ReportCalcModel reportCalcModel;
    private boolean onlyCalcSummary;

    private ReCalculateNodeVisitListenerV2() {
        this.reCalcValSet = new HashSet<ReportCalcVal>(10);
    }

    public ReCalculateNodeVisitListenerV2(ReportCalcModel reportCalcModel) {
        this();
        this.reportCalcModel = reportCalcModel;
    }

    public ReCalculateNodeVisitListenerV2(ReportCalcModel reportCalcModel, Boolean onlyCalcSummary) {
        this();
        this.reportCalcModel = reportCalcModel;
        this.onlyCalcSummary = onlyCalcSummary;
    }

    @Override
    public void visit(DAGNode<String> node) {
        int row;
        String crood = node.getVal();
        if (NumberUtils.isNumber((String)crood)) {
            return;
        }
        int col = ExcelUtils.pos2X((String)crood);
        ReportCalcVal reportCalcVal = this.reportCalcModel.getReportCalcVal(col, row = ExcelUtils.pos2Y((String)crood));
        if (reportCalcVal != null) {
            Formula formula = reportCalcVal.getFormula();
            if (this.onlyCalcSummary && !reportCalcVal.isSummary()) {
                return;
            }
            if (formula != null) {
                BigDecimal val = this.calculator.calculate(formula, this.reportCalcModel);
                BigDecimal orgVal = reportCalcVal.getValue() == null ? BigDecimal.ZERO : new BigDecimal(reportCalcVal.getValue().toString());
                reportCalcVal.setDirty(Objects.isNull(val) || orgVal.compareTo(val) != 0);
                reportCalcVal.setValue(val);
                reportCalcVal.setDisplayVal(val == null ? null : val.toString());
                this.reCalcValSet.add(reportCalcVal);
            }
        }
    }

    public Set<ReportCalcVal> getReCalcValSet() {
        return this.reCalcValSet;
    }
}

