/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.formula.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.tmc.fpm.business.spread.formula.IDAGManager;
import kd.tmc.fpm.business.spread.formula.IDAGVisit;
import kd.tmc.fpm.business.spread.formula.impl.DAGEdge;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;
import kd.tmc.fpm.business.spread.formula.impl.DAGNodeVisitListener;

public class DAGVisit<T>
implements IDAGVisit<T>,
Serializable {
    private transient IDAGManager<T> manager;
    private transient List<DAGNodeVisitListener<T>> listeners;

    public DAGVisit(IDAGManager<T> dagManager) {
        this.manager = dagManager;
        this.listeners = new ArrayList<DAGNodeVisitListener<T>>();
    }

    @Override
    public void addNodeVisitListener(DAGNodeVisitListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void visitNode(DAGNode<T> startNode, boolean isFirstVisit) {
        this.visitNode(startNode, new HashSet(), isFirstVisit, this.listeners);
    }

    @Override
    public void orderVisitNode(DAGNode<T> startNode) {
        this.orderVisitNode(startNode, false);
    }

    @Override
    public void orderVisitNode(DAGNode<T> startNode, boolean ignoreCurrentNode) {
        HashSet visitedNodeSet = new HashSet();
        DAGNode<T> reversedNode = this.manager.getByRevertMap(startNode.getVal());
        if (reversedNode == null) {
            return;
        }
        this.visitNode(reversedNode, new HashSet(), true, Collections.singletonList(node -> visitedNodeSet.add(node.getVal())));
        for (DAGNode<T> node2 : this.manager.getOrderedList()) {
            if (ignoreCurrentNode && node2 == startNode || !visitedNodeSet.contains(node2.getVal())) continue;
            this.notifyNodeVisited(this.listeners, node2);
        }
    }

    @Override
    public void visitAllNodes(boolean isFirstVisit) {
        ArrayList<DAGNode<T>> sortedNodeList = new ArrayList<DAGNode<T>>(this.manager.getVertexMap().values());
        sortedNodeList.sort((o1, o2) -> o2.getWeight() - o1.getWeight());
        HashSet visitedNode = new HashSet();
        for (DAGNode dAGNode : sortedNodeList) {
            this.visitNode(dAGNode, visitedNode, isFirstVisit, this.listeners);
        }
    }

    @Override
    public DAGNode<T> get(T val) {
        return this.manager.get(val);
    }

    private void visitNode(DAGNode<T> node, Set<T> visitedNode, boolean isFirstVisit, List<DAGNodeVisitListener<T>> listeners) {
        Set<DAGEdge<T>> edges;
        if (visitedNode.contains(node.getVal())) {
            return;
        }
        visitedNode.add(node.getVal());
        if (isFirstVisit) {
            this.notifyNodeVisited(listeners, node);
        }
        if ((edges = node.getEdges()) != null && edges.size() > 0) {
            ArrayList<DAGEdge<T>> sortedList = new ArrayList<DAGEdge<T>>(edges);
            sortedList.sort((o1, o2) -> o2.getLen() - o1.getLen());
            for (DAGEdge dAGEdge : sortedList) {
                DAGNode destNode = dAGEdge.getDestNode();
                this.visitNode(destNode, visitedNode, isFirstVisit, listeners);
            }
        }
        if (!isFirstVisit) {
            this.notifyNodeVisited(listeners, node);
        }
    }

    private void notifyNodeVisited(List<DAGNodeVisitListener<T>> listeners, DAGNode<T> node) {
        if (listeners != null) {
            for (DAGNodeVisitListener<T> listener : listeners) {
                listener.visit(node);
            }
        }
    }

    public List<DAGNodeVisitListener<T>> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<DAGNodeVisitListener<T>> listeners) {
        this.listeners = listeners;
    }
}

