/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.formula.impl;

import java.math.BigDecimal;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.mvc.repository.IReportPlanRepository;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.FormulaOperatorSymbol;
import kd.tmc.fpm.business.spread.formula.IFormulaCalculator;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.spread.formula.enums.FormulaOperationValType;
import kd.tmc.fpm.spread.utils.ExcelUtils;

public class JSFormulaCalculator
implements IFormulaCalculator {
    private static final Log logger = LogFactory.getLog(JSFormulaCalculator.class);
    private static ScriptEngine jsEngine = new ScriptEngineManager().getEngineByName("JavaScript");

    @Override
    public BigDecimal calculate(Formula formula, IReportPlanRepository repository) {
        return this.calculate(formula, repository, null);
    }

    @Override
    public BigDecimal calculate(Formula formula, List<ReportCalcVal> reportDataList) {
        return this.calculate(formula, null, reportDataList);
    }

    @Override
    public BigDecimal calculate(Formula formula, Map<String, ReportCalcVal> reportCalcValMap) {
        return this.doCalculate(formula, null, reportCalcValMap);
    }

    private BigDecimal calculate(Formula formula, IReportPlanRepository repository, List<ReportCalcVal> reportDataList) {
        if (formula == null) {
            return null;
        }
        Map<String, ReportCalcVal> reportCalcValMap = reportDataList.stream().collect(Collectors.toMap(rd -> rd.getRow() + "_" + rd.getCol(), Function.identity(), (k1, k2) -> k1));
        return this.doCalculate(formula, repository, reportCalcValMap);
    }

    private BigDecimal doCalculate(Formula formula, IReportPlanRepository repository, Map<String, ReportCalcVal> reportCalcValMap) {
        HashMap<Integer, List<ReportCalcVal>> rowDataMap = new HashMap<Integer, List<ReportCalcVal>>();
        Deque<IFormulaOperator> rightOperators = formula.getOperator();
        StringBuilder formulaStr = new StringBuilder();
        StringBuilder express = new StringBuilder();
        for (IFormulaOperator rightOperator : rightOperators) {
            Object value = BigDecimal.ZERO;
            if (rightOperator instanceof FormulaOperationVal) {
                FormulaOperationVal formulaOp = (FormulaOperationVal)rightOperator;
                FormulaOperationValType valType = formulaOp.getValType();
                if (valType == FormulaOperationValType.POSITION) {
                    ReportCalcVal reportCalcVal;
                    String crood = formulaOp.getName();
                    int col = ExcelUtils.pos2X((String)crood);
                    int row = ExcelUtils.pos2Y((String)crood);
                    if (reportCalcValMap == null || reportCalcValMap.isEmpty()) {
                        List<ReportCalcVal> currRowDataS = (List<ReportCalcVal>)rowDataMap.get(row);
                        if (currRowDataS == null) {
                            currRowDataS = repository.getCurrRowData(row);
                            rowDataMap.put(row, currRowDataS);
                        }
                        formulaStr.append(crood);
                        reportCalcVal = currRowDataS.stream().filter(item -> item.getCol() == col).findFirst().get();
                    } else {
                        reportCalcVal = reportCalcValMap.get(row + "_" + col);
                    }
                    value = Optional.ofNullable(reportCalcVal).map(ReportCalcVal::getValue).orElse("0");
                } else if (valType == FormulaOperationValType.CONSTANT) {
                    value = formulaOp.getValue();
                }
                String expressStr = value.toString();
                if (new BigDecimal(value.toString()).compareTo(BigDecimal.ZERO) < 0) {
                    expressStr = String.format("(%1$s)", expressStr);
                }
                express.append(expressStr);
            }
            if (!(rightOperator instanceof FormulaOperatorSymbol)) continue;
            FormulaOperatorSymbol formulaOperatorSymbol = (FormulaOperatorSymbol)rightOperator;
            String opSymbol = formulaOperatorSymbol.getOpSymbol().getSymbol();
            formulaStr.append(opSymbol);
            express.append(opSymbol);
        }
        Object result = null;
        String expressScript = express.toString().trim().replace(" ", "");
        if (EmptyUtil.isNotEmpty((CharSequence)expressScript)) {
            try {
                result = jsEngine.eval(expressScript);
            }
            catch (ScriptException e) {
                String errMsg = String.format(ResManager.loadKDString((String)"JS \u811a\u672c\u5f15\u64ce\u8ba1\u7b97\u8868\u8fbe\u5f0f\u5931\u8d25\uff0c\u8ba1\u7b97\u516c\u5f0f\u4e3a\uff1a%1$s\uff0c\u8ba1\u7b97\u8868\u8fbe\u5f0f\u4e3a\uff1a%2$s\u3002\u62a5\u9519\u4fe1\u606f\u5982\u4e0b\uff1a\n", (String)"JSFormulaCalculator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), formulaStr, expressScript);
                logger.error(errMsg, (Throwable)e);
            }
        }
        return Optional.ofNullable(result).map(o -> new BigDecimal(o.toString())).orElse(null);
    }
}

