/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.spread.formula.impl;

import java.math.BigDecimal;
import java.util.Deque;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.FormulaOperatorSymbol;
import kd.tmc.fpm.business.spread.formula.IFormulaCalculatorV2;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.spread.formula.enums.FormulaOperationValType;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.spread.utils.ExcelUtils;

public class JSFormulaCalculatorV2
implements IFormulaCalculatorV2 {
    private static final Log logger = LogFactory.getLog(JSFormulaCalculatorV2.class);

    @Override
    public BigDecimal calculate(Formula formula, CellDataSource dataSource) {
        return this.calculate(formula, dataSource, null);
    }

    @Override
    public BigDecimal calculate(Formula formula, ReportCalcModel reportCalcModel) {
        return this.calculate(formula, null, reportCalcModel);
    }

    private BigDecimal calculate(Formula formula, CellDataSource dataSource, ReportCalcModel reportCalcModel) {
        Object result;
        StringBuilder sb = new StringBuilder();
        Deque<IFormulaOperator> rightOperators = formula.getOperator();
        int idx = 0;
        HashMap<String, BigDecimal> variableMap = new HashMap<String, BigDecimal>(rightOperators.size());
        for (IFormulaOperator rightOperator : rightOperators) {
            BigDecimal value = BigDecimal.ZERO;
            if (rightOperator instanceof FormulaOperationVal) {
                String symbol = "x" + idx++;
                sb.append(symbol);
                FormulaOperationVal formulaOp = (FormulaOperationVal)rightOperator;
                FormulaOperationValType valType = formulaOp.getValType();
                if (valType == FormulaOperationValType.POSITION) {
                    String crood = formulaOp.getName();
                    int col = ExcelUtils.pos2X((String)crood);
                    int row = ExcelUtils.pos2Y((String)crood);
                    ReportCalcVal reportCalcVal = null;
                    if (reportCalcModel == null) {
                        value = BigDecimal.ZERO;
                        CacheCell cell = dataSource.getCell(row, col);
                        if (Objects.nonNull((Object)cell) && Objects.nonNull(cell.getValue())) {
                            value = new BigDecimal(cell.getValue().toString());
                        }
                    } else {
                        reportCalcVal = reportCalcModel.getReportCalcVal(col, row);
                        value = BigDecimal.ZERO;
                        if (Objects.nonNull(reportCalcVal) && Objects.nonNull(reportCalcVal.getValue())) {
                            value = new BigDecimal(reportCalcVal.getValue().toString());
                        }
                    }
                } else if (valType == FormulaOperationValType.CONSTANT) {
                    value = new BigDecimal(formulaOp.getValue());
                }
                variableMap.put(symbol, value);
                continue;
            }
            if (!(rightOperator instanceof FormulaOperatorSymbol)) continue;
            FormulaOperatorSymbol formulaOperatorSymbol = (FormulaOperatorSymbol)rightOperator;
            String opSymbol = formulaOperatorSymbol.getOpSymbol().getSymbol();
            sb.append(opSymbol);
        }
        String amtExpressScript = sb.toString().trim().replace(" ", "");
        if (EmptyUtil.isEmpty((String)amtExpressScript)) {
            return BigDecimal.ZERO;
        }
        String script = MetricValueUtils.handleNum(amtExpressScript);
        Expr expr = FormulaEngine.parseFormula((String)script);
        try {
            result = FormulaEngine.execExcelFormula((Expr)expr, variableMap);
        }
        catch (Throwable ex) {
            if (ex instanceof ArithmeticException) {
                result = BigDecimal.ZERO;
            }
            if (ex instanceof FormulaException) {
                result = BigDecimal.ZERO;
            }
            throw new KDBizException(ex.getMessage());
        }
        return new BigDecimal(result.toString());
    }
}

